/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.armor;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import io.github.Memoires.trbeyond.items.BeyondArmourMaterials;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.armor.BeyondArmorItem;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;

public class SerpentArmorItem
extends BeyondArmorItem {
    public SerpentArmorItem(ArmorMaterial material, EquipmentSlot equipmentSlot, Rarity rarity) {
        super(material, equipmentSlot, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(rarity));
    }

    public SerpentArmorItem(EquipmentSlot slot, Grade grade) {
        this(grade.getMaterial(), slot, grade.getRarity());
    }

    public boolean m_5812_(ItemStack stack) {
        if (!stack.m_41793_()) {
            return false;
        }
        Set enchantments = stack.getAllEnchantments().keySet();
        return enchantments.size() != 1 || stack.getEnchantmentLevel((Enchantment)TensuraEnchantments.STURDY.get()) <= 0;
    }

    public static void applySturdy(ItemStack toStack, ItemStack fromStack, LivingEntity entity, EquipmentSlot toSlot) {
        Enchantment enchantment = (Enchantment)TensuraEnchantments.STURDY.get();
        Predicate<ItemStack> predicate = stack -> stack.m_41720_() instanceof SerpentArmorItem;
        if (predicate.test(toStack) && toStack.getEnchantmentLevel(enchantment) < 1) {
            EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)enchantment, (int)1);
        }
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) {
            return;
        }
        if (BeyondArmorItem.hasFullSet(entity, predicate, 4)) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack2;
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) || (stack2 = entity.m_6844_(slot)).getEnchantmentLevel(enchantment) >= 2) continue;
                EngravingEnchantment.engrave((ItemStack)stack2, (Enchantment)enchantment, (int)2);
            }
        } else {
            if (fromStack.m_41720_() instanceof SerpentArmorItem && fromStack.getEnchantmentLevel(enchantment) == 2) {
                EngravingEnchantment.engrave((ItemStack)fromStack, (Enchantment)enchantment, (int)1);
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack3;
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) || (stack3 = entity.m_6844_(slot)).getEnchantmentLevel(enchantment) != 2) continue;
                EngravingEnchantment.engrave((ItemStack)stack3, (Enchantment)enchantment, (int)1);
            }
        }
    }

    public static enum Grade {
        UNIQUE(BeyondArmourMaterials.SERPENT_UNIQUE, BeyondRarity.UNIQUE),
        LEGEND(BeyondArmourMaterials.SERPENT_LEGEND, BeyondRarity.LEGEND),
        GOD(BeyondArmourMaterials.SERPENT_GOD, BeyondRarity.GOD);

        private final ArmorMaterial material;
        private final Rarity rarity;

        public ArmorMaterial getMaterial() {
            return this.material;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(ArmorMaterial material, Rarity rarity) {
            this.material = material;
            this.rarity = rarity;
        }
    }
}

