/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.armor;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.Memoires.trbeyond.items.BeyondArmourMaterials;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.armor.BeyondArmorItem;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;

public class ShionArmorItem
extends BeyondArmorItem {
    public ShionArmorItem(ArmorMaterial material, EquipmentSlot equipmentSlot, Rarity rarity) {
        super(material, equipmentSlot, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(rarity));
    }

    public ShionArmorItem(EquipmentSlot slot, Grade grade) {
        this(grade.getMaterial(), slot, grade.getRarity());
    }

    public static void applyBattleInfusion(ItemStack toStack, ItemStack fromStack, LivingEntity entity, EquipmentSlot toSlot) {
        Item item;
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) {
            return;
        }
        Enchantment enchantment = (Enchantment)BeyondEnchantments.BATTLE_INFUSION.get();
        Enchantment tsukumogami = (Enchantment)TensuraEnchantments.TSUKUMOGAMI.get();
        Predicate<ItemStack> isGodGrade = stack -> {
            Item patt1977$temp = stack.m_41720_();
            if (patt1977$temp instanceof ShionArmorItem) {
                ShionArmorItem armorItem = (ShionArmorItem)patt1977$temp;
                return armorItem.m_40401_() == BeyondArmourMaterials.SHION_GOD;
            }
            return false;
        };
        if (BeyondArmorItem.hasFullSet(entity, isGodGrade, 4)) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack2;
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) || !isGodGrade.test(stack2 = entity.m_6844_(slot)) || stack2.getEnchantmentLevel(enchantment) >= 3) continue;
                EngravingEnchantment.engrave((ItemStack)stack2, (Enchantment)enchantment, (int)1);
            }
        }
        if ((item = toStack.m_41720_()) instanceof ShionArmorItem) {
            ShionArmorItem item2 = (ShionArmorItem)item;
            if (toStack.getEnchantmentLevel(tsukumogami) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)tsukumogami, (int)1);
            }
            if (item2.m_40401_().equals((Object)BeyondArmourMaterials.SHION_GOD) && toStack.getEnchantmentLevel(enchantment) < 2) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)enchantment, (int)1);
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.FEET) {
            return ImmutableMultimap.of();
        }
        return super.m_7167_(slot);
    }

    public boolean isDamageable(ItemStack stack) {
        return !this.f_40377_.equals((Object)EquipmentSlot.FEET);
    }

    public static enum Grade {
        UNIQUE(BeyondArmourMaterials.SHION_UNIQUE, BeyondRarity.UNIQUE),
        LEGEND(BeyondArmourMaterials.SHION_LEGEND, BeyondRarity.LEGEND),
        GOD(BeyondArmourMaterials.SHION_GOD, BeyondRarity.GOD),
        SPECIAL(BeyondArmourMaterials.SHION_SPECIAL, BeyondRarity.SPECIAL);

        private final ArmorMaterial material;
        private final Rarity rarity;

        public ArmorMaterial getMaterial() {
            return this.material;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(ArmorMaterial material, Rarity rarity) {
            this.material = material;
            this.rarity = rarity;
        }
    }
}

