/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.custom;

import com.github.manasmods.tensura.util.TensuraRarity;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DungeonMapItem
extends Item {
    private static final Component failedMessage = Component.m_237113_((String)"Whatever this map points to is too far away...");

    public DungeonMapItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(TensuraRarity.UNIQUE).m_41487_(1));
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"trbeyond.tooltip.dungeon_map").m_130940_(ChatFormatting.DARK_AQUA));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer;
            ServerLevel serverLevel = (serverPlayer = (ServerPlayer)player).m_9236_();
            BlockPos foundPos = DungeonMapItem.findStructure(serverLevel, serverPlayer.m_20183_());
            serverPlayer.m_213846_((Component)(foundPos == null ? failedMessage : Component.m_237113_((String)String.format("This map shows a large structure located at: X: %s, Z: %s", foundPos.m_123341_(), foundPos.m_123343_()))));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public static BlockPos findStructure(ServerLevel level, BlockPos pos) {
        ResourceLocation tagLocation = new ResourceLocation("trbeyond", "colosseum");
        TagKey structureTag = TagKey.m_203882_((ResourceKey)BuiltinRegistries.f_235988_.m_123023_(), (ResourceLocation)tagLocation);
        Iterable holders = level.m_5962_().m_175515_(BuiltinRegistries.f_235988_.m_123023_()).m_206058_(structureTag);
        for (Holder holder : holders) {
            TagKey key;
            BlockPos foundPos;
            if (!holder.m_203543_().isPresent() || (foundPos = level.m_215011_(key = TagKey.m_203882_((ResourceKey)BuiltinRegistries.f_235988_.m_123023_(), (ResourceLocation)((ResourceKey)holder.m_203543_().get()).m_135782_()), pos, 10000, false)) == null) continue;
            return foundPos;
        }
        return null;
    }

    public static Component getFailedMessage() {
        return failedMessage;
    }
}

