/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.custom;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestTotemDisplayPacket;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.TensuraRarity;
import io.github.Memoires.trbeyond.capability.player.BeyondPlayerCapability;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordingCrystalItem
extends Item {
    public RecordingCrystalItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(TensuraRarity.UNIQUE).m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("savedY")) {
            String dimensionKey = stack.m_41783_().m_128461_("savedDimension");
            pTooltipComponents.add((Component)Component.m_237110_((String)"trbeyond.tooltip.recording_crystal.saved", (Object[])new Object[]{stack.m_41783_().m_128459_("savedX"), stack.m_41783_().m_128459_("savedY"), stack.m_41783_().m_128459_("savedZ")}).m_130940_(ChatFormatting.LIGHT_PURPLE));
            pTooltipComponents.add((Component)Component.m_237113_((String)("Dimension: " + dimensionKey)).m_130940_(ChatFormatting.GOLD));
        }
        pTooltipComponents.add((Component)Component.m_237115_((String)"trbeyond.tooltip.recording_crystal").m_130940_(ChatFormatting.DARK_AQUA));
    }

    public int m_8105_(ItemStack pStack) {
        return 10000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_("savedY");
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(pHand);
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("savedY")) {
            if (!level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                player.m_5661_((Component)Component.m_237110_((String)"trbeyond.tooltip.items_dungeon_only", (Object[])new Object[]{stack.m_41786_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            Vec3 pos = Vec3.m_82512_((Vec3i)player.m_20183_());
            stack.m_41784_().m_128347_("savedX", pos.m_7096_());
            stack.m_41784_().m_128347_("savedY", pos.m_7098_());
            stack.m_41784_().m_128347_("savedZ", pos.m_7094_());
            stack.m_41784_().m_128359_("savedDimension", level.m_46472_().m_135782_().toString());
            level.m_6263_(null, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123810_, (double)1.0);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        player.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pRemainingUseDuration % 2 == 0) {
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)pLivingEntity, (ParticleOptions)ParticleTypes.f_123810_, (double)3.0);
        }
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int pTimeLeft) {
        if (level.m_5776_()) {
            return;
        }
        if (stack.m_41783_() == null) {
            return;
        }
        if (!stack.m_41783_().m_128441_("savedY")) {
            return;
        }
        int useTicks = this.m_8105_(stack) - pTimeLeft;
        if (useTicks < 10) {
            return;
        }
        BlockPos pos = new BlockPos(stack.m_41783_().m_128459_("savedX"), stack.m_41783_().m_128459_("savedY"), stack.m_41783_().m_128459_("savedZ"));
        String savedDimensionKey = stack.m_41783_().m_128461_("savedDimension");
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MinecraftServer server = level.m_7654_();
            if (server == null) {
                return;
            }
            ServerLevel targetLevel = server.m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY);
            if (targetLevel == null) {
                player.m_5661_((Component)Component.m_237113_((String)"Teleport failed: Dungeon dimension not found.").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            BlockPos lobbyPos = new BlockPos(9, 117, 7);
            List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), living -> living.m_6084_() && (living.m_7307_((Entity)entity) || living.m_7306_((Entity)entity)));
            for (LivingEntity target : list) {
                SkillHelper.moveAcrossDimensionTo((Entity)target, (double)lobbyPos.m_123341_(), (double)lobbyPos.m_123342_(), (double)lobbyPos.m_123343_(), (float)0.0f, (float)0.0f, (ServerLevel)targetLevel);
            }
            boolean isSafeLocation = RecordingCrystalItem.isSafeLocation(targetLevel, pos);
            boolean teleportedToLobby = false;
            System.out.println("DEBUG: Now in dungeon, checking safety for coordinates (" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")");
            System.out.println("DEBUG: Location is safe: " + isSafeLocation);
            player.m_5661_((Component)Component.m_237113_((String)"Teleporting to saved location...").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
            for (LivingEntity target : list) {
                SkillHelper.moveAcrossDimensionTo((Entity)target, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (float)0.0f, (float)0.0f, (ServerLevel)targetLevel);
            }
            if (level.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY) || targetLevel.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
                BeyondPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                    cap.setUsedTicket(true);
                    cap.setReturned(false);
                    cap.setUsedCrystal(true);
                });
                BeyondPlayerCapability.sync((Player)player);
            }
            TensuraNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestTotemDisplayPacket(this.m_7968_()));
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123810_, (double)1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)TensuraParticles.SOLAR_FLASH.get()), (double)2.0);
            if (teleportedToLobby) {
                if (stack.m_41783_() != null) {
                    stack.m_41783_().m_128473_("savedX");
                    stack.m_41783_().m_128473_("savedY");
                    stack.m_41783_().m_128473_("savedZ");
                    stack.m_41783_().m_128473_("savedDimension");
                    if (stack.m_41783_().m_128456_()) {
                        stack.m_41751_(null);
                    }
                }
                player.m_5661_((Component)Component.m_237113_((String)"Recording Crystal has been reset due to unsafe teleport.").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), false);
            } else if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123810_, (double)1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)TensuraParticles.SOLAR_FLASH.get()), (double)2.0);
        }
    }

    public static boolean isSafeLocation(ServerLevel level, BlockPos pos) {
        System.out.println("DEBUG: Checking safety at " + String.valueOf(pos));
        LevelChunk chunkAccess = level.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (chunkAccess == null) {
            System.out.println("DEBUG: Chunk not loaded \u2014 attempting to load...");
            try {
                level.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
                System.out.println("DEBUG: Chunk loaded successfully.");
            }
            catch (Exception e) {
                System.out.println("DEBUG: Failed to load chunk: " + e.getMessage());
                return false;
            }
        }
        BlockPos checkPos = pos;
        boolean foundSolid = false;
        for (int i = 0; i < 15; ++i) {
            if (!level.m_8055_(checkPos).m_60795_()) {
                foundSolid = true;
                System.out.println("DEBUG: Found solid block at Y=" + checkPos.m_123342_() + " (block: " + level.m_8055_(checkPos).m_60734_().m_49954_().getString() + ")");
                break;
            }
            if ((checkPos = checkPos.m_7495_()).m_123342_() >= level.m_141937_()) continue;
            System.out.println("DEBUG: Reached build floor");
            break;
        }
        if (!foundSolid) {
            System.out.println("DEBUG: No solid blocks found \u2014 location is in void or dungeon was reset");
            return false;
        }
        System.out.println("DEBUG: Location appears safe");
        return true;
    }
}

