/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.custom;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.extra.ShadowMotionSkill;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.item.custom.ShadowStorageItem;
import com.github.manasmods.tensura.util.TensuraRarity;
import io.github.Memoires.trbeyond.client.screen.SubspaceContainerMenu;
import io.github.Memoires.trbeyond.container.SubspacePocketContainer;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.registry.items.BeyondItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SubspacePocketItem
extends Item {
    public int storageCapacity;
    public int maxStackSize;
    public int subordinateCapacity;

    public SubspacePocketItem(int storageCapacity, int maxStackSize, int subordinateCapacity) {
        super(new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(TensuraRarity.UNIQUE).m_41487_(1));
        this.storageCapacity = storageCapacity;
        this.maxStackSize = maxStackSize;
        this.subordinateCapacity = subordinateCapacity;
    }

    public boolean m_142095_() {
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player pPlayer, InteractionHand hand) {
        ItemStack stack = pPlayer.m_21120_(hand);
        if (!level.f_46443_ && stack.m_41720_() instanceof SubspacePocketItem && !pPlayer.m_6047_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player) -> new SubspaceContainerMenu(windowId, playerInventory, player, stack), stack.m_41611_()), buffer -> buffer.m_130055_(stack));
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        SubspaceContainerMenu subspaceContainerMenu;
        AbstractContainerMenu abstractContainerMenu;
        if (player.m_242612_() && (abstractContainerMenu = player.f_36096_) instanceof SubspaceContainerMenu && (subspaceContainerMenu = (SubspaceContainerMenu)abstractContainerMenu).isThisContainerItem(item)) {
            player.m_6915_();
        }
        return true;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        Level level = pContext.m_43725_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player != null && player.m_6047_() && level.m_7966_(player, pContext.m_8083_())) {
                ItemStack stack = pContext.m_43722_();
                SubspacePocketContainer container = new SubspacePocketContainer(this.storageCapacity, this.maxStackSize, this.subordinateCapacity);
                container.m_7797_(stack.m_41784_().m_128437_("SpatialStorage", 10));
                int subordinateIndex = container.getFirstSubordinateItemIndex();
                if (subordinateIndex != -1) {
                    ItemStack shadow = container.getSubordinateItem(subordinateIndex);
                    Item item = shadow.m_41720_();
                    if (item instanceof ShadowStorageItem) {
                        ShadowStorageItem shadowStorageItem = (ShadowStorageItem)item;
                        shadowStorageItem.m_142131_(player, (Level)serverLevel, shadow, pContext.m_8083_().m_121945_(pContext.m_43719_()));
                        this.releaseCreatureEffects(serverLevel, pContext.m_8083_().m_5484_(pContext.m_43719_(), 2));
                    }
                    container.removeSubordinateItem(subordinateIndex);
                    stack.m_41784_().m_128365_("SpatialStorage", (Tag)container.m_7927_());
                    player.m_150109_().m_6596_();
                }
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        if (!pPlayer.m_9236_().m_5776_() && pPlayer.m_6047_() && SubspacePocketItem.canStoreEntity(pInteractionTarget, (LivingEntity)pPlayer)) {
            SubspacePocketContainer container = new SubspacePocketContainer(this.storageCapacity, this.maxStackSize, this.subordinateCapacity);
            container.m_7797_(pStack.m_41784_().m_128437_("SpatialStorage", 10));
            if (container.canStoreSubordinate()) {
                ItemStack shadow = this.createShadowItem(pInteractionTarget);
                container.storeSubordinate(shadow);
                pStack.m_41784_().m_128365_("SpatialStorage", (Tag)container.m_7927_());
                this.storeCreatureEffects(pInteractionTarget);
                pInteractionTarget.m_146870_();
                pPlayer.m_150109_().m_6596_();
            }
        }
        return InteractionResult.CONSUME;
    }

    private ItemStack createShadowItem(LivingEntity entity) {
        ItemStack shadow = new ItemStack((ItemLike)BeyondItems.STORED_SUBORDINATE.get());
        shadow.m_41714_((Component)Component.m_237113_((String)entity.m_7755_().getString()).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        CompoundTag compound = shadow.m_41784_();
        compound.m_128365_("ShadowData", (Tag)entity.serializeNBT());
        compound.m_128347_("ShadowEP", TensuraEPCapability.getEP((LivingEntity)entity));
        compound.m_128347_("ShadowHP", (double)entity.m_21223_());
        compound.m_128347_("ShadowSHP", TensuraEPCapability.getSpiritualHealth((LivingEntity)entity));
        compound.m_128359_("EntityType", String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())));
        return shadow;
    }

    private static boolean canStoreEntity(LivingEntity target, LivingEntity user) {
        IElementalSpirit spirit;
        if (target instanceof Player) {
            return false;
        }
        if (!SkillHelper.isSubordinate((LivingEntity)user, (LivingEntity)target)) {
            return false;
        }
        if (target instanceof IElementalSpirit && (spirit = (IElementalSpirit)target).getSummoningTick() > 0) {
            return false;
        }
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.MONSTER)) {
            return true;
        }
        return !ShadowMotionSkill.shouldConsumeAir((LivingEntity)target);
    }

    private void storeCreatureEffects(LivingEntity entity) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        level.m_5594_(null, entity.m_20097_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        Vec3 boundingBoxCenter = entity.m_20191_().m_82399_();
        level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, boundingBoxCenter.m_7096_(), boundingBoxCenter.m_7098_(), boundingBoxCenter.m_7094_(), 100, 1.5, 1.5, 1.5, 0.0);
    }

    private void releaseCreatureEffects(ServerLevel level, BlockPos blockPos) {
        level.m_5594_(null, blockPos, SoundEvents.f_144243_, SoundSource.PLAYERS, 1.0f, 1.0f);
        level.m_5594_(null, blockPos, SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.0f);
        level.m_5594_(null, blockPos, SoundEvents.f_215671_, SoundSource.PLAYERS, 1.0f, 1.0f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 100, 1.5, 1.5, 1.5, 0.0);
    }
}

