/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.effects;

import io.github.Memoires.trbeyond.items.effects.AnimatedEffectWeapon;
import io.github.Memoires.trbeyond.items.effects.EffectHandler;
import io.github.Memoires.trbeyond.items.effects.EffectModel;
import io.github.Memoires.trbeyond.items.effects.EffectRenderer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public abstract class EffectItem
extends Item
implements IAnimatable {
    public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public EffectItem() {
        super(new Item.Properties());
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            controller.registerCustomInstructionListener(EffectHandler::handleInstructionKeyframe);
        }
        data.addAnimationController(controller);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().loop("attack"));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static void offsetPlayer(ServerPlayer player) {
        double maxDistance;
        Vec3 lookVec;
        Vec3 targetVec;
        if (player == null) {
            return;
        }
        Level level = player.f_19853_;
        Vec3 eyePos = player.m_146892_();
        BlockHitResult hitResult = level.m_45547_(new ClipContext(eyePos, targetVec = eyePos.m_82549_((lookVec = player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_()).m_82490_(maxDistance = 10.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 safeTarget = hitResult.m_6662_() == HitResult.Type.BLOCK ? hitResult.m_82450_().m_82546_(lookVec.m_82490_(1.0)) : targetVec;
        player.m_6021_(safeTarget.f_82479_, player.m_20186_(), safeTarget.f_82481_);
        player.f_19864_ = true;
    }

    public static class Gelds
    extends EffectItem {
        public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

        public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new EffectRenderer(new EffectModel(AnimatedEffectWeapon.Effect.GELDS));
                }
            });
        }

        @Override
        public AnimationFactory getFactory() {
            return this.factory;
        }
    }

    public static class MinosTrident
    extends EffectItem {
        public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

        public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new EffectRenderer(new EffectModel(AnimatedEffectWeapon.Effect.MINOS_TRIDENT_UNIQUE));
                }
            });
        }

        @Override
        public AnimationFactory getFactory() {
            return this.factory;
        }
    }

    public static class Guren
    extends EffectItem {
        public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

        public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new EffectRenderer(new EffectModel(AnimatedEffectWeapon.Effect.GUREN));
                }
            });
        }

        @Override
        public AnimationFactory getFactory() {
            return this.factory;
        }
    }

    public static class Gorikimaru
    extends EffectItem {
        public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

        public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new EffectRenderer(new EffectModel(AnimatedEffectWeapon.Effect.GORIKIMARU));
                }
            });
        }

        @Override
        public AnimationFactory getFactory() {
            return this.factory;
        }
    }

    public static class Haruko
    extends EffectItem {
        public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

        public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new EffectRenderer(new EffectModel(AnimatedEffectWeapon.Effect.HAKURO_SWORD));
                }
            });
        }

        @Override
        public AnimationFactory getFactory() {
            return this.factory;
        }
    }

    public static class Gabiru
    extends EffectItem {
        public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

        public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new EffectRenderer(new EffectModel(AnimatedEffectWeapon.Effect.GABIRU));
                }
            });
        }

        @Override
        public AnimationFactory getFactory() {
            return this.factory;
        }
    }
}

