/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.entity.projectile.GlendaBulletProjectile;
import io.github.Memoires.trbeyond.registry.items.BeyondItems;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import java.util.Random;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GlendaPistolItem
extends CrossbowItem {
    private final Random random = new Random();
    private static final Set<Enchantment> AcceptableEnchantments = Set.of(Enchantments.f_44988_, Enchantments.f_44986_, Enchantments.f_44962_);

    public GlendaPistolItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return AcceptableEnchantments.contains(enchantment);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.CROSSBOW;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pStack.m_41782_() || !pStack.m_41783_().m_128471_("Charged")) {
            pStack.m_41784_().m_128379_("Charged", true);
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this)) {
            InteractionResultHolder.m_19100_((Object)stack);
        }
        boolean shot = this.attemptShoot(stack, level, (LivingEntity)player);
        player.m_6672_(hand);
        if (shot) {
            player.m_36335_().m_41524_((Item)this, 4);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pCount) {
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
    }

    private boolean attemptShoot(ItemStack pStack, Level level, LivingEntity entity) {
        boolean canShoot = false;
        ItemStack ammoStack = null;
        Player playerEntity = null;
        if (entity instanceof Player) {
            Player player2 = (Player)entity;
            if (player2.m_150110_().f_35937_) {
                canShoot = true;
            } else if (player2.m_150109_().m_18949_(Set.of((Item)BeyondItems.MAGISTEEL_BULLET.get()))) {
                canShoot = true;
                playerEntity = player2;
                ammoStack = player2.m_150109_().m_8020_(player2.m_150109_().m_36030_(new ItemStack((ItemLike)BeyondItems.MAGISTEEL_BULLET.get())));
            }
        } else {
            canShoot = true;
        }
        if (canShoot) {
            InteractionHand hand = entity.m_7655_();
            SoundSource soundSource = playerEntity != null ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            boolean left = hand == InteractionHand.OFF_HAND && entity.m_5737_() == HumanoidArm.RIGHT || hand == InteractionHand.MAIN_HAND && entity.m_5737_() == HumanoidArm.LEFT;
            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, soundSource, 0.5f, 0.4f + this.random.nextFloat() * 0.4f + 0.8f);
            GlendaBulletProjectile bullet = new GlendaBulletProjectile(level, entity, !left);
            bullet.setDamage(30.0f + 5.0f * (float)pStack.getEnchantmentLevel(Enchantments.f_44988_));
            bullet.setDamageSource(TensuraDamageSources.shot((Projectile)bullet, (Entity)entity).m_19366_());
            bullet.setSpeed(5.0f);
            bullet.shootFromRot(entity.m_20154_());
            level.m_7967_((Entity)bullet);
            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)BeyondSoundEvents.GUN_SHOT.get(), soundSource, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
            if (playerEntity != null) {
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                pStack.m_41622_(1, (LivingEntity)playerEntity, player -> player.m_21190_(hand));
            }
            if (ammoStack != null) {
                ammoStack.m_41774_(1);
                if (ammoStack.m_41619_()) {
                    playerEntity.m_150109_().m_36057_(ammoStack);
                }
            }
        }
        return canShoot;
    }
}

