/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillClientUtils;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TwoHandedLongSword;
import com.github.manasmods.tensura.registry.battlewill.ProjectileArts;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.effects.AnimatedEffectWeapon;
import io.github.Memoires.trbeyond.network.OgreSwordCannonPacket;
import io.github.Memoires.trbeyond.registry.battlewill.BeyondUtilityArts;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GorikimaruItem
extends TwoHandedLongSword
implements AnimatedEffectWeapon {
    public GorikimaruItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double pAttackRangeModifier, double critChance, double critDamageMultiplier, double sweepChance, double oneHandedSweepChance, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pAttackRangeModifier, critChance, critDamageMultiplier, pAttackDamageModifier, sweepChance, oneHandedSweepChance, pProperties);
    }

    public GorikimaruItem(Grade grade) {
        this(grade.getMaterial(), grade.getDamage(), -3.2f, 2.0, 20.0, 0.0, 100.0, 0.0, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41499_(150).m_41497_(grade.getRarity()));
    }

    public static void applyEnchants(ItemStack toStack, ItemStack fromStack, EquipmentSlot toSlot) {
        Item item;
        Enchantment soulEater = (Enchantment)TensuraEnchantments.SOUL_EATER.get();
        Enchantment tsukumogami = (Enchantment)TensuraEnchantments.TSUKUMOGAMI.get();
        Enchantment battleInfusion = (Enchantment)BeyondEnchantments.BATTLE_INFUSION.get();
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && (item = toStack.m_41720_()) instanceof GorikimaruItem) {
            GorikimaruItem gorikimaruItem = (GorikimaruItem)item;
            if (toStack.getEnchantmentLevel(soulEater) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)soulEater, (int)1);
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)tsukumogami, (int)1);
            }
            if (gorikimaruItem.m_41460_(fromStack).equals((Object)Grade.GOD.getRarity()) && toStack.getEnchantmentLevel(battleInfusion) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)battleInfusion, (int)1);
            }
        }
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.great_sword.tooltip"));
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pIsSelected && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            this.handleOgreCannonSkill(pStack, pLevel, player);
        }
        this.updateOgreGuillotineState(pEntity);
    }

    private void handleOgreCannonSkill(ItemStack pStack, Level pLevel, Player player) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        if (!this.canPlayerUseSkill(player, storage)) {
            return;
        }
        storage.getSkill((ManasSkill)ProjectileArts.OGRE_SWORD_CANNON.get()).ifPresent(ogreCannon -> this.startAnimation(pLevel, player, player.m_21120_(InteractionHand.MAIN_HAND), (ManasSkillInstance)ogreCannon));
        this.decreaseOgreCannonCooldown(player);
    }

    private boolean canPlayerUseSkill(Player player, SkillStorage storage) {
        return storage.getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).map(skyWalk -> skyWalk.isToggled() || player.m_20096_()).orElse(player.m_20096_());
    }

    private void decreaseOgreCannonCooldown(Player player) {
        if (player.f_19853_.m_5776_() || player.f_19853_.m_7654_() == null) {
            return;
        }
        SkillAPI.getSkillsFrom((Entity)player).getSkill((ManasSkill)ProjectileArts.OGRE_SWORD_CANNON.get()).ifPresent(instance -> {
            int currentCooldown;
            boolean canCooldownDecrease;
            boolean bl = canCooldownDecrease = player.m_9236_().m_7654_().m_129921_() % 20 == 0;
            if (canCooldownDecrease && (currentCooldown = instance.getOrCreateTag().m_128451_("ogre_cannon_cooldown")) > 0) {
                instance.getOrCreateTag().m_128405_("ogre_cannon_cooldown", currentCooldown - 1);
            }
        });
    }

    private void updateOgreGuillotineState(Entity pEntity) {
        float cannonState;
        if (!(pEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)pEntity;
        float f = cannonState = living.m_21023_((MobEffect)TensuraMobEffects.OGRE_GUILLOTINE.get()) ? 1.0f : 0.0f;
        if (living.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof GorikimaruItem) {
            living.m_21120_(InteractionHand.MAIN_HAND).m_41784_().m_128350_("ogre_cannon", cannonState);
        }
    }

    public void startAnimation(Level level, Player player, ItemStack stack, ManasSkillInstance instance) {
        int power;
        double cost;
        if (!level.f_46443_) {
            return;
        }
        if (!SkillClientUtils.isSkillHeldClient((LivingEntity)player, (ManasSkill)instance.getSkill())) {
            return;
        }
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            player.m_5661_((Component)Component.m_237110_((String)"trbeyond.message.ogre_cannon_cooldown.on_cooldown", (Object[])new Object[]{Math.round(player.m_36335_().m_41521_(stack.m_41720_(), 0.0f) * 20.0f)}), true);
            return;
        }
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        if ((SkillAPI.getSkillsFrom((Entity)player).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).isPresent() && ((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)player).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).get()).isToggled() || player.m_20096_()) && !SkillHelper.outOfAura((LivingEntity)player, (double)(cost = 200.0 * (double)(power = instance.isMastered((LivingEntity)player) ? 10 : 5)))) {
            if (stack.m_41784_().m_128451_("int") > 1) {
                return;
            }
            player.m_36335_().m_41524_(stack.m_41720_(), 300);
            stack.m_41784_().m_128405_("int", 1);
            if (level.f_46443_) {
                this.playAnimationClientSync(player);
            }
            OgreSwordCannonPacket.sendToServer();
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (ToolActions.SHIELD_BLOCK.equals(toolAction)) {
            return true;
        }
        return super.canPerformAction(stack, toolAction);
    }

    public boolean m_5812_(ItemStack pStack) {
        return false;
    }

    @Override
    public String getAnimationName() {
        return "gorikimaru_attack";
    }

    @Override
    public AnimatedEffectWeapon.Effect getEffect() {
        return AnimatedEffectWeapon.Effect.GORIKIMARU;
    }

    public static enum Grade {
        UNIQUE(TensuraToolTiers.PURE_MAGISTEEL, 14, BeyondRarity.UNIQUE),
        LEGEND(TensuraToolTiers.ADAMANTITE, 17, BeyondRarity.LEGEND),
        GOD(TensuraToolTiers.HIHIIROKANE, 23, BeyondRarity.GOD);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(Tier material, int damage, Rarity rarity) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
        }
    }
}

