/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TwoHandedLongSword;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.capability.player.BeyondPlayerCapability;
import io.github.Memoires.trbeyond.client.collision.OBB;
import io.github.Memoires.trbeyond.client.collision.TargetFinder;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.effects.AnimatedEffectWeapon;
import io.github.Memoires.trbeyond.registry.battlewill.BeyondUtilityArts;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GurenItem
extends TwoHandedLongSword
implements AnimatedEffectWeapon {
    public GurenItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double attackRangeModifier, double critChance, double critDamageMultiplier, int pAttackDamageModifier1, double sweepChance, double oneHandedSweepChance, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, attackRangeModifier, critChance, critDamageMultiplier, pAttackDamageModifier1, sweepChance, oneHandedSweepChance, pProperties);
    }

    public GurenItem(Grade grade) {
        this(grade.material, grade.getDamage(), -2.5f, 2.0, 20.0, 0.5, grade.getDamage() - 3, 100.0, 100.0, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41499_(150).m_41497_(grade.getRarity()));
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.long_sword.tooltip"));
    }

    public static void applyEnchants(ItemStack toStack, ItemStack fromStack, EquipmentSlot toSlot) {
        Item item;
        Enchantment tsukumogami = (Enchantment)TensuraEnchantments.TSUKUMOGAMI.get();
        Enchantment flameInfusion = (Enchantment)BeyondEnchantments.FLAME_INFUSION.get();
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && (item = toStack.m_41720_()) instanceof GurenItem) {
            GurenItem gurenItem = (GurenItem)item;
            if (toStack.getEnchantmentLevel(tsukumogami) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)tsukumogami, (int)1);
            }
            if (gurenItem.m_41460_(fromStack).equals((Object)Grade.GOD.getRarity()) && toStack.getEnchantmentLevel(flameInfusion) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)flameInfusion, (int)1);
            }
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (SkillAPI.getSkillsFrom((Entity)pEntity).getSkill((ManasSkill)ExtraSkills.BLACK_FLAME.get()).isPresent() && ((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)pEntity).getSkill((ManasSkill)ExtraSkills.BLACK_FLAME.get()).get()).isToggled()) {
            pStack.m_41720_().getShareTag(pStack).m_128350_("black_flame", 1.0f);
        } else {
            pStack.m_41720_().getShareTag(pStack).m_128350_("black_flame", 0.0f);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, final Player pPlayer, InteractionHand pHand) {
        if ((SkillAPI.getSkillsFrom((Entity)pPlayer).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).isPresent() && ((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)pPlayer).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).get()).isToggled() || pPlayer.m_20096_()) && SkillAPI.getSkillsFrom((Entity)pPlayer).getSkill((ManasSkill)ExtraSkills.BLACK_FLAME.get()).isPresent() && ((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)pPlayer).getSkill((ManasSkill)ExtraSkills.BLACK_FLAME.get()).get()).isToggled() && ((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)pPlayer).getSkill((ManasSkill)ExtraSkills.BLACK_FLAME.get()).get()).isMastered((LivingEntity)pPlayer) && !SkillHelper.outOfMagicule((LivingEntity)pPlayer, (double)20000.0)) {
            pPlayer.m_36335_().m_41524_((Item)this, 300);
            final Vec3 oldPos = pPlayer.m_146892_();
            if (pLevel.f_46443_) {
                this.playAnimationClientSync(pPlayer);
            }
            final float yRot = pPlayer.m_146908_();
            final float xRot = pPlayer.m_146909_();
            pPlayer.f_19853_.m_5594_(null, pPlayer.m_20183_(), (SoundEvent)BeyondSoundEvents.BLACK_FLAME_SLASH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            MinecraftForge.EVENT_BUS.register(new Object(){
                int ticks = 0;
                final Vec3 finalOldPos = oldPos;
                final float finalYRot = yRot;
                final float finalXRot = xRot;

                @SubscribeEvent
                public void onServerTick(TickEvent.ServerTickEvent event) {
                    if (event.phase != TickEvent.Phase.END) {
                        return;
                    }
                    ++this.ticks;
                    if (this.ticks <= 59) {
                        pPlayer.m_5616_(this.finalYRot);
                        pPlayer.m_146926_(this.finalXRot);
                        pPlayer.m_146922_(this.finalYRot);
                    }
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)pPlayer, (ParticleOptions)((ParticleOptions)TensuraParticles.BLACK_FIRE.get()));
                    if (this.ticks == 50) {
                        TargetFinder.TargetResult result = GurenItem.this.findAttackTargetResultSlash(pPlayer, 11.0, this.finalOldPos);
                        List<Entity> entities = result.entities;
                        entities.forEach(entity -> {
                            entity.f_19802_ = 0;
                            SkillStorage skills = SkillAPI.getSkillsFrom((Entity)pPlayer);
                            Optional flameManipOpt = skills.getSkill((ManasSkill)ExtraSkills.FLAME_MANIPULATION.get());
                            Optional flameDomOpt = skills.getSkill((ManasSkill)ExtraSkills.FLAME_DOMINATION.get());
                            boolean hasFlameManip = flameManipOpt.isPresent() && ((ManasSkillInstance)flameManipOpt.get()).isToggled();
                            boolean hasFlameDom = flameDomOpt.isPresent() && ((ManasSkillInstance)flameDomOpt.get()).isToggled();
                            boolean fireInfused = GurenItem.this.hasFireInfusion(pPlayer);
                            boolean flameInfused = GurenItem.this.hasFlameInfusion(pPlayer);
                            float damage = 250.0f;
                            if (hasFlameManip && !hasFlameDom && !fireInfused && !flameInfused) {
                                damage = 500.0f;
                            } else if (hasFlameDom && !fireInfused && !flameInfused) {
                                damage = 1000.0f;
                            } else if (hasFlameManip && !hasFlameDom && fireInfused && !flameInfused) {
                                damage = 550.0f;
                            } else if (hasFlameDom && fireInfused && !flameInfused) {
                                damage = 1050.0f;
                            } else if (hasFlameManip && !hasFlameDom && !fireInfused && flameInfused) {
                                damage = 600.0f;
                            } else if (hasFlameDom && !fireInfused && flameInfused) {
                                damage = 1100.0f;
                            } else if (hasFlameManip && !hasFlameDom && fireInfused && flameInfused) {
                                damage = 650.0f;
                            } else if (hasFlameDom && fireInfused && flameInfused) {
                                damage = 1150.0f;
                            } else if (!(hasFlameManip || hasFlameDom || fireInfused || flameInfused)) {
                                damage = 250.0f;
                            } else if (!hasFlameManip && hasFlameDom && !fireInfused && !flameInfused) {
                                damage = 1000.0f;
                            } else if (!hasFlameManip && !hasFlameDom && fireInfused && !flameInfused) {
                                damage = 300.0f;
                            } else if (!hasFlameManip && hasFlameDom && fireInfused && !flameInfused) {
                                damage = 1050.0f;
                            } else if (!hasFlameManip && !hasFlameDom && !fireInfused && flameInfused) {
                                damage = 350.0f;
                            } else if (!hasFlameManip && hasFlameDom && !fireInfused && flameInfused) {
                                damage = 1100.0f;
                            } else if (!hasFlameManip && !hasFlameDom && fireInfused && flameInfused) {
                                damage = 400.0f;
                            } else if (!hasFlameManip && hasFlameDom && fireInfused && flameInfused) {
                                damage = 1150.0f;
                            }
                            if (damage > 0.0f) {
                                entity.m_6469_(TensuraDamageSources.blackFlame((Entity)pPlayer), damage);
                            }
                            if (entity instanceof LivingEntity) {
                                LivingEntity living = (LivingEntity)entity;
                                living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 140, 10));
                                living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), 100, 10));
                            }
                        });
                        BeyondPlayerCapability.getFrom(pPlayer).ifPresent(cap -> cap.setAction(true));
                        BeyondPlayerCapability.sync(pPlayer);
                    }
                    if (this.ticks >= 80 && this.ticks <= 120) {
                        TargetFinder.TargetResult resultVortex = GurenItem.this.findAttackTargetResultVortex(pPlayer, 7.0, this.finalOldPos);
                        List<Entity> entitiesVortex = resultVortex.entities;
                        Vec3 vortexCenter = resultVortex.obb.center;
                        GurenItem.this.pullEntitiesToPoint(entitiesVortex, vortexCenter, 0.5f);
                        TargetFinder.TargetResult resultExplosion = GurenItem.this.findAttackTargetResultVortex(pPlayer, 4.0, this.finalOldPos);
                        List<Entity> entitiesExplosion = resultExplosion.entities;
                        entitiesExplosion.forEach(entity -> {
                            entity.f_19802_ = 0;
                            SkillStorage skills = SkillAPI.getSkillsFrom((Entity)pPlayer);
                            Optional flameManipOpt = skills.getSkill((ManasSkill)ExtraSkills.FLAME_MANIPULATION.get());
                            Optional flameDomOpt = skills.getSkill((ManasSkill)ExtraSkills.FLAME_DOMINATION.get());
                            boolean hasFlameManip = flameManipOpt.isPresent() && ((ManasSkillInstance)flameManipOpt.get()).isToggled();
                            boolean hasFlameDom = flameDomOpt.isPresent() && ((ManasSkillInstance)flameDomOpt.get()).isToggled();
                            boolean fireInfused = GurenItem.this.hasFireInfusion(pPlayer);
                            boolean flameInfused = GurenItem.this.hasFlameInfusion(pPlayer);
                            float damage = 500.0f;
                            if (hasFlameManip && !hasFlameDom && !fireInfused && !flameInfused) {
                                damage = 1000.0f;
                            } else if (hasFlameDom && !fireInfused && !flameInfused) {
                                damage = 2000.0f;
                            } else if (hasFlameManip && !hasFlameDom && fireInfused && !flameInfused) {
                                damage = 1100.0f;
                            } else if (hasFlameDom && fireInfused && !flameInfused) {
                                damage = 2100.0f;
                            } else if (hasFlameManip && !hasFlameDom && !fireInfused && flameInfused) {
                                damage = 1200.0f;
                            } else if (hasFlameDom && !fireInfused && flameInfused) {
                                damage = 2200.0f;
                            } else if (hasFlameManip && !hasFlameDom && fireInfused && flameInfused) {
                                damage = 1300.0f;
                            } else if (hasFlameDom && fireInfused && flameInfused) {
                                damage = 2300.0f;
                            } else if (!(hasFlameManip || hasFlameDom || fireInfused || flameInfused)) {
                                damage = 500.0f;
                            } else if (!hasFlameManip && hasFlameDom && !fireInfused && !flameInfused) {
                                damage = 2000.0f;
                            } else if (!hasFlameManip && !hasFlameDom && fireInfused && !flameInfused) {
                                damage = 600.0f;
                            } else if (!hasFlameManip && hasFlameDom && fireInfused && !flameInfused) {
                                damage = 2100.0f;
                            } else if (!hasFlameManip && !hasFlameDom && !fireInfused && flameInfused) {
                                damage = 700.0f;
                            } else if (!hasFlameManip && hasFlameDom && !fireInfused && flameInfused) {
                                damage = 2200.0f;
                            } else if (!hasFlameManip && !hasFlameDom && flameInfused) {
                                damage = 700.0f;
                            } else if (!hasFlameManip && hasFlameDom && flameInfused) {
                                damage = 2200.0f;
                            }
                            if (damage > 0.0f) {
                                entity.m_6469_(TensuraDamageSources.blackFlame((Entity)pPlayer).m_19380_(), damage);
                            }
                            if (entity instanceof LivingEntity) {
                                LivingEntity living = (LivingEntity)entity;
                                living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 120, 10));
                                living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), 100, 10));
                            }
                        });
                    }
                    if (this.ticks >= 150) {
                        BeyondPlayerCapability.getFrom(pPlayer).ifPresent(cap -> cap.setAction(false));
                        BeyondPlayerCapability.sync(pPlayer);
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            });
        }
        System.out.println(pPlayer.m_21211_());
        return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pHand));
    }

    public boolean hasFireInfusion(Player player) {
        ItemStack heldItem = player.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BeyondEnchantments.FIRE_INFUSION.get()), (ItemStack)heldItem);
        return level > 0;
    }

    public boolean hasFlameInfusion(Player player) {
        ItemStack heldItem = player.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BeyondEnchantments.FLAME_INFUSION.get()), (ItemStack)heldItem);
        return level > 0;
    }

    @Override
    public String getAnimationName() {
        return "benimaru_blade_attack";
    }

    @Override
    public AnimatedEffectWeapon.Effect getEffect() {
        return AnimatedEffectWeapon.Effect.GUREN;
    }

    public TargetFinder.TargetResult findAttackTargetResultSlash(Player player, double attackRange, Vec3 oldpos) {
        Vec3 origin = GurenItem.getInitialTracingPoint(player, oldpos);
        List<Entity> entities = TargetFinder.getInitialTargets(player, attackRange);
        Vec3 size = new Vec3(attackRange / 11.0 + 2.0, attackRange / 11.0 + 2.0, attackRange + 3.0);
        OBB obb = new OBB(origin, size, 0.0f, player.m_146908_());
        obb.updateVertex();
        TargetFinder.CollisionFilter collisionFilter = new TargetFinder.CollisionFilter(obb);
        entities = collisionFilter.filter(entities);
        TargetFinder.RadialFilter radialFilter = new TargetFinder.RadialFilter(origin, obb.axisZ, attackRange, player.m_146908_());
        entities = radialFilter.filter(entities);
        return new TargetFinder.TargetResult(entities, obb);
    }

    public TargetFinder.TargetResult findAttackTargetResultVortex(Player player, double attackRange, Vec3 oldpos) {
        Vec3 lookVec = player.m_20154_();
        Vec3 flatLookVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_();
        Vec3 behindPos = player.m_20182_().m_82549_(flatLookVec.m_82490_(-4.0));
        AABB searchBox = new AABB(behindPos, behindPos).m_82400_(attackRange);
        Vec3 size = new Vec3(attackRange, attackRange, attackRange);
        OBB obb = new OBB(behindPos, size, 0.0f, player.m_146908_());
        obb.updateVertex();
        List entities = player.f_19853_.m_6443_(LivingEntity.class, searchBox, e -> e != player);
        return new TargetFinder.TargetResult(new ArrayList<Entity>(entities), obb);
    }

    public void pullEntitiesToPoint(List<Entity> entities, Vec3 destination, float strength) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || entity.m_20068_()) continue;
            Vec3 currentPos = entity.m_20182_();
            Vec3 direction = destination.m_82546_(currentPos).m_82541_();
            double distance = currentPos.m_82554_(destination);
            double pullStrength = (double)strength * (1.0 - distance / 10.0);
            entity.m_20256_(entity.m_20184_().m_82549_(direction.m_82490_(pullStrength)).m_82490_(0.9));
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.1, 0.0));
        }
    }

    public static Vec3 getInitialTracingPoint(Player player, Vec3 oldpos) {
        double shoulderHeight = (double)player.m_20206_() * 0.15 * (double)player.m_6134_();
        return oldpos.m_82492_(0.0, shoulderHeight, 0.0);
    }

    public boolean m_5812_(ItemStack pStack) {
        return false;
    }

    public static void setTpState(Player player, boolean isAfterTp) {
        player.getPersistentData().m_128379_("after_tp", isAfterTp);
    }

    public static boolean isAfterTP(Player player) {
        return player.getPersistentData().m_128471_("after_tp");
    }

    public static enum Grade {
        UNIQUE(TensuraToolTiers.PURE_MAGISTEEL, 11, BeyondRarity.UNIQUE),
        LEGEND(TensuraToolTiers.ADAMANTITE, 12, BeyondRarity.LEGEND),
        GOD(TensuraToolTiers.HIHIIROKANE, 13, BeyondRarity.GOD);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(Tier material, int damage, Rarity rarity) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
        }
    }
}

