/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.entity.AkashEntity;
import com.github.manasmods.tensura.entity.CharybdisEntity;
import com.github.manasmods.tensura.entity.ElementalColossusEntity;
import com.github.manasmods.tensura.entity.IfritEntity;
import com.github.manasmods.tensura.entity.OrcDisasterEntity;
import com.github.manasmods.tensura.entity.OrcLordEntity;
import com.github.manasmods.tensura.entity.SupermassiveSlimeEntity;
import com.github.manasmods.tensura.entity.SylphideEntity;
import com.github.manasmods.tensura.entity.UndineEntity;
import com.github.manasmods.tensura.entity.WarGnomeEntity;
import com.github.manasmods.tensura.entity.human.HinataSakaguchiEntity;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TwoHandedLongSword;
import com.github.manasmods.tensura.registry.battlewill.MeleeArts;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trbeyond.entity.custom.BossBlackSpiderEntity;
import io.github.Memoires.trbeyond.entity.custom.EvilCentipedeBossEntity;
import io.github.Memoires.trbeyond.entity.custom.GozulEntity;
import io.github.Memoires.trbeyond.entity.custom.MezulEntity;
import io.github.Memoires.trbeyond.entity.custom.OgreLordEntity;
import io.github.Memoires.trbeyond.entity.custom.TempestSerpentBossEntity;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.effects.AnimatedEffectWeapon;
import io.github.Memoires.trbeyond.registry.battlewill.BeyondUtilityArts;
import io.github.Memoires.trbeyond.registry.effects.BeyondEffects;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class HakuroItem
extends TwoHandedLongSword
implements AnimatedEffectWeapon {
    public HakuroItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double attackRangeModifier, double critChance, double critDamageMultiplier, int pAttackDamageModifier1, double sweepChance, double oneHandedSweepChance, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, attackRangeModifier, critChance, critDamageMultiplier, pAttackDamageModifier1, sweepChance, oneHandedSweepChance, pProperties);
    }

    public HakuroItem(Grade grade) {
        this(grade.material, grade.getDamage(), -2.0f, 0.0, 20.0, 0.0, grade.getDamage() - 3, 0.0, 0.0, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41499_(150).m_41497_(grade.getRarity()));
    }

    public static void applyEnchants(ItemStack toStack, EquipmentSlot toSlot) {
        Enchantment tsukumogami = (Enchantment)TensuraEnchantments.TSUKUMOGAMI.get();
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && toStack.m_41720_() instanceof HakuroItem && toStack.getEnchantmentLevel(tsukumogami) < 1) {
            EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)tsukumogami, (int)1);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pHand));
        }
        if (SkillAPI.getSkillsFrom((Entity)pPlayer).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).isPresent() && ((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)pPlayer).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).get()).isToggled() || pPlayer.m_20096_()) {
            if (pLevel.f_46443_) {
                this.playAnimationClientSync(pPlayer);
            }
            pPlayer.m_36335_().m_41524_((Item)this, 300);
            pPlayer.f_19853_.m_5594_(null, pPlayer.m_20183_(), (SoundEvent)BeyondSoundEvents.HAKURO_ATTACK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.performHakuroAttack(pPlayer);
        }
        return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pHand));
    }

    @Override
    public String getAnimationName() {
        return "hakuro_sword_attack";
    }

    @Override
    public AnimatedEffectWeapon.Effect getEffect() {
        return AnimatedEffectWeapon.Effect.HAKURO_SWORD;
    }

    public void performHakuroAttack(Player player) {
        Level world = player.f_19853_;
        if (world.f_46443_) {
            return;
        }
        SkillHelper.checkThenAddEffectSource((LivingEntity)player, (Entity)player, (MobEffect)((MobEffect)BeyondEffects.DODGE.get()), (int)120, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
        MinecraftForge.EVENT_BUS.register((Object)new HakuroAttackHandler(player, world));
    }

    public static enum Grade {
        UNIQUE(TensuraToolTiers.PURE_MAGISTEEL, 6, BeyondRarity.UNIQUE),
        LEGEND(TensuraToolTiers.ADAMANTITE, 5, BeyondRarity.LEGEND);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(Tier material, int damage, Rarity rarity) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
        }
    }

    private static class HakuroAttackHandler {
        private final Player player;
        private final Level world;
        private int ticks = 0;
        private float baseDamage = 0.0f;

        public HakuroAttackHandler(Player player, Level world) {
            this.player = player;
            this.world = world;
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            ++this.ticks;
            if (this.ticks == 30) {
                AABB hitbox = new AABB(this.player.m_20183_()).m_82377_(4.0, 4.0, 4.0);
                List initialTargets = this.world.m_6443_(LivingEntity.class, hitbox, e -> e != this.player && e.m_6084_());
                float attackStrength = this.player.m_36403_(1.0f);
                this.baseDamage = (float)this.player.m_21133_(Attributes.f_22281_);
                this.baseDamage = (this.baseDamage * 0.2f + this.baseDamage) * attackStrength;
                TensuraDamageSource battlewillDamage = DamageSourceHelper.turnTensura((DamageSource)DamageSource.m_19344_((Player)this.player), (Entity)this.player);
                for (LivingEntity target : initialTargets) {
                    if (!target.m_6084_()) continue;
                    SkillStorage skills = SkillAPI.getSkillsFrom((Entity)this.player);
                    Optional guillotinePresent = skills.getSkill((ManasSkill)MeleeArts.OGRE_SWORD_GUILLOTINE.get());
                    boolean hasGuillotine = guillotinePresent.isPresent();
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)this.player, (MobEffect)((MobEffect)BeyondEffects.NO_DODGE.get()), (int)120, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    if (this.player.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
                        target.m_6469_((DamageSource)battlewillDamage, this.baseDamage * 5.0f);
                        continue;
                    }
                    if (this.player.m_21023_((MobEffect)TensuraMobEffects.OGRE_GUILLOTINE.get())) {
                        if (!hasGuillotine) continue;
                        ManasSkillInstance instance = (ManasSkillInstance)guillotinePresent.get();
                        if (instance.isMastered((LivingEntity)this.player)) {
                            target.m_6469_((DamageSource)battlewillDamage, this.baseDamage * 1.0f);
                            continue;
                        }
                        target.m_6469_((DamageSource)battlewillDamage, this.baseDamage * 0.75f);
                        continue;
                    }
                    target.m_6469_((DamageSource)battlewillDamage, this.baseDamage * 2.0f);
                }
            }
            if (this.ticks >= 60) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                if (!this.player.m_6084_()) {
                    return;
                }
                AABB hitboxSecond = new AABB(this.player.m_20183_()).m_82377_(10.0, 10.0, 10.0);
                List targetsInHitboxSecond = this.world.m_6443_(LivingEntity.class, hitboxSecond, e -> e != this.player && e.m_6084_());
                if (!targetsInHitboxSecond.isEmpty()) {
                    LivingEntity closestTarget = this.getClosestTarget(this.player, targetsInHitboxSecond);
                    if (closestTarget != null) {
                        Vec3 to;
                        Vec3 pos = closestTarget.m_20182_();
                        Vec3 from = this.player.m_146892_();
                        BlockHitResult hitResult = this.world.m_45547_(new ClipContext(from, to = closestTarget.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.player));
                        if (hitResult.m_6662_() != HitResult.Type.MISS) {
                            return;
                        }
                        this.player.m_6021_(pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_);
                        TensuraDamageSource battlewillDamage = DamageSourceHelper.turnTensura((DamageSource)DamageSource.m_19344_((Player)this.player), (Entity)this.player);
                        SkillStorage skills = SkillAPI.getSkillsFrom((Entity)this.player);
                        Optional guillotinePresent = skills.getSkill((ManasSkill)MeleeArts.OGRE_SWORD_GUILLOTINE.get());
                        boolean hasGuillotine = guillotinePresent.isPresent();
                        float secondStrikeDamage = this.baseDamage * 5.0f;
                        if (this.player.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
                            secondStrikeDamage = this.baseDamage * 7.5f;
                        } else if (this.player.m_21023_((MobEffect)TensuraMobEffects.OGRE_GUILLOTINE.get()) && hasGuillotine) {
                            ManasSkillInstance instance = (ManasSkillInstance)guillotinePresent.get();
                            secondStrikeDamage = instance.isMastered((LivingEntity)this.player) ? (secondStrikeDamage *= 2.0f) : (secondStrikeDamage *= 1.5f);
                        }
                        closestTarget.m_6469_((DamageSource)battlewillDamage, secondStrikeDamage);
                    } else {
                        System.out.println("No valid targets found for second strike.");
                    }
                }
            }
        }

        private LivingEntity getClosestTarget(Player player, List<LivingEntity> targets) {
            ArrayList<LivingEntity> hostilePlayers = new ArrayList<LivingEntity>();
            ArrayList<LivingEntity> bosses = new ArrayList<LivingEntity>();
            ArrayList<LivingEntity> others = new ArrayList<LivingEntity>();
            for (LivingEntity target : targets) {
                Player playerTarget;
                if (target instanceof Player && player.m_7099_(playerTarget = (Player)target)) {
                    hostilePlayers.add(target);
                    continue;
                }
                if (this.isBoss(target)) {
                    bosses.add(target);
                    continue;
                }
                others.add(target);
            }
            LivingEntity closest = this.findClosestInList(player, hostilePlayers);
            if (closest != null) {
                return closest;
            }
            closest = this.findClosestInList(player, bosses);
            if (closest != null) {
                return closest;
            }
            return this.findClosestInList(player, others);
        }

        private boolean isBoss(LivingEntity entity) {
            return entity instanceof EnderDragon || entity instanceof WitherBoss || entity instanceof SupermassiveSlimeEntity || entity instanceof IfritEntity || entity instanceof UndineEntity || entity instanceof WarGnomeEntity || entity instanceof SylphideEntity || entity instanceof AkashEntity || entity instanceof OrcLordEntity || entity instanceof OrcDisasterEntity || entity instanceof CharybdisEntity || entity instanceof HinataSakaguchiEntity || entity instanceof ElementalColossusEntity || entity instanceof BossBlackSpiderEntity || entity instanceof MezulEntity || entity instanceof GozulEntity || entity instanceof OgreLordEntity || entity instanceof EvilCentipedeBossEntity || entity instanceof TempestSerpentBossEntity;
        }

        private LivingEntity findClosestInList(Player player, List<LivingEntity> entities) {
            if (entities.isEmpty()) {
                return null;
            }
            LivingEntity closest = null;
            double minDistanceSqr = Double.MAX_VALUE;
            Vec3 playerPos = player.m_20182_();
            for (LivingEntity entity : entities) {
                double distanceSqr = entity.m_20182_().m_82557_(playerPos);
                if (!(distanceSqr < minDistanceSqr)) continue;
                minDistanceSqr = distanceSqr;
                closest = entity;
            }
            return closest;
        }
    }
}

