/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TwoHandedLongSword;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.entity.projectile.ThrownMinosBardicheProjectile;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.armor.BeyondArmorItem;
import io.github.Memoires.trbeyond.items.armor.MinosArmorItem;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MinosBardicheItem
extends TwoHandedLongSword {
    private final Grade grade;

    public MinosBardicheItem(Grade grade) {
        super(grade.material, grade.getDamage(), -3.0f, 2.0, 0.0, 0.0, grade.getDamage() - 3, 100.0, 100.0, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41499_(150).m_41497_(grade.getRarity()));
        this.grade = grade;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 36000;
    }

    public boolean m_5812_(ItemStack pStack) {
        return false;
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            int i = this.m_8105_(pStack) - pTimeLeft;
            if (i >= 10) {
                if (!pLevel.f_46443_) {
                    pStack.m_41622_(10, (LivingEntity)player, pPlayer -> pPlayer.m_21190_(pEntityLiving.m_7655_()));
                    boolean left = pEntityLiving.m_7655_() == InteractionHand.OFF_HAND && pEntityLiving.m_5737_() == HumanoidArm.RIGHT || pEntityLiving.m_7655_() == InteractionHand.MAIN_HAND && pEntityLiving.m_5737_() == HumanoidArm.LEFT;
                    ThrownMinosBardicheProjectile minos = new ThrownMinosBardicheProjectile(pLevel, (LivingEntity)player, pStack, !left);
                    minos.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                    float baseDamage = DamageSourceHelper.getMainWeaponDamage((LivingEntity)player, null);
                    Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill((ManasSkill)UniqueSkills.THROWER.get());
                    if (optional.isPresent()) {
                        minos.setLoyaltyLevel(4);
                        baseDamage += (float)(((ManasSkillInstance)optional.get()).isMastered((LivingEntity)player) ? 100 : 50);
                        int multiplier = 1;
                        if (SkillUtils.isSkillToggled((Entity)player, (ManasSkill)((ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get()))) {
                            multiplier = 3;
                        } else if (SkillUtils.isSkillToggled((Entity)player, (ManasSkill)((ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get()))) {
                            multiplier = 2;
                        }
                        baseDamage *= (float)multiplier;
                    } else {
                        if (SkillUtils.isSkillToggled((Entity)player, (ManasSkill)((ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get()))) {
                            baseDamage *= 2.0f;
                        }
                        if (SkillUtils.hasSkill((Entity)player, (ManasSkill)((ManasSkill)ExtraSkills.MOLECULAR_MANIPULATION.get())) || SkillUtils.hasSkill((Entity)player, (ManasSkill)((ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get()))) {
                            minos.setLoyaltyLevel(3);
                            minos.setReturnSecond(20);
                        }
                    }
                    minos.m_36781_(baseDamage);
                    if (player.m_150110_().f_35937_) {
                        minos.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    pLevel.m_7967_((Entity)minos);
                    pLevel.m_6269_(null, (Entity)minos, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        player.m_150109_().m_36057_(pStack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 10) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public static void dealLightningDamage(Player attacker, LivingEntity target, ItemStack minos) {
        if (MinosBardicheItem.getWindCores(minos) < 3) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.LIGHT_ATTACK_RESISTANCE.get())) || SkillUtils.isSkillToggled((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.LIGHT_ATTACK_NULLIFICATION.get()))) {
            return;
        }
        target.f_19802_ = 0;
        float amount = SkillHelper.noCritAttackDamage((Player)attacker, (Entity)target) * 1.5f;
        target.m_6469_(TensuraDamageSources.lightning((Entity)attacker), amount);
        target.f_19802_ = 0;
        if ((double)attacker.m_9236_().m_213780_().m_188501_() <= 0.2) {
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 60, 4));
        }
    }

    private static Stream<ItemStack> getContents(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Cores", 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public static int getWindCores(ItemStack gear) {
        int coreNumber = 0;
        for (ItemStack cores : MinosBardicheItem.getContents(gear).toList()) {
            if (!cores.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_WIND.get())) continue;
            ++coreNumber;
        }
        return coreNumber;
    }

    public static void applyEnchants(ItemStack toStack, LivingEntity entity, EquipmentSlot toSlot) {
        ItemStack hand;
        Item item;
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && (item = toStack.m_41720_()) instanceof MinosBardicheItem) {
            MinosBardicheItem bardiche = (MinosBardicheItem)item;
            if (toStack.getEnchantmentLevel((Enchantment)TensuraEnchantments.SLOTTING.get()) < bardiche.getGrade().getSlottingLevel()) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)((Enchantment)TensuraEnchantments.SLOTTING.get()), (int)bardiche.getGrade().getSlottingLevel());
            }
        }
        if ((hand = entity.m_6844_(EquipmentSlot.MAINHAND)).m_41720_() instanceof MinosBardicheItem) {
            Enchantment holyCoat = (Enchantment)TensuraEnchantments.HOLY_COAT.get();
            Predicate<ItemStack> predicate = stack -> stack.m_41720_() instanceof MinosArmorItem;
            if (BeyondArmorItem.hasFullSet(entity, predicate, 4)) {
                if (hand.getEnchantmentLevel(holyCoat) != 3) {
                    EngravingEnchantment.engrave((ItemStack)hand, (Enchantment)holyCoat, (int)3);
                }
            } else if (hand.getEnchantmentLevel(holyCoat) != 2) {
                EngravingEnchantment.engrave((ItemStack)hand, (Enchantment)holyCoat, (int)2);
            }
        }
    }

    public Grade getGrade() {
        return this.grade;
    }

    public static enum Grade {
        UNIQUE(TensuraToolTiers.PURE_MAGISTEEL, 6, BeyondRarity.UNIQUE, 1),
        LEGEND(TensuraToolTiers.ADAMANTITE, 0, BeyondRarity.LEGEND, 2),
        GOD(TensuraToolTiers.HIHIIROKANE, -5, BeyondRarity.GOD, 3);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;
        private final int slottingLevel;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public int getSlottingLevel() {
            return this.slottingLevel;
        }

        private Grade(Tier material, int damage, Rarity rarity, int slottingLevel) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
            this.slottingLevel = slottingLevel;
        }
    }
}

