/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.SimpleSpearItem;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.armor.BeyondArmorItem;
import io.github.Memoires.trbeyond.items.armor.MinosArmorItem;
import io.github.Memoires.trbeyond.items.effects.AnimatedEffectWeapon;
import io.github.Memoires.trbeyond.registry.battlewill.BeyondUtilityArts;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class MinosTridentItem
extends SimpleSpearItem
implements AnimatedEffectWeapon {
    protected static final UUID SPEED_UUID = UUID.fromString("b42381aa-787d-4574-8e82-a4f4039191ec");
    public Grade grade;

    public MinosTridentItem(Tier pTier, int pAttackDamageModifier, double critChance, double critDamageMultiplier, int oneHandedAttackDamageModifier, float oneHandedAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, -2.5f, critChance, critDamageMultiplier, oneHandedAttackDamageModifier, oneHandedAttackSpeedModifier, pProperties);
    }

    public MinosTridentItem(Grade grade) {
        this(grade.getMaterial(), grade.getDamage(), 0.0, 0.0, 100, 0.0f, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41499_(150).m_41497_(grade.getRarity()));
        this.grade = grade;
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            int i = this.m_8105_(pStack) - pTimeLeft;
            CompoundTag tag = pStack.m_41784_();
            if (i >= 10 && tag.m_128451_("attackTicks") <= 0) {
                if (pLevel.m_5776_()) {
                    this.playAnimationClientSync(player);
                }
                tag.m_128405_("attackTicks", 70);
            }
        }
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        boolean hurtEnemy = super.m_7579_(pStack, pTarget, pAttacker);
        if (hurtEnemy && pTarget.f_19802_ < 40) {
            pTarget.f_19802_ = 0;
            float damage = (float)pAttacker.m_21133_(Attributes.f_22281_) * 0.1f;
            if (pAttacker instanceof Player) {
                Player player = (Player)pAttacker;
                pTarget.m_6469_(DamageSource.m_19344_((Player)player).m_19380_(), damage);
            } else {
                pTarget.m_6469_(DamageSource.m_19370_((LivingEntity)pAttacker).m_19380_(), damage);
            }
            pTarget.f_19802_ = 0;
        }
        return hurtEnemy;
    }

    public void m_6883_(ItemStack pStack, Level level, Entity entity, int pSlotId, boolean pIsSelected) {
        if (SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).isPresent() && ((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).get()).isToggled() || entity.m_20096_()) {
            CompoundTag tag = pStack.m_41784_();
            int tick = tag.m_128451_("attackTicks");
            if (tick <= 0) {
                return;
            }
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)entity;
            entity.m_5618_(entity.m_6080_());
            if (level.m_5776_()) {
                return;
            }
            if (tick < 60) {
                level.m_6269_(null, entity, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            tag.m_128405_("attackTicks", tick - 1);
            if (tag.m_128451_("attackTicks") % 7 != 0) {
                return;
            }
            Vec3 lookAngle = entity.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
            Vec3 targetPos = entity.m_146892_().m_82549_(lookAngle.m_82490_(owner.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get())));
            Vec3 source = entity.m_146892_().m_82549_(lookAngle);
            Vec3 offSetToTarget = targetPos.m_82546_(source);
            Vec3 normalizes = offSetToTarget.m_82541_();
            for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
                Vec3 pos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
                AABB aabb = new AABB(new BlockPos(pos.f_82479_, pos.f_82480_, pos.f_82481_)).m_82400_(1.0);
                List list = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_(entity) && !entityData.m_7307_(entity));
                if (list.isEmpty()) continue;
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    for (LivingEntity target : list) {
                        if (target.f_19802_ < 40) {
                            target.f_19802_ = 0;
                        }
                        player.m_5706_((Entity)target);
                    }
                    continue;
                }
                for (LivingEntity target : list) {
                    if (target.f_19802_ < 40) {
                        target.f_19802_ = 0;
                    }
                    target.m_6469_(DamageSource.m_19370_((LivingEntity)owner), (float)owner.m_21133_(Attributes.f_22281_));
                    this.m_7579_(pStack, target, owner);
                }
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of();
        }
        CompoundTag tag = stack.m_41784_();
        Multimap map = super.getAttributeModifiers(slot, stack);
        if (tag.m_128451_("attackTicks") <= 0) {
            return map;
        }
        return ImmutableMultimap.builder().putAll(map).put((Object)Attributes.f_22279_, (Object)new AttributeModifier(SPEED_UUID, "Speed Modifier", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL)).build();
    }

    public static void applyEnchants(LivingEntity entity) {
        Enchantment enchantment = (Enchantment)TensuraEnchantments.HOLY_COAT.get();
        Predicate<ItemStack> predicate = stack -> stack.m_41720_() instanceof MinosArmorItem;
        ItemStack handStack = entity.m_6844_(EquipmentSlot.MAINHAND);
        if (handStack.m_41720_() instanceof MinosTridentItem) {
            if (BeyondArmorItem.hasFullSet(entity, predicate, 4)) {
                if (handStack.getEnchantmentLevel(enchantment) != 3) {
                    EngravingEnchantment.engrave((ItemStack)handStack, (Enchantment)enchantment, (int)3);
                }
            } else if (handStack.getEnchantmentLevel(enchantment) != 2) {
                EngravingEnchantment.engrave((ItemStack)handStack, (Enchantment)enchantment, (int)2);
            }
        }
    }

    @Override
    public String getAnimationName() {
        return "minos_trident_attack";
    }

    @Override
    public AnimatedEffectWeapon.Effect getEffect() {
        return switch (this.grade) {
            default -> throw new IncompatibleClassChangeError();
            case Grade.UNIQUE -> AnimatedEffectWeapon.Effect.MINOS_TRIDENT_UNIQUE;
            case Grade.GOD -> AnimatedEffectWeapon.Effect.MINOS_TRIDENT_GOD;
            case Grade.LEGEND -> AnimatedEffectWeapon.Effect.MINOS_TRIDENT_LEGEND;
        };
    }

    public static enum Grade {
        UNIQUE(TensuraToolTiers.SILVER, 30, BeyondRarity.UNIQUE),
        LEGEND(TensuraToolTiers.SILVER, 43, BeyondRarity.LEGEND),
        GOD(TensuraToolTiers.SILVER, 67, BeyondRarity.GOD);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(Tier material, int damage, Rarity rarity) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
        }
    }
}

