/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TensuraLongSword;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NinjatoItem
extends TensuraLongSword {
    private LivingEntity user;

    public NinjatoItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double attackRangeModifier, double critChance, double critDamageMultiplier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, attackRangeModifier, critChance, critDamageMultiplier, pProperties);
    }

    public NinjatoItem(Grade grade) {
        this(grade.material, grade.getDamage(), -2.5f, 0.0, 20.0, 0.5, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41499_(150).m_41497_(grade.getRarity()));
    }

    public static void applyEnchants(ItemStack toStack, ItemStack fromStack, EquipmentSlot toSlot) {
        Item item;
        Enchantment tsukumogami = (Enchantment)TensuraEnchantments.TSUKUMOGAMI.get();
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && (item = toStack.m_41720_()) instanceof NinjatoItem) {
            NinjatoItem ninjatoItem = (NinjatoItem)item;
            if (toStack.getEnchantmentLevel(tsukumogami) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)tsukumogami, (int)1);
            }
        }
    }

    public static boolean isDualWieldingNinjatos(LivingEntity player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_41720_() instanceof NinjatoItem && offHand.m_41720_() instanceof NinjatoItem;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)"\u00a79Buffed stats when used in both hands."));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create((Multimap)super.getAttributeModifiers(EquipmentSlot.MAINHAND, stack));
        double attackSpeed = 0.0;
        double critChance = 0.0;
        if (this.user != null && NinjatoItem.isDualWieldingNinjatos(this.user)) {
            attackSpeed += 2.0;
            critChance += 40.0;
        }
        modifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("abed3f8e-3189-4fc6-b696-c41038247343"), "Weapon modifier", attackSpeed, AttributeModifier.Operation.ADDITION));
        modifiers.put((Object)((Attribute)ManasCoreAttributes.CRIT_CHANCE.get()), (Object)new AttributeModifier(UUID.fromString("abed3f8e-3189-4fc6-b696-c41038247343"), "Weapon modifier", critChance, AttributeModifier.Operation.ADDITION));
        if (slot != EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of();
        }
        return modifiers;
    }

    public void setUser(LivingEntity user) {
        this.user = user;
    }

    public static enum Grade {
        UNIQUE(TensuraToolTiers.PURE_MAGISTEEL, 8, BeyondRarity.UNIQUE),
        LEGEND(TensuraToolTiers.ADAMANTITE, 8, BeyondRarity.LEGEND);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(Tier material, int damage, Rarity rarity) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
        }
    }
}

