/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TwoHandedSword;
import com.github.manasmods.tensura.registry.battlewill.ProjectileArts;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.registry.items.BeyondToolItems;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OgreAxeItem
extends TwoHandedSword {
    public OgreAxeItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, double sweepChance, double oneHandedSweepChance, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, critChance, critDamageMultiplier, pAttackDamageModifier, sweepChance, oneHandedSweepChance, pProperties);
    }

    public OgreAxeItem(Grade grade) {
        this(grade.getMaterial(), grade.getDamage(), -3.6f, 20.0, 0.0, 100.0, 50.0, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41499_(150).m_41497_(grade.getRarity()));
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.great_sword.tooltip"));
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pHand));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (ToolActions.SHIELD_BLOCK.equals(toolAction)) {
            return true;
        }
        return super.canPerformAction(stack, toolAction);
    }

    public static boolean canBoostDamage(DamageSource source) {
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2.m_21205_().m_150930_((Item)BeyondToolItems.OGRE_AXE_GOD.get())) {
            return false;
        }
        if (!(source instanceof TensuraDamageSource)) {
            return false;
        }
        TensuraDamageSource damageSource = (TensuraDamageSource)source;
        if (damageSource.getSkill() == null) {
            return false;
        }
        ManasSkillInstance instance = damageSource.getSkill();
        if (instance.getSkill() == ProjectileArts.OGRE_FLAME.get()) {
            return true;
        }
        return instance.getSkill() == ExtraSkills.BLACK_FLAME.get() && instance.getMode() >= 3;
    }

    public static enum Grade {
        RARE(TensuraToolTiers.LOW_MAGISTEEL, 17, BeyondRarity.RARE),
        UNIQUE(TensuraToolTiers.HIGH_MAGISTEEL, 23, BeyondRarity.UNIQUE),
        LEGEND(TensuraToolTiers.ADAMANTITE, 10, BeyondRarity.LEGEND),
        GOD(TensuraToolTiers.HIHIIROKANE, 10, BeyondRarity.GOD);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(Tier material, int damage, Rarity rarity) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
        }
    }
}

