/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.tensura.entity.magic.projectile.FireBallProjectile;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TensuraLongSword;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RedSpearItem
extends TensuraLongSword {
    public RedSpearItem(Grade grade) {
        this(grade.getMaterial(), grade.getDamage(), -3.0f, 2.0, 0.0, 0.0, 100.0, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(grade.getRarity()));
    }

    public RedSpearItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double attackRangeModifier, double critChance, double critDamageMultiplier, double sweepChance, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, attackRangeModifier, critChance, critDamageMultiplier, sweepChance, pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void fireBolt(Player player) {
        FireBallProjectile fireBall = new FireBallProjectile(player.m_9236_(), (LivingEntity)player);
        fireBall.setBurnTicks(10);
        fireBall.setSpeed(1.2f);
        fireBall.setDamage(40.0f);
        fireBall.setSpiritAttack(true);
        fireBall.m_20242_(true);
        fireBall.setPosAndShoot((LivingEntity)player);
        player.m_9236_().m_7967_((Entity)fireBall);
        player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity entity, int pTimeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int useTicks = this.m_8105_(pStack) - pTimeLeft;
            if (useTicks >= 7) {
                CompoundTag tag = pStack.m_41784_();
                double EP = tag.m_128459_("DurabilityEP");
                int multiShot = pStack.getEnchantmentLevel(Enchantments.f_44959_);
                double cost = 150.0;
                if (EP < cost) {
                    pLevel.m_6269_((Player)null, (Entity)player, SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    if (!pLevel.f_46443_) {
                        this.fireBolt(player);
                        pLevel.m_6269_((Player)null, (Entity)player, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            tag.m_128347_("DurabilityEP", EP - cost);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    player.m_21011_(player.m_7655_(), true);
                }
            }
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        boolean hurt = super.m_7579_(pStack, pTarget, pAttacker);
        if (!hurt) {
            return false;
        }
        pTarget.m_5496_(SoundEvents.f_12273_, 1.0f, 1.0f);
        if (pTarget.m_146888_() < 350) {
            pTarget.m_7311_(20);
        } else {
            pTarget.m_7311_(pTarget.m_20094_() + 20);
        }
        return true;
    }

    public static enum Grade {
        UNIQUE(TensuraToolTiers.PURE_MAGISTEEL, 13, BeyondRarity.UNIQUE),
        LEGENDARY(TensuraToolTiers.ADAMANTITE, 5, BeyondRarity.LEGEND);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(Tier material, int damage, Rarity rarity) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
        }
    }
}

