/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TensuraLongSword;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.weapons.MeatCleaverItem;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;

public class ShibkoboItem
extends TensuraLongSword {
    public ShibkoboItem(Grade grade) {
        this(grade.getMaterial(), grade.getDamage(), -3.0f, 2.0, 0.0, 0.0, 100.0, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41497_(grade.getRarity()));
    }

    public ShibkoboItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double attackRangeModifier, double critChance, double critDamageMultiplier, double sweepChance, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, attackRangeModifier, critChance, critDamageMultiplier, sweepChance, pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_().getShareTag(stack).m_128457_("delay") >= 2.0f) {
            if (player.m_6144_()) {
                stack.m_41720_().getShareTag(stack).m_128350_("attack_range", stack.m_41783_().m_128457_("attack_range") <= 0.0f ? 0.0f : stack.m_41783_().m_128457_("attack_range") - 1.0f);
            } else {
                stack.m_41720_().getShareTag(stack).m_128350_("attack_range", stack.m_41783_().m_128457_("attack_range") >= 5.0f ? 5.0f : stack.m_41783_().m_128457_("attack_range") + 1.0f);
            }
            stack.m_41720_().getShareTag(stack).m_128350_("delay", 0.0f);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        stack.m_41720_().getShareTag(stack).m_128350_("delay", stack.m_41720_().getShareTag(stack).m_128457_("delay") + 1.0f);
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static void applyEnchants(ItemStack toStack, ItemStack fromStack, EquipmentSlot toSlot) {
        Item item;
        Enchantment tsukumogami = (Enchantment)TensuraEnchantments.TSUKUMOGAMI.get();
        Enchantment windInfusion = (Enchantment)BeyondEnchantments.WIND_INFUSION.get();
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && (item = toStack.m_41720_()) instanceof ShibkoboItem) {
            ShibkoboItem shibkoboItem = (ShibkoboItem)item;
            if (toStack.getEnchantmentLevel(tsukumogami) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)tsukumogami, (int)1);
            }
            if (shibkoboItem.m_41460_(fromStack).equals((Object)MeatCleaverItem.Grade.GOD.getRarity()) && toStack.getEnchantmentLevel(windInfusion) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)windInfusion, (int)1);
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create((Multimap)super.getAttributeModifiers(EquipmentSlot.MAINHAND, stack));
        double attackRange = 0.0;
        double damage = 0.0;
        AttributeModifier old_damage = (AttributeModifier)modifiers.get((Object)Attributes.f_22281_).toArray()[0];
        attackRange = stack.m_41783_().m_128457_("attack_range");
        damage = Math.floor(old_damage.m_22218_() * (-0.01 * (double)(stack.m_41783_().m_128457_("attack_range") * 10.0f)));
        modifiers.put((Object)((Attribute)ForgeMod.ATTACK_RANGE.get()), (Object)new AttributeModifier(UUID.fromString("f33c609e-1fcc-45f2-b4a8-1f787f2774ce"), "Weapon modifier", attackRange, AttributeModifier.Operation.ADDITION));
        modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("f33c609e-1fcc-45f2-b4a8-1f787f2774ce"), "Weapon modifier", damage, AttributeModifier.Operation.ADDITION));
        if (slot != EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of();
        }
        return modifiers;
    }

    public static enum Grade {
        UNIQUE(TensuraToolTiers.PURE_MAGISTEEL, 4, BeyondRarity.UNIQUE),
        LEGENDARY(TensuraToolTiers.ADAMANTITE, 3, BeyondRarity.LEGEND),
        GOD(TensuraToolTiers.HIHIIROKANE, 1, BeyondRarity.GOD);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(Tier material, int damage, Rarity rarity) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
        }
    }
}

