/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.SimpleShortSwordItem;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;

public class SpiderDaggerItem
extends SimpleShortSwordItem {
    private final Grade grade;

    public SpiderDaggerItem(Grade grade) {
        super(grade.getMaterial(), grade.getDamage(), -2.0f, -0.75, 20.0, 0.5, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41499_(150).m_41497_(grade.getRarity()));
        this.grade = grade;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        long lastAttackTime;
        long currentTime;
        boolean canAttack = super.m_7579_(pStack, pTarget, pAttacker);
        if (canAttack && (currentTime = pAttacker.f_19853_.m_46467_()) - (lastAttackTime = pStack.m_41784_().m_128454_("LastPoisonTime")) >= (long)this.grade.cooldown) {
            MobEffectInstance existingParalysis = pTarget.m_21124_((MobEffect)TensuraMobEffects.FATAL_POISON.get());
            if (existingParalysis != null && existingParalysis.m_19564_() >= this.grade.maxPoisonLevel - 1) {
                pStack.m_41784_().m_128379_("MaxPoisonReached", true);
            } else {
                pStack.m_41784_().m_128379_("MaxPoisonReached", false);
                pTarget.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.FATAL_POISON.get(), this.grade.poisonDuration, existingParalysis != null ? existingParalysis.m_19564_() + 1 : 0), (Entity)pAttacker);
            }
            pStack.m_41784_().m_128356_("LastPoisonTime", currentTime);
        }
        return canAttack;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.m_150930_((Item)TensuraMobDropItems.SPIDER_FANG.get());
    }

    public static enum Grade {
        SPECIAL(TensuraToolTiers.LOW_MAGISTEEL, 4, BeyondRarity.SPECIAL, 140, 2, 100),
        RARE(TensuraToolTiers.HIGH_MAGISTEEL, 7, BeyondRarity.RARE, 140, 2, 100),
        UNIQUE(TensuraToolTiers.PURE_MAGISTEEL, 5, BeyondRarity.UNIQUE, 140, 3, 100),
        LEGEND(TensuraToolTiers.ADAMANTITE, 11, BeyondRarity.LEGEND, 140, 6, 100);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;
        private final int poisonDuration;
        private final int maxPoisonLevel;
        private final int cooldown;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public int getPoisonDuration() {
            return this.poisonDuration;
        }

        public int getMaxPoisonLevel() {
            return this.maxPoisonLevel;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        private Grade(Tier material, int damage, Rarity rarity, int poisonDuration, int maxPoisonLevel, int cooldown) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
            this.poisonDuration = poisonDuration;
            this.maxPoisonLevel = maxPoisonLevel;
            this.cooldown = cooldown;
        }
    }
}

