/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.items.weapons;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillClientUtils;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.SimpleSpearItem;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import io.github.Memoires.trbeyond.items.BeyondItemGroup;
import io.github.Memoires.trbeyond.items.effects.AnimatedEffectWeapon;
import io.github.Memoires.trbeyond.network.VortexCrashPacket;
import io.github.Memoires.trbeyond.registry.battlewill.BeyondUtilityArts;
import io.github.Memoires.trbeyond.registry.enchantment.BeyondEnchantments;
import io.github.Memoires.trbeyond.util.BeyondRarity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class VortexSpearItem
extends SimpleSpearItem
implements AnimatedEffectWeapon {
    public VortexSpearItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, double critChance, double critDamageMultiplier, int oneHandedAttackDamageModifier, float oneHandedAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, -2.5f, critChance, critDamageMultiplier, oneHandedAttackDamageModifier, oneHandedAttackSpeedModifier, pProperties);
    }

    public VortexSpearItem(Grade grade) {
        this(grade.getMaterial(), grade.getDamage(), -3.2f, 0.0, 0.0, 100, 0.0f, new Item.Properties().m_41491_((CreativeModeTab)BeyondItemGroup.BEYOND_ITEMS).m_41499_(150).m_41497_(grade.getRarity()));
    }

    public void startAnimation(Level level, Player player, ItemStack stack, ManasSkillInstance instance) {
        if (!SkillClientUtils.isSkillHeldClient((LivingEntity)player, (ManasSkill)instance.getSkill())) {
            return;
        }
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        int power = instance.isMastered((LivingEntity)player) ? 10 : 5;
        double cost = 200.0 * (double)power;
        if (!SkillHelper.outOfAura((LivingEntity)player, (double)cost)) {
            if (stack.m_41784_().m_128451_("int") > 1) {
                return;
            }
            player.m_36335_().m_41524_(stack.m_41720_(), 300);
            stack.m_41784_().m_128405_("int", 1);
            if (level.f_46443_) {
                this.playAnimationClientSync(player);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pHand));
        }
        if (!pPlayer.m_6144_()) {
            if ((SkillAPI.getSkillsFrom((Entity)pPlayer).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).isPresent() && ((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)pPlayer).getSkill((ManasSkill)BeyondUtilityArts.SKY_WALK.get()).get()).isToggled() || pPlayer.m_20096_()) && (!SkillHelper.outOfMagicule((LivingEntity)pPlayer, (double)15000.0) || pPlayer.m_7500_())) {
                pPlayer.m_36335_().m_41524_((Item)this, 300);
                if (pLevel.f_46443_) {
                    this.playAnimationClientSync(pPlayer);
                }
                VortexCrashPacket.sendToServer();
            }
            return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pHand));
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pHand));
    }

    public static void applyEnchants(ItemStack toStack, ItemStack fromStack, EquipmentSlot toSlot) {
        Item item;
        Enchantment tsukumogami = (Enchantment)TensuraEnchantments.TSUKUMOGAMI.get();
        Enchantment waterInfusion = (Enchantment)BeyondEnchantments.WATER_INFUSION.get();
        if (toSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && (item = toStack.m_41720_()) instanceof VortexSpearItem) {
            VortexSpearItem spearItem = (VortexSpearItem)item;
            if (toStack.getEnchantmentLevel(tsukumogami) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)tsukumogami, (int)1);
            }
            if (spearItem.m_41460_(fromStack).equals((Object)Grade.GOD.getRarity()) && toStack.getEnchantmentLevel(waterInfusion) < 1) {
                EngravingEnchantment.engrave((ItemStack)toStack, (Enchantment)waterInfusion, (int)1);
            }
        }
    }

    @Override
    public String getAnimationName() {
        return "gabiru_attack";
    }

    @Override
    public AnimatedEffectWeapon.Effect getEffect() {
        return AnimatedEffectWeapon.Effect.GABIRU;
    }

    public static enum Grade {
        UNIQUE(TensuraToolTiers.PURE_MAGISTEEL, 6, BeyondRarity.UNIQUE),
        LEGEND(TensuraToolTiers.ADAMANTITE, 12, BeyondRarity.LEGEND),
        GOD(TensuraToolTiers.HIHIIROKANE, 8, BeyondRarity.GOD);

        private final Tier material;
        private final int damage;
        private final Rarity rarity;

        public Tier getMaterial() {
            return this.material;
        }

        public int getDamage() {
            return this.damage;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        private Grade(Tier material, int damage, Rarity rarity) {
            this.material = material;
            this.damage = damage;
            this.rarity = rarity;
        }
    }
}

