/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MjollmileCoinPacket {
    int changeType;

    public MjollmileCoinPacket(int changeType) {
        this.changeType = changeType;
    }

    public MjollmileCoinPacket(FriendlyByteBuf buf) {
        this.changeType = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.changeType);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int toCount;
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer == null) {
                return;
            }
            Item toCoin = switch (this.changeType) {
                case 1 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "bronze_coin"));
                case 2 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "silver_coin"));
                case 3 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "gold_coin"));
                case 4 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "silver_coin"));
                case 5 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "gold_coin"));
                case 6 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "stellar_gold_coin"));
                default -> null;
            };
            Item fromCoin = switch (this.changeType) {
                case 1 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "silver_coin"));
                case 2 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "gold_coin"));
                case 3 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "stellar_gold_coin"));
                case 4 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "bronze_coin"));
                case 5 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "silver_coin"));
                case 6 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tensura", "gold_coin"));
                default -> null;
            };
            int fromCount = switch (this.changeType) {
                case 1, 2, 3 -> 1;
                case 4, 5, 6 -> 100;
                default -> 0;
            };
            switch (this.changeType) {
                case 1: 
                case 2: 
                case 3: {
                    int n = 100;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    int n = 1;
                    break;
                }
                default: {
                    int n = toCount = 0;
                }
            }
            if (serverPlayer.m_150109_().m_36063_(new ItemStack((ItemLike)fromCoin)) && serverPlayer.m_150109_().m_18947_(fromCoin) >= fromCount) {
                int coinsToRemove = fromCount;
                for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                    ItemStack stack = serverPlayer.m_150109_().m_8020_(i);
                    if (!stack.m_41720_().equals(fromCoin)) continue;
                    int count = Math.min(coinsToRemove, stack.m_41613_());
                    stack.m_41774_(count);
                    if ((coinsToRemove -= count) <= 0) break;
                }
                int coinsToAdd = toCount;
                for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                    int freeSpace;
                    ItemStack stack = serverPlayer.m_150109_().m_8020_(i);
                    if (!stack.m_41720_().equals(toCoin) || (freeSpace = toCoin.m_41459_() - stack.m_41613_()) <= 0) continue;
                    int countToAdd = Math.min(coinsToAdd, freeSpace);
                    stack.m_41769_(countToAdd);
                    if ((coinsToAdd -= countToAdd) <= 0) break;
                }
                while (coinsToAdd > 0) {
                    ItemStack newStack = new ItemStack((ItemLike)toCoin, Math.min(coinsToAdd, toCoin.m_41459_()));
                    int freeSlot = serverPlayer.m_150109_().m_36062_();
                    if (freeSlot != -1) {
                        coinsToAdd -= newStack.m_41613_();
                        serverPlayer.m_150109_().m_6836_(freeSlot, newStack);
                        continue;
                    }
                    coinsToAdd -= newStack.m_41613_();
                    serverPlayer.m_36176_(newStack, false);
                }
            }
            System.out.println("Handling MjollmileCoinPacket with changeType: " + this.changeType);
        });
        ctx.get().setPacketHandled(true);
    }
}

