/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network;

import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.menu.ResearcherEnchantmentMenu;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class RequestResearcherPaymentPacket {
    private final int stellar;
    private final int gold;
    private final int silver;

    public RequestResearcherPaymentPacket() {
        this(0, 0, 0);
    }

    public RequestResearcherPaymentPacket(int stellar, int gold, int silver) {
        this.stellar = stellar;
        this.gold = gold;
        this.silver = silver;
    }

    public static void encode(RequestResearcherPaymentPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.stellar);
        buf.writeInt(msg.gold);
        buf.writeInt(msg.silver);
    }

    public static RequestResearcherPaymentPacket decode(FriendlyByteBuf buf) {
        return new RequestResearcherPaymentPacket(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(RequestResearcherPaymentPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Inventory inv = player.m_150109_();
            boolean success = true;
            if (msg.stellar > 0) {
                success = RequestResearcherPaymentPacket.hasEnoughCoins(inv, (Item)TensuraMaterialItems.STELLAR_GOLD_COIN.get(), msg.stellar) ? (success &= RequestResearcherPaymentPacket.removeCoins(inv, (Item)TensuraMaterialItems.STELLAR_GOLD_COIN.get(), msg.stellar)) : false;
            } else if (msg.gold > 0) {
                success = RequestResearcherPaymentPacket.hasEnoughCoins(inv, (Item)TensuraMaterialItems.GOLD_COIN.get(), msg.gold) ? (success &= RequestResearcherPaymentPacket.removeCoins(inv, (Item)TensuraMaterialItems.GOLD_COIN.get(), msg.gold)) : false;
            } else if (msg.silver > 0) {
                success = RequestResearcherPaymentPacket.hasEnoughCoins(inv, (Item)TensuraMaterialItems.SILVER_COIN.get(), msg.silver) ? (success &= RequestResearcherPaymentPacket.removeCoins(inv, (Item)TensuraMaterialItems.SILVER_COIN.get(), msg.silver)) : false;
            }
            if (!success) {
                player.m_5661_((Component)Component.m_237113_((String)"Not enough coins!"), true);
            } else {
                AbstractContainerMenu patt3034$temp = player.f_36096_;
                if (patt3034$temp instanceof ResearcherEnchantmentMenu) {
                    ResearcherEnchantmentMenu menu = (ResearcherEnchantmentMenu)patt3034$temp;
                    menu.handleFinalizeEnchantment();
                }
                TensuraGUIHelper.playSound((SoundEvent)SoundEvents.f_11887_, (float)1.0f);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static boolean hasEnoughCoins(Inventory inv, Item itemId, int amount) {
        int total = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41720_().equals(itemId) || (total += stack.m_41613_()) < amount) continue;
            return true;
        }
        return false;
    }

    private static boolean removeCoins(Inventory inv, Item itemId, int amount) {
        int remaining = amount;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41720_().equals(itemId)) continue;
            int count = stack.m_41613_();
            int taken = Math.min(count, remaining);
            stack.m_41774_(taken);
            if ((remaining -= taken) <= 0) break;
        }
        return remaining <= 0;
    }
}

