/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network;

import io.github.Memoires.trbeyond.items.effects.AnimatedEffectWeapon;
import io.github.Memoires.trbeyond.network.BeyondNetwork;
import io.github.Memoires.trbeyond.util.PlayerAnimationHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SyncAnimationPacket {
    int playerId;
    String animationName;
    boolean playAnimation;

    public SyncAnimationPacket(int playerId, String animationName) {
        this.playerId = playerId;
        this.animationName = animationName;
        this.playAnimation = true;
    }

    public SyncAnimationPacket(int playerId, boolean playAnimation) {
        this.playerId = playerId;
        this.animationName = "default";
        this.playAnimation = playAnimation;
    }

    public SyncAnimationPacket(int playerId, String animationName, boolean playAnimation) {
        this.playerId = playerId;
        this.animationName = animationName;
        this.playAnimation = playAnimation;
    }

    public SyncAnimationPacket(int playerId) {
        this.playerId = playerId;
        this.animationName = "default";
        this.playAnimation = true;
    }

    public SyncAnimationPacket(FriendlyByteBuf buf) {
        this.playerId = buf.readInt();
        this.animationName = buf.m_130277_();
        this.playAnimation = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.playerId);
        buf.m_130070_(this.animationName);
        buf.writeBoolean(this.playAnimation);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                AbstractClientPlayer player = (AbstractClientPlayer)Minecraft.m_91087_().f_91073_.m_6815_(this.playerId);
                if (player != null) {
                    Item patt2174$temp = player.m_21205_().m_41720_();
                    if (patt2174$temp instanceof AnimatedEffectWeapon) {
                        AnimatedEffectWeapon weapon = (AnimatedEffectWeapon)patt2174$temp;
                        if (this.playAnimation) {
                            if (this.animationName.equals("default")) {
                                weapon.playAnimationClientOnly(player);
                            } else {
                                weapon.playAnimationClientOnly(player, this.animationName);
                            }
                        } else {
                            weapon.stopAnimationClientOnly(player);
                        }
                    } else {
                        PlayerAnimationHelper.playAnimationClientOnly(player, this.animationName);
                    }
                }
            } else {
                BeyondNetwork.toAll(new SyncAnimationPacket(this.playerId, this.animationName, this.playAnimation));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

