/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network;

import io.github.Memoires.trbeyond.capability.boss.IBeyondBossCapability;
import io.github.Memoires.trbeyond.network.ClientAccess;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncBossCapabilityPacket {
    private final CompoundTag tag;
    private final int entityId;

    public SyncBossCapabilityPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130261_();
        this.entityId = buf.readInt();
    }

    public SyncBossCapabilityPacket(IBeyondBossCapability data, int entityId) {
        this.tag = (CompoundTag)data.serializeNBT();
        this.entityId = entityId;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
        buf.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientAccess.updateBossCapability(this.entityId, this.tag)));
        ctx.get().setPacketHandled(true);
    }
}

