/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network;

import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.capability.entities.IEliteMobCapability;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncEliteMobCapabilityPacket {
    private final CompoundTag tag;
    private final int entityId;

    public SyncEliteMobCapabilityPacket(IEliteMobCapability data, int entityId) {
        this.tag = new CompoundTag();
        this.tag.m_128379_("isElite", data.isElite());
        this.entityId = entityId;
    }

    public SyncEliteMobCapabilityPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
        this.entityId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
        buf.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_.m_6815_(this.entityId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                EliteMobCapability.getFrom(livingEntity).ifPresent(cap -> cap.setElite(this.tag.m_128471_("isElite")));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

