/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network.worldgen;

import io.github.Memoires.trbeyond.block.ShrineBlock;
import io.github.Memoires.trbeyond.config.ServerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DungeonSaveData
extends SavedData {
    private Vec3 startGenPos = new Vec3(0.0, 140.0, 0.0);
    private boolean loaded = false;
    private final Map<String, Map<UUID, Integer>> bossCooldown = new HashMap<String, Map<UUID, Integer>>();
    private final List<BlockPos> bossChests = new ArrayList<BlockPos>();
    private List<BlockPos> floor95Doors = new ArrayList<BlockPos>();
    private BlockPos floor95ShopPos;
    private BlockPos BackToLobbyDoor;
    private BlockPos BackToLastKnownLocationDoor;
    private BlockPos bossRushDoor;
    private BlockPos bossRushPos;
    private BlockPos LobbyPos;
    private Map<UUID, Map<BlockPos, Long>> chestCooldown;
    private Map<UUID, Map<BlockPos, Long>> shrineCooldown;
    private List<UUID> tpToDungeonPlayers;

    public static DungeonSaveData get(ServerLevel overworld) {
        return (DungeonSaveData)overworld.m_8895_().m_164861_(DungeonSaveData::new, DungeonSaveData::new, "tensura_dungeon");
    }

    public static DungeonSaveData getOverworld(Level level) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return DungeonSaveData.get(serverLevel.m_7654_().m_129783_());
    }

    private DungeonSaveData() {
    }

    private DungeonSaveData(CompoundTag tag) {
        this();
        BlockPos blockPos;
        this.loaded = tag.m_128471_("loaded");
        this.startGenPos = new Vec3(tag.m_128459_("entranceX"), tag.m_128459_("entranceY"), tag.m_128459_("entranceZ"));
        if (tag.m_128441_("cooldownList")) {
            CompoundTag cooldownList = (CompoundTag)tag.m_128423_("cooldownList");
            this.bossCooldown.clear();
            for (String boss : cooldownList.m_128431_()) {
                CompoundTag cooldownTag = (CompoundTag)cooldownList.m_128423_(boss);
                HashMap<UUID, Integer> list = new HashMap<UUID, Integer>();
                for (String cooldown : cooldownTag.m_128431_()) {
                    list.put(UUID.fromString(cooldown), cooldownTag.m_128451_(cooldown));
                }
                this.bossCooldown.put(boss, list);
            }
        }
        if (tag.m_128441_("bossChests")) {
            CompoundTag bossChestsTag = (CompoundTag)tag.m_128423_("bossChests");
            this.bossChests.clear();
            for (String pos : bossChestsTag.m_128431_()) {
                blockPos = BlockPos.m_122022_((long)bossChestsTag.m_128454_(pos));
                this.bossChests.add(blockPos);
            }
        }
        if (tag.m_128441_("floor95Doors")) {
            CompoundTag floor95DoorsTag = (CompoundTag)tag.m_128423_("floor95Doors");
            this.floor95Doors.clear();
            for (String pos : floor95DoorsTag.m_128431_()) {
                blockPos = BlockPos.m_122022_((long)floor95DoorsTag.m_128454_(pos));
                this.floor95Doors.add(blockPos);
            }
        }
        if (tag.m_128441_("floor95ShopPos")) {
            this.floor95ShopPos = BlockPos.m_122022_((long)tag.m_128454_("floor95ShopPos"));
        }
        if (tag.m_128441_("BackToLobbyDoor")) {
            this.BackToLobbyDoor = BlockPos.m_122022_((long)tag.m_128454_("BackToLobbyDoor"));
        }
        if (tag.m_128441_("BackToLastKnownLocationDoor")) {
            this.BackToLastKnownLocationDoor = BlockPos.m_122022_((long)tag.m_128454_("BackToLastKnownLocationDoor"));
        }
        if (tag.m_128441_("bossRushDoor")) {
            this.bossRushDoor = BlockPos.m_122022_((long)tag.m_128454_("bossRushDoor"));
        }
        if (tag.m_128441_("bossRushPos")) {
            this.bossRushPos = BlockPos.m_122022_((long)tag.m_128454_("bossRushPos"));
        }
        if (tag.m_128441_("LobbyPos")) {
            this.LobbyPos = BlockPos.m_122022_((long)tag.m_128454_("LobbyPos"));
        }
        if (tag.m_128441_("chestCooldown")) {
            CompoundTag chestCooldownTag = (CompoundTag)tag.m_128423_("chestCooldown");
            this.chestCooldown = new HashMap<UUID, Map<BlockPos, Long>>();
            for (String key : chestCooldownTag.m_128431_()) {
                if (key.endsWith("_time")) continue;
                try {
                    UUID playerUUID = UUID.fromString(key);
                    CompoundTag posTag = chestCooldownTag.m_128469_(key);
                    CompoundTag timeTag = chestCooldownTag.m_128441_(key + "_time") ? chestCooldownTag.m_128469_(key + "_time") : null;
                    HashMap<BlockPos, Long> map = new HashMap<BlockPos, Long>();
                    for (String posKey : posTag.m_128431_()) {
                        BlockPos blockPos2 = BlockPos.m_122022_((long)posTag.m_128454_(posKey));
                        long time = timeTag != null && timeTag.m_128441_(posKey) ? timeTag.m_128454_(posKey) : 0L;
                        map.put(blockPos2, time);
                    }
                    this.chestCooldown.put(playerUUID, map);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Skipping invalid chestCooldown key: " + key);
                }
            }
        }
        if (tag.m_128441_("shrineCooldown")) {
            CompoundTag shrineCooldownTag = (CompoundTag)tag.m_128423_("shrineCooldown");
            this.shrineCooldown = new HashMap<UUID, Map<BlockPos, Long>>();
            for (String player : shrineCooldownTag.m_128431_()) {
                CompoundTag posTag = (CompoundTag)shrineCooldownTag.m_128423_(player);
                CompoundTag timeTag = (CompoundTag)shrineCooldownTag.m_128423_(player + "_time");
                HashMap<BlockPos, Long> map = new HashMap<BlockPos, Long>();
                for (String pos : posTag.m_128431_()) {
                    BlockPos blockPos3 = BlockPos.m_122022_((long)posTag.m_128454_(pos));
                    map.put(blockPos3, timeTag.m_128454_(pos));
                }
                this.shrineCooldown.put(UUID.fromString(player), map);
            }
        }
        this.tpToDungeonPlayers = new ArrayList<UUID>();
        if (tag.m_128441_("tpToDungeonPlayers")) {
            CompoundTag tpToDungeonPlayersTag = (CompoundTag)tag.m_128423_("tpToDungeonPlayers");
            this.tpToDungeonPlayers.clear();
            for (String uuid : tpToDungeonPlayersTag.m_128431_()) {
                this.tpToDungeonPlayers.add(UUID.fromString(uuid));
            }
        } else {
            this.tpToDungeonPlayers = new ArrayList<UUID>();
        }
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        Map<BlockPos, Long> map;
        CompoundTag timeTag;
        CompoundTag posTag;
        tag.m_128379_("loaded", this.loaded);
        tag.m_128347_("entranceX", this.startGenPos.f_82479_);
        tag.m_128347_("entranceY", this.startGenPos.f_82480_);
        tag.m_128347_("entranceZ", this.startGenPos.f_82481_);
        CompoundTag bossTag = new CompoundTag();
        for (String string : this.bossCooldown.keySet()) {
            Map<UUID, Integer> map2 = this.bossCooldown.get(string);
            CompoundTag cooldownTag = new CompoundTag();
            for (UUID uuid : map2.keySet()) {
                cooldownTag.m_128405_(uuid.toString(), map2.get(uuid).intValue());
            }
            bossTag.m_128365_(string, (Tag)cooldownTag);
        }
        tag.m_128365_("cooldownList", (Tag)bossTag);
        CompoundTag bossChestsTag = new CompoundTag();
        for (BlockPos blockPos : this.bossChests) {
            bossChestsTag.m_128356_(blockPos.toString(), blockPos.m_121878_());
        }
        tag.m_128365_("bossChests", (Tag)bossChestsTag);
        CompoundTag compoundTag = new CompoundTag();
        for (BlockPos pos : this.floor95Doors) {
            compoundTag.m_128356_(pos.toString(), pos.m_121878_());
        }
        tag.m_128365_("floor95Doors", (Tag)compoundTag);
        if (this.floor95ShopPos != null) {
            tag.m_128356_("floor95ShopPos", this.floor95ShopPos.m_121878_());
        }
        if (this.BackToLobbyDoor != null) {
            tag.m_128356_("BackToLobbyDoor", this.BackToLobbyDoor.m_121878_());
        }
        if (this.BackToLastKnownLocationDoor != null) {
            tag.m_128356_("BackToLastKnownLocationDoor", this.BackToLastKnownLocationDoor.m_121878_());
        }
        if (this.bossRushDoor != null) {
            tag.m_128356_("bossRushDoor", this.bossRushDoor.m_121878_());
        }
        if (this.bossRushPos != null) {
            tag.m_128356_("bossRushPos", this.bossRushPos.m_121878_());
        }
        if (this.LobbyPos != null) {
            tag.m_128356_("LobbyPos", this.LobbyPos.m_121878_());
        }
        if (this.chestCooldown != null) {
            CompoundTag compoundTag2 = new CompoundTag();
            for (UUID player : this.chestCooldown.keySet()) {
                posTag = new CompoundTag();
                timeTag = new CompoundTag();
                map = this.chestCooldown.get(player);
                for (BlockPos pos : map.keySet()) {
                    posTag.m_128356_(pos.toString(), pos.m_121878_());
                    timeTag.m_128356_(pos.toString(), map.get(pos).longValue());
                }
                compoundTag2.m_128365_(player.toString(), (Tag)posTag);
                compoundTag2.m_128365_(player.toString() + "_time", (Tag)timeTag);
            }
            tag.m_128365_("chestCooldown", (Tag)compoundTag2);
        }
        if (this.shrineCooldown != null) {
            CompoundTag compoundTag3 = new CompoundTag();
            for (UUID player : this.shrineCooldown.keySet()) {
                posTag = new CompoundTag();
                timeTag = new CompoundTag();
                map = this.shrineCooldown.get(player);
                for (BlockPos pos : map.keySet()) {
                    posTag.m_128356_(pos.toString(), pos.m_121878_());
                    timeTag.m_128356_(pos.toString(), map.get(pos).longValue());
                }
                compoundTag3.m_128365_(player.toString(), (Tag)posTag);
                compoundTag3.m_128365_(player.toString() + "_time", (Tag)timeTag);
            }
            tag.m_128365_("shrineCooldown", (Tag)compoundTag3);
        }
        CompoundTag compoundTag4 = new CompoundTag();
        if (this.tpToDungeonPlayers != null) {
            for (UUID uuid : this.tpToDungeonPlayers) {
                compoundTag4.m_128359_(uuid.toString(), uuid.toString());
            }
        }
        tag.m_128365_("tpToDungeonPlayers", (Tag)compoundTag4);
        return tag;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
        this.m_77762_();
    }

    public void setStartGenPos(Vec3 startGenPos) {
        this.startGenPos = startGenPos;
        this.m_77762_();
    }

    public Vec3 getStartGenPos() {
        return this.startGenPos;
    }

    public Map<String, Map<UUID, Integer>> getBossCooldownList() {
        return this.bossCooldown;
    }

    public int getBossCooldown(LivingEntity boss, Player player) {
        return this.bossCooldown.get(boss.m_6095_().m_20675_()).get(player.m_20148_());
    }

    public boolean isOnBossCooldown(LivingEntity boss, Player player) {
        Map<String, Map<UUID, Integer>> map = this.getBossCooldownList();
        if (!map.containsKey(boss.m_6095_().m_20675_())) {
            return false;
        }
        if (!map.get(boss.m_6095_().m_20675_()).containsKey(player.m_20148_())) {
            return false;
        }
        return this.bossCooldown.get(boss.m_6095_().m_20675_()).get(player.m_20148_()) > 0;
    }

    public void setBossCooldown(LivingEntity boss, Player player, int cooldown) {
        Map<String, Map<UUID, Integer>> map = this.getBossCooldownList();
        if (map.containsKey(boss.m_6095_().m_20675_())) {
            map.get(boss.m_6095_().m_20675_()).put(player.m_20148_(), cooldown);
        } else {
            HashMap<UUID, Integer> playerMap = new HashMap<UUID, Integer>();
            playerMap.put(player.m_20148_(), cooldown);
            map.put(boss.m_6095_().m_20675_(), playerMap);
        }
    }

    public void tickBossCooldown() {
        Map<String, Map<UUID, Integer>> bossCooldownList = this.getBossCooldownList();
        for (Map.Entry<String, Map<UUID, Integer>> entry : bossCooldownList.entrySet()) {
            for (Map.Entry<UUID, Integer> cooldown : entry.getValue().entrySet()) {
                if (cooldown.getValue() <= 0) continue;
                cooldown.setValue(cooldown.getValue() - 1);
            }
        }
    }

    public void addBossChest(BlockPos pos) {
        this.bossChests.add(pos);
        this.m_77762_();
    }

    public void removeBossChest(BlockPos pos) {
        this.bossChests.remove(pos);
        this.m_77762_();
    }

    public List<BlockPos> getBossChests() {
        return this.bossChests;
    }

    public void clearBossChests() {
        this.bossChests.clear();
        this.m_77762_();
    }

    public boolean hasBossChest() {
        return !this.bossChests.isEmpty();
    }

    public void addFloor95Door(BlockPos pos) {
        this.floor95Doors.add(pos);
        this.m_77762_();
    }

    public void removeFloor95Door(BlockPos pos) {
        this.floor95Doors.remove(pos);
        this.m_77762_();
    }

    public List<BlockPos> getFloor95Doors() {
        return this.floor95Doors;
    }

    public void clearFloor95Doors() {
        this.floor95Doors.clear();
        this.m_77762_();
    }

    public boolean hasFloor95Door() {
        return !this.floor95Doors.isEmpty();
    }

    public void setFloor95ShopPos(BlockPos pos) {
        this.floor95ShopPos = pos;
        this.m_77762_();
    }

    public BlockPos getFloor95ShopPos() {
        return this.floor95ShopPos == null ? new BlockPos(-17, 191, 0) : this.floor95ShopPos;
    }

    public void setBackToLobbyDoor(BlockPos pos) {
        this.BackToLobbyDoor = pos;
        this.m_77762_();
    }

    public BlockPos getBackToLobbyDoor() {
        return this.BackToLobbyDoor == null ? new BlockPos(-29, 192, 0) : this.BackToLobbyDoor;
    }

    public void setBackToLastKnownLocationDoor(BlockPos pos) {
        this.BackToLastKnownLocationDoor = pos;
        this.m_77762_();
    }

    public BlockPos getBackToLastKnownLocationDoor() {
        return this.BackToLastKnownLocationDoor == null ? new BlockPos(-17, 192, -2) : this.BackToLastKnownLocationDoor;
    }

    public void setBossRushTeleporterDoor(BlockPos pos) {
        this.bossRushDoor = pos;
        this.m_77762_();
    }

    public BlockPos getBossRushTeleporterDoor() {
        return this.bossRushDoor == null ? new BlockPos(0, 0, 0) : this.bossRushDoor;
    }

    public void setBossRushPos(BlockPos pos) {
        this.bossRushPos = pos;
        this.m_77762_();
    }

    public BlockPos getBossRushPos() {
        return this.bossRushPos == null ? new BlockPos(0, 0, 0) : this.bossRushPos;
    }

    public void setLobbyPos(BlockPos pos) {
        this.LobbyPos = pos;
        this.m_77762_();
    }

    public BlockPos getLobbyPos() {
        return this.LobbyPos == null ? new BlockPos(-10, 116, 4) : this.LobbyPos;
    }

    public void setChestCooldown(Player player, BlockPos chest, long time) {
        if (this.chestCooldown == null) {
            this.chestCooldown = new HashMap<UUID, Map<BlockPos, Long>>();
        }
        if (!this.chestCooldown.containsKey(player.m_20148_())) {
            this.chestCooldown.put(player.m_20148_(), new HashMap());
        }
        this.chestCooldown.get(player.m_20148_()).put(chest, time);
        this.m_77762_();
    }

    public Map<BlockPos, Long> getChestCooldown(Player player) {
        if (this.chestCooldown == null) {
            return null;
        }
        return this.chestCooldown.get(player.m_20148_());
    }

    public void removeChestCooldown(Player player, BlockPos chest) {
        if (this.chestCooldown == null) {
            return;
        }
        if (!this.chestCooldown.containsKey(player.m_20148_())) {
            return;
        }
        this.chestCooldown.get(player.m_20148_()).remove(chest);
        this.m_77762_();
    }

    public void clearChestCooldown(Player player) {
        if (this.chestCooldown == null) {
            return;
        }
        this.chestCooldown.remove(player.m_20148_());
        this.m_77762_();
    }

    public void clearAllChestCooldown() {
        if (this.chestCooldown == null) {
            return;
        }
        this.chestCooldown.clear();
        this.m_77762_();
    }

    public boolean canOpenChest(Player player, BlockPos chest, long packedTime) {
        long cooldown;
        if (!((Boolean)ServerConfig.INSTANCE.dungeonConfig.chestLock.get()).booleanValue()) {
            return true;
        }
        if (this.chestCooldown == null) {
            return true;
        }
        if (!this.chestCooldown.containsKey(player.m_20148_())) {
            return true;
        }
        if (!this.chestCooldown.get(player.m_20148_()).containsKey(chest)) {
            return true;
        }
        long savedTimeData = this.chestCooldown.get(player.m_20148_()).get(chest);
        return packedTime > savedTimeData + (cooldown = ((Long)ServerConfig.INSTANCE.dungeonConfig.chestCooldown.get()).longValue());
    }

    public void setShrineCooldown(UUID player, BlockPos shrine, long time) {
        if (this.shrineCooldown == null) {
            this.shrineCooldown = new HashMap<UUID, Map<BlockPos, Long>>();
        }
        if (!this.shrineCooldown.containsKey(player)) {
            this.shrineCooldown.put(player, new HashMap());
        }
        this.shrineCooldown.get(player).put(shrine, time);
        this.m_77762_();
    }

    public Map<BlockPos, Long> getShrineCooldown(Player player) {
        if (this.shrineCooldown == null) {
            return null;
        }
        return this.shrineCooldown.get(player.m_20148_());
    }

    public void removeShrineCooldown(Player player, BlockPos shrine) {
        if (this.shrineCooldown == null) {
            return;
        }
        if (!this.shrineCooldown.containsKey(player.m_20148_())) {
            return;
        }
        this.shrineCooldown.get(player.m_20148_()).remove(shrine);
        this.m_77762_();
    }

    public void clearShrineCooldown(Player player) {
        if (this.shrineCooldown == null) {
            return;
        }
        this.shrineCooldown.remove(player.m_20148_());
        this.m_77762_();
    }

    public void clearAllShrineCooldown() {
        if (this.shrineCooldown == null) {
            return;
        }
        this.shrineCooldown.clear();
        this.m_77762_();
    }

    /*
     * Unable to fully structure code
     */
    public boolean canUseShrine(Player player, BlockPos shrine, long packedTime, Level level) {
        if (this.shrineCooldown == null) {
            return true;
        }
        if (!this.shrineCooldown.containsKey(player.m_20148_())) {
            return true;
        }
        if (!this.shrineCooldown.get(player.m_20148_()).containsKey(shrine)) {
            return true;
        }
        savedTimeData = this.shrineCooldown.get(player.m_20148_()).get(shrine);
        block = level.m_8055_(shrine).m_60734_();
        if (!(block instanceof ShrineBlock)) ** GOTO lbl-1000
        shrineBlock = (ShrineBlock)block;
        if (shrineBlock.tier == ShrineBlock.DungeonShrineTier.STELLAR) {
            cooldownLength = ((Integer)ServerConfig.INSTANCE.dungeonConfig.stellarShrineCooldown.get()).intValue();
        } else lbl-1000:
        // 2 sources

        {
            cooldownLength = ((Integer)ServerConfig.INSTANCE.dungeonConfig.shrineCooldown.get()).intValue();
        }
        return packedTime > savedTimeData + cooldownLength;
    }

    public List<UUID> getTpToDungeonPlayers() {
        return this.tpToDungeonPlayers == null ? new ArrayList() : this.tpToDungeonPlayers;
    }

    public void addTpToDungeonPlayer(UUID uuid) {
        if (this.tpToDungeonPlayers == null) {
            this.tpToDungeonPlayers = new ArrayList<UUID>();
        }
        if (this.tpToDungeonPlayers.contains(uuid)) {
            return;
        }
        this.tpToDungeonPlayers.add(uuid);
        this.m_77762_();
    }

    public void removeTpToDungeonPlayer(UUID uuid) {
        if (this.tpToDungeonPlayers != null) {
            this.tpToDungeonPlayers.remove(uuid);
        }
        this.m_77762_();
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

