/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network.worldgen.dimension;

import io.github.Memoires.trbeyond.Database;
import io.github.Memoires.trbeyond.block.DungeonUnlockerBlock;
import io.github.Memoires.trbeyond.block.entity.AnchorBlockEntity;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BeyondDungeon {
    public static final ResourceKey<Level> DUNGEON_LEVEL_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)Database.rl("dungeon"));
    public static final ResourceKey<DimensionType> DUNGEON_DIM_TYPE_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)Database.rl("dungeon"));

    public static void generateNextPart(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockPos anchorPos = new BlockPos(pos.m_123341_() / 800 * 800, 140, pos.m_123343_() / 800 * 800);
        BlockEntity be = level.m_7702_(anchorPos);
        AnchorBlockEntity anchor = (AnchorBlockEntity)be;
        Direction dir = ((Direction)state.m_61143_((Property)DungeonUnlockerBlock.FACING)).m_122424_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_186460_(pos, state.m_60734_(), 1);
        }
    }

    private static void placeChainOfThinHallwaysWithRandomJunction(ServerLevel serverLevel, StructureTemplateManager manager, BlockPos startPos, Direction dir, boolean mirror, Level level) {
        int count = 4 + level.m_213780_().m_188503_(2);
        DungeonJigsawPart chainHallPart = new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(15, 7, 5), new BlockPos(2, 2, 14), "hallway/thin_hallway", false);
        DungeonJigsawPart cornerPart = new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(10, 7, 10), new BlockPos(7, 2, 9), "hallway/thin_hallway_corner", true);
        DungeonJigsawPart tPart = new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(10, 7, 10), new BlockPos(7, 2, 9), "hallway/thin_hallway_t", true);
        DungeonJigsawPart fourWayPart = new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(15, 7, 15), new BlockPos(7, 2, 14), "hallway/thin_hallway_4way", true);
        BlockPos currentEnd = startPos;
        for (int i = 1; i < count; ++i) {
            StructurePlaceSettings chainSettings = new StructurePlaceSettings().m_74377_(mirror ? Mirror.LEFT_RIGHT : Mirror.NONE).m_74379_(BeyondDungeon.getRotFromFacing(chainHallPart.rotation().m_55954_(dir))).m_74392_(true);
            BlockPos chainPos = currentEnd.m_5484_(chainHallPart.rotation().m_55954_(dir), chainHallPart.canBeMirrored() && mirror ? -chainHallPart.relativePos().m_123341_() : chainHallPart.relativePos().m_123341_()).m_5484_(dir, chainHallPart.relativePos().m_123343_()).m_6625_(chainHallPart.relativePos().m_123342_());
            chainPos = chainPos.m_5484_(dir.m_122424_(), 15).m_5484_(dir.m_122428_(), 2).m_6630_(2);
            if (i < count - 1) {
                BlockPos finalChainPos = chainPos;
                BlockPos finalChainPos1 = chainPos;
                manager.m_230407_(chainHallPart.getLocation()).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, finalChainPos, finalChainPos1, chainSettings, level.m_213780_(), 3));
                currentEnd = chainPos.m_5484_(dir, 15);
                continue;
            }
            int choice = level.m_213780_().m_188503_(3);
            DungeonJigsawPart finalPart = switch (choice) {
                case 0 -> cornerPart;
                case 1 -> tPart;
                case 2 -> fourWayPart;
                default -> cornerPart;
            };
            StructurePlaceSettings finalSettings = new StructurePlaceSettings().m_74377_(mirror ? Mirror.LEFT_RIGHT : Mirror.NONE).m_74379_(BeyondDungeon.getRotFromFacing(finalPart.rotation().m_55954_(dir))).m_74392_(true);
            BlockPos finalPos = chainPos.m_5484_(finalPart.rotation().m_55954_(dir), finalPart.canBeMirrored() && mirror ? -finalPart.relativePos().m_123341_() : finalPart.relativePos().m_123341_()).m_5484_(dir, finalPart.relativePos().m_123343_()).m_6625_(finalPart.relativePos().m_123342_());
            BlockPos finalPlacePos = finalPos = finalPos.m_5484_(dir.m_122424_(), 15).m_5484_(dir.m_122428_(), 2).m_6630_(2);
            manager.m_230407_(finalPart.getLocation()).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, finalPlacePos, finalPlacePos, finalSettings, level.m_213780_(), 3));
        }
    }

    private static void genBossFightRoom(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Direction dir = ((Direction)state.m_61143_((Property)DungeonUnlockerBlock.FACING)).m_122424_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            StructureTemplateManager manager = serverLevel.m_215082_();
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(BeyondDungeon.getRotFromFacing(Rotation.CLOCKWISE_90.m_55954_(dir))).m_74392_(true);
            BlockPos rightPart = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 26).m_5484_(dir, 15).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_1")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, rightPart, rightPart, settings, serverLevel.m_213780_(), 3));
            BlockPos placePos = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 10).m_5484_(dir, 15).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_2")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, placePos, placePos, settings, serverLevel.m_213780_(), 3));
            BlockPos leftPart = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -6).m_5484_(dir, 15).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_3")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, leftPart, leftPart, settings, serverLevel.m_213780_(), 3));
            BlockPos leftPart2 = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -22).m_5484_(dir, 15).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_4")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, leftPart2, leftPart2, settings, serverLevel.m_213780_(), 3));
            BlockPos rightPart2 = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 26).m_5484_(dir, 31).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_5")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, rightPart2, rightPart2, settings, serverLevel.m_213780_(), 3));
            BlockPos placePos2 = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 10).m_5484_(dir, 31).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_6")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, placePos2, placePos2, settings, serverLevel.m_213780_(), 3));
            BlockPos leftPart3 = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -6).m_5484_(dir, 31).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_7")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, leftPart3, leftPart3, settings, serverLevel.m_213780_(), 3));
            BlockPos leftPart4 = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -22).m_5484_(dir, 31).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_8")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, leftPart4, leftPart4, settings, serverLevel.m_213780_(), 3));
            BlockPos rightPart3 = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 26).m_5484_(dir, 47).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_9")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, rightPart3, rightPart3, settings, serverLevel.m_213780_(), 3));
            BlockPos placePos3 = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 10).m_5484_(dir, 47).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_10")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, placePos3, placePos3, settings, serverLevel.m_213780_(), 3));
            BlockPos leftPart5 = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -6).m_5484_(dir, 47).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_11")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, leftPart5, leftPart5, settings, serverLevel.m_213780_(), 3));
            BlockPos leftPart6 = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -22).m_5484_(dir, 47).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_12")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, leftPart6, leftPart6, settings, serverLevel.m_213780_(), 3));
            BlockPos preLastPart = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 14).m_5484_(dir, 52).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_13")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, preLastPart, preLastPart, settings, serverLevel.m_213780_(), 3));
            BlockPos lastPart = pos.m_121955_(dir.m_122436_()).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), -1).m_5484_(dir, 52).m_6625_(2);
            manager.m_230407_(Database.rl("dungeon/room_boss/10bossroom_14")).ifPresent(template -> template.m_230328_((ServerLevelAccessor)serverLevel, lastPart, lastPart, settings, serverLevel.m_213780_(), 3));
        }
    }

    private static List<DungeonJigsawPart> getPossibleParts(List<Direction> list, Direction dir) {
        ArrayList<DungeonJigsawPart> parts = new ArrayList<DungeonJigsawPart>();
        if (list.contains(dir)) {
            parts.addAll(DungeonJigsawType.getForward());
        }
        if (list.contains(dir.m_122427_()) || list.contains(dir.m_122428_())) {
            parts.addAll(DungeonJigsawType.getCornerList());
        }
        if (list.contains(dir.m_122427_()) && list.contains(dir.m_122428_())) {
            parts.addAll(DungeonJigsawType.getTwoWays());
            if (list.contains(dir)) {
                parts.addAll(DungeonJigsawType.getThreeWays());
            }
        }
        if (list.contains(Direction.DOWN)) {
            parts.add(DungeonJigsawType.getStairs());
        }
        if (list.contains(Direction.UP)) {
            parts.add(DungeonJigsawType.getUp());
        }
        return parts;
    }

    private static List<Direction> getPossibleDirections(Map<Direction, Boolean> map) {
        return map.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toList();
    }

    private static Map<Direction, Boolean> checkAllDirectionsForGen(Level level, BlockPos genPos, Direction facing, BlockPos anchorPos) {
        EnumMap<Direction, Boolean> map = new EnumMap<Direction, Boolean>(Direction.class);
        Direction.m_235666_().forEach(dir -> map.put((Direction)dir, true));
        BlockPos startPos = genPos.m_5484_(facing, 3);
        BlockPos limitPos = genPos.m_5484_(facing, 15);
        int x = limitPos.m_123341_() / 800 * 800;
        int z = limitPos.m_123343_() / 800 * 800;
        BlockPos finalLimitPos = new BlockPos(x, 140, z);
        Direction.m_235666_().forEach(dir -> {
            if (dir == facing.m_122424_()) {
                map.put((Direction)dir, false);
            } else {
                if (dir == facing && !finalLimitPos.equals((Object)anchorPos)) {
                    map.put((Direction)dir, false);
                    return;
                }
                for (int q = 0; q < 15; ++q) {
                    BlockPos checkPos = startPos.m_5484_(dir, q);
                    BlockState checkState = level.m_8055_(checkPos);
                    if (checkState.m_60795_()) continue;
                    map.put((Direction)dir, false);
                }
            }
        });
        return map;
    }

    public static Rotation getRotFromFacing(Direction to) {
        if (to == Direction.NORTH) {
            return Rotation.NONE;
        }
        if (to == Direction.SOUTH) {
            return Rotation.CLOCKWISE_180;
        }
        if (to == Direction.WEST) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return Rotation.CLOCKWISE_90;
    }

    public record DungeonJigsawPart(Rotation rotation, BlockPos size, BlockPos relativePos, String name, boolean canBeMirrored, List<DungeonJigsawPart> additionalParts, int floorChanges) {
        public DungeonJigsawPart(Rotation rotation, BlockPos size, BlockPos relativePos, String name) {
            this(rotation, size, relativePos, name, false, List.of(), 0);
        }

        public DungeonJigsawPart(Rotation rotation, BlockPos size, BlockPos relativePos, String name, boolean canBeMirrored) {
            this(rotation, size, relativePos, name, canBeMirrored, List.of(), 0);
        }

        public DungeonJigsawPart(Rotation rotation, BlockPos size, BlockPos relativePos, String name, int floorChanges) {
            this(rotation, size, relativePos, name, false, List.of(), floorChanges);
        }

        public DungeonJigsawPart(Rotation rotation, BlockPos size, BlockPos relativePos, String name, boolean canBeMirrored, int floorChanges) {
            this(rotation, size, relativePos, name, canBeMirrored, List.of(), floorChanges);
        }

        public ResourceLocation getLocation() {
            return Database.rl(DungeonJigsawType.getPath(this.name));
        }

        public boolean hasAdditional() {
            return !this.additionalParts().isEmpty();
        }
    }

    public static enum DungeonJigsawType {
        HALLWAY(new DungeonJigsaw(new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(15, 7, 5), new BlockPos(2, 2, 14), "hallway/thin_hallway_end"), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(15, 7, 5), new BlockPos(2, 2, 14), "hallway/thin_hallway"), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(10, 7, 10), new BlockPos(7, 2, 9), "hallway/thin_hallway_corner", true), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(10, 7, 15), new BlockPos(7, 2, 9), "hallway/thin_hallway_t", true), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(15, 7, 15), new BlockPos(7, 2, 14), "hallway/thin_hallway_4way", true))),
        ROOM(new DungeonJigsaw(new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "room/small_room_2"), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "room/small_room_2way1"), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "room/small_room_3way1"), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "room/small_room_end"), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "room/small_room_turn1", true))),
        TRAPROOM(new DungeonJigsaw(new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "traprooms", false))),
        EMPTYROOM(new DungeonJigsaw(new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "emptyroom", false))),
        TREASURE(new DungeonJigsaw(new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "treasure/bronze_chest_loot", false), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "treasure/silver_chest_loot", false), new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(11, 8, 11), new BlockPos(5, 2, 10), "treasure/gold_chest_loot", false))),
        STAIRS(new DungeonJigsaw(new DungeonJigsawPart(Rotation.CLOCKWISE_90, new BlockPos(10, 15, 9), new BlockPos(2, 10, 9), "stairs/small_stairs", true, -1)));

        private final DungeonJigsaw jigsaw;

        private DungeonJigsawType(DungeonJigsaw jigsaw) {
            this.jigsaw = jigsaw;
        }

        public DungeonJigsaw getJigsaw() {
            return this.jigsaw;
        }

        public static DungeonJigsawType getRandom(@NotNull Level level) {
            RandomSource rand = level.m_213780_();
            float roll = rand.m_188501_() * 100.0f;
            if (roll < 66.0f) {
                return HALLWAY;
            }
            if (roll < 80.0f) {
                return TRAPROOM;
            }
            if (roll < 94.0f) {
                return EMPTYROOM;
            }
            if (roll < 99.0f) {
                return TREASURE;
            }
            return STAIRS;
        }

        @NotNull
        public static List<DungeonJigsawPart> getDeadEndList() {
            ArrayList<DungeonJigsawPart> parts = new ArrayList<DungeonJigsawPart>();
            parts.add(HALLWAY.getJigsaw().parts()[0]);
            parts.add(ROOM.getJigsaw().parts()[3]);
            return parts;
        }

        public static DungeonJigsawPart getRandomEnd(Level level) {
            return DungeonJigsawType.getRandomPart(DungeonJigsawType.getDeadEndList(), level);
        }

        public static List<DungeonJigsawPart> getCornerList() {
            ArrayList<DungeonJigsawPart> parts = new ArrayList<DungeonJigsawPart>();
            parts.add(HALLWAY.getJigsaw().parts()[2]);
            parts.add(ROOM.getJigsaw().parts()[4]);
            return parts;
        }

        public static DungeonJigsawPart getRandomCorner(Level level) {
            return DungeonJigsawType.getRandomPart(DungeonJigsawType.getCornerList(), level);
        }

        public static DungeonJigsawPart getStairs() {
            return STAIRS.getJigsaw().parts()[0];
        }

        public static DungeonJigsawPart getUp() {
            return ROOM.getJigsaw().parts()[0];
        }

        public static List<DungeonJigsawPart> getForward() {
            ArrayList<DungeonJigsawPart> list = new ArrayList<DungeonJigsawPart>();
            list.add(HALLWAY.getJigsaw().parts()[1]);
            list.add(ROOM.getJigsaw().parts()[0]);
            return list;
        }

        public static List<DungeonJigsawPart> getTwoWays() {
            ArrayList<DungeonJigsawPart> list = new ArrayList<DungeonJigsawPart>();
            list.add(HALLWAY.getJigsaw().parts()[3]);
            list.add(ROOM.getJigsaw().parts()[1]);
            return list;
        }

        public static List<DungeonJigsawPart> getThreeWays() {
            ArrayList<DungeonJigsawPart> list = new ArrayList<DungeonJigsawPart>();
            list.add(HALLWAY.getJigsaw().parts()[4]);
            list.add(ROOM.getJigsaw().parts()[2]);
            return list;
        }

        public static DungeonJigsawPart getRandomPart(@NotNull List<DungeonJigsawPart> parts, @NotNull Level level) {
            return parts.get(level.m_213780_().m_188503_(parts.size()));
        }

        @NotNull
        public static String getPath(String str) {
            return "dungeon/" + str;
        }
    }

    public record DungeonJigsaw(DungeonJigsawPart[] parts) {
        public DungeonJigsawPart getRandomPart(@NotNull Level level) {
            int q = level.m_213780_().m_188503_(this.parts().length);
            return this.parts[q];
        }
    }
}

