/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network.worldgen.portal;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.data.pack.EntityEPCount;
import com.github.manasmods.tensura.data.pack.TensuraData;
import com.github.manasmods.tensura.entity.BarghestEntity;
import com.github.manasmods.tensura.entity.BulldeerEntity;
import com.github.manasmods.tensura.entity.DirewolfEntity;
import com.github.manasmods.tensura.entity.DragonPeacockEntity;
import com.github.manasmods.tensura.entity.GiantAntEntity;
import com.github.manasmods.tensura.entity.GiantBatEntity;
import com.github.manasmods.tensura.entity.HornedRabbitEntity;
import com.github.manasmods.tensura.entity.HoundDogEntity;
import com.github.manasmods.tensura.entity.HoverLizardEntity;
import com.github.manasmods.tensura.entity.LeechLizardEntity;
import com.github.manasmods.tensura.entity.OneEyedOwlEntity;
import com.github.manasmods.tensura.entity.SlimeEntity;
import com.github.manasmods.tensura.entity.human.MarkLaurenEntity;
import com.github.manasmods.tensura.entity.human.ShinRyuseiEntity;
import com.github.manasmods.tensura.entity.human.ShinjiTanimuraEntity;
import com.github.manasmods.tensura.menu.RaceSelectionMenu;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import io.github.Memoires.trbeyond.Database;
import io.github.Memoires.trbeyond.block.DungeonAnchor;
import io.github.Memoires.trbeyond.block.DungeonUnlockerBlock;
import io.github.Memoires.trbeyond.block.entity.AnchorBlockEntity;
import io.github.Memoires.trbeyond.capability.entities.EliteMobCapability;
import io.github.Memoires.trbeyond.commands.ClearDungeonCommand;
import io.github.Memoires.trbeyond.entity.custom.BossBlackSpiderEntity;
import io.github.Memoires.trbeyond.entity.custom.EvilCentipedeBossEntity;
import io.github.Memoires.trbeyond.entity.custom.GozulEntity;
import io.github.Memoires.trbeyond.entity.custom.LivingArmorEntity;
import io.github.Memoires.trbeyond.entity.custom.MageEntity;
import io.github.Memoires.trbeyond.entity.custom.MezulEntity;
import io.github.Memoires.trbeyond.entity.custom.OgreLordEntity;
import io.github.Memoires.trbeyond.entity.custom.OgreSubEntity;
import io.github.Memoires.trbeyond.entity.custom.ScarletSlimeEntity;
import io.github.Memoires.trbeyond.entity.custom.SkullNightEntity;
import io.github.Memoires.trbeyond.entity.custom.TempestSerpentBossEntity;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.network.worldgen.portal.DungeonStructureSet;
import io.github.Memoires.trbeyond.network.worldgen.portal.info.BossRoomPartStructureInfo;
import io.github.Memoires.trbeyond.network.worldgen.portal.info.DungeonStructureInfo;
import io.github.Memoires.trbeyond.network.worldgen.portal.info.ShopStructureInfo;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlocks;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import io.github.Memoires.trbeyond.util.BeyondSpawnUtils;
import io.github.Memoires.trbeyond.util.DungeonEntitiesSpecfications;
import io.github.Memoires.trbeyond.util.FunctionSpecifications;
import io.github.Memoires.trbeyond.util.MatrixTraversal;
import io.github.Memoires.trbeyond.util.MutableBlockPos;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BeyondTeleporterUpdated {
    public static boolean STOPSPAWNS = false;
    public static int SPAWN_FREQUENCY = 0;
    public static int entitySpawnFrequency;
    public static boolean DontSpawnEntities;
    public static List<DungeonEntitiesSpecfications> entitySpecifications;
    public static int NUM_STRUCTURES;
    public static double LOOPBACK_PROB;
    public static double DEADEND_PROB;
    public static final int MAX_FLOOR_AMOUNT = 20;
    public static boolean BOSS_RUSH;
    public static BlockPos Floor95ShopPos;
    public static BlockPos BackToLobbyDoor;
    public static BlockPos BackToLastKnownLocationDoor;
    public static BlockPos DontLetThisDoorOpen;
    public static BlockPos BossRushTeleporterDoor;
    private static final Map<String, RegistryObject<? extends Skill>> UNIQUE_SKILL_MAP;
    private static final Map<String, RegistryObject<? extends Skill>> EXTRA_SKILL_MAP;
    private static final String[] UNIQUE_SKILL;
    private static final String[] EXTRA_SKILL;

    public static boolean generateDungeon(ServerLevel currentWorld, ServerLevel destinationWorld) {
        STOPSPAWNS = false;
        entitySpawnFrequency = SPAWN_FREQUENCY;
        ClearDungeonCommand.dungeonCleared = false;
        if (ClearDungeonCommand.dungeonCleared && ClearDungeonCommand.createDungeon) {
            NUM_STRUCTURES = ClearDungeonCommand.NUM_STRUCTURES;
            LOOPBACK_PROB = ClearDungeonCommand.LOOPBACK_PROB;
            DEADEND_PROB = ClearDungeonCommand.DEADEND_PROB;
            ClearDungeonCommand.dungeonCleared = false;
            ClearDungeonCommand.createDungeon = false;
        }
        int[] coords = new int[]{0, 120, 0};
        int x = coords[0];
        int y = coords[1];
        int z = coords[2];
        BlockPos destinationPos = new BlockPos(x, y, z);
        BlockState state = destinationWorld.m_8055_(destinationPos = destinationPos.m_6630_(20));
        if (!state.m_61138_((Property)DungeonAnchor.GENERATED)) {
            currentWorld.m_7654_().m_6846_().m_11314_().forEach(player -> player.m_213846_((Component)Component.m_237115_((String)"trbeyond.message.generation").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD))));
            destinationWorld.m_46597_(destinationPos, ((DungeonAnchor)((Object)BeyondBlocks.DUNGEON_ANCHOR.get())).m_49966_());
            BlockEntity be = destinationWorld.m_7702_(destinationPos);
            if (be instanceof AnchorBlockEntity) {
                AnchorBlockEntity anchor = (AnchorBlockEntity)be;
                anchor.setCurrentFloor(0);
            }
            StructureTemplateManager manager = destinationWorld.m_215082_();
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(false);
            BlockPos leftPos = destinationPos.m_6625_(20).m_6625_(5).m_122025_(15);
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, leftPos, "dungeon/start/lobby_left", settings);
            BlockPos rightPos = leftPos.m_122013_(27);
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, rightPos, "dungeon/start/lobby_right", settings);
            BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, destinationPos.m_122030_(29).m_122020_(4).m_6625_(23), Rotation.CLOCKWISE_90, true, 4, 0);
            StructurePlaceSettings hallwaySettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(false);
            DungeonSaveData.getOverworld((Level)destinationWorld).setLobbyPos(destinationPos.m_6625_(24).m_122013_(15).m_122030_(9));
            BlockPos floor95Shop = destinationPos.m_6630_(50).m_122025_(29).m_122013_(2);
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, floor95Shop, "dungeon/room/restaurant_1_best", hallwaySettings);
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, floor95Shop.m_122030_(30), "dungeon/room/restaurant_2_best", hallwaySettings);
            Floor95ShopPos = floor95Shop.m_6630_(3).m_122030_(3).m_122020_(3);
            DungeonSaveData.getOverworld((Level)destinationWorld).setFloor95ShopPos(floor95Shop.m_6630_(3).m_122030_(3).m_122020_(3));
            BackToLobbyDoor = floor95Shop.m_6630_(2).m_122030_(1).m_122020_(17);
            BackToLastKnownLocationDoor = floor95Shop.m_6630_(2).m_122030_(12).m_122020_(0);
            DungeonSaveData.getOverworld((Level)destinationWorld).setBackToLobbyDoor(BackToLobbyDoor);
            DungeonSaveData.getOverworld((Level)destinationWorld).setBackToLastKnownLocationDoor(BackToLastKnownLocationDoor);
            BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, BackToLobbyDoor, Rotation.CLOCKWISE_90, true, 2, 0);
            BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, BackToLastKnownLocationDoor, Rotation.NONE, true, 3, 0);
            hallwaySettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.COUNTERCLOCKWISE_90).m_74392_(false);
            String direction = "south";
            BlockPos firstHallwayPos = destinationPos.m_6625_(25).m_122030_(7).m_122020_(37);
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, firstHallwayPos, "dungeon/floors/1-10/hallway/thin/0", hallwaySettings);
            DontSpawnEntities = true;
            MutableBlockPos previousHallwayPos = new MutableBlockPos(firstHallwayPos.m_122020_(1).m_122030_(2), new StructurePlaceSettings().m_74392_(true).m_74379_(Rotation.CLOCKWISE_90), direction);
            BeyondTeleporterUpdated.placeAllBossRooms(manager, destinationWorld, previousHallwayPos);
            DontSpawnEntities = false;
            BeyondTeleporterUpdated.placeStairs(previousHallwayPos, manager, destinationWorld);
            if (!currentWorld.m_46469_().m_46207_(BeyondGamerules.MOBS_SPAWN_WITH_DUNGEON)) {
                DontSpawnEntities = true;
                STOPSPAWNS = true;
            }
            BeyondTeleporterUpdated.spawnAllEntities(destinationWorld);
            DungeonSaveData.getOverworld((Level)currentWorld).setLoaded(true);
            return true;
        }
        return false;
    }

    private static void placeAllBossRooms(StructureTemplateManager manager, ServerLevel destinationWorld, MutableBlockPos previousHallwayPos) {
        if (BOSS_RUSH) {
            RandomSource random = destinationWorld.m_213780_();
            MutableBlockPos newPos = previousHallwayPos.copy();
            newPos.pos = previousHallwayPos.pos.m_6630_(50);
            DungeonSaveData.getOverworld((Level)destinationWorld).setBossRushPos(newPos.pos.m_122020_(6).m_122030_(1).m_6630_(2));
            BlockPos floor95DoorPos = newPos.pos.m_122020_(3).m_122030_(3).m_6630_(2);
            BlockPos lobbyDoorPos = floor95DoorPos.m_122025_(5);
            newPos.floorcount = 30;
            DungeonStructureInfo startInfo = Database.F21_30.getThinHallwayEnd(random);
            newPos.pos = newPos.pos.m_122020_(startInfo.getSize().m_123341_());
            newPos.direction = Direction.NORTH.m_122433_();
            BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, newPos, 1, startInfo);
            newPos.direction = Direction.SOUTH.m_122433_();
            BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, newPos, 2, Database.F21_30.getThinHallway(random));
            BeyondTeleporterUpdated.placeDesertBossRoom(manager, destinationWorld, newPos);
            newPos.floorcount = 40;
            BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, newPos, 3, Database.F31_40.getThinHallway(random));
            BeyondTeleporterUpdated.placeSwampBossRoom(manager, destinationWorld, newPos);
            newPos.floorcount = 50;
            BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, newPos, 3, Database.F41_50.getThinHallway(random));
            BeyondTeleporterUpdated.placePlainBossRoom(manager, destinationWorld, newPos);
            BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, newPos.pos.m_6630_(1).m_122012_(), Rotation.NONE, true, 2, 0);
            BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, floor95DoorPos, Rotation.NONE, true, 1, 0);
            BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, lobbyDoorPos, Rotation.NONE, true, 2, 0);
        }
    }

    private static void generateMaze(@NotNull MutableBlockPos previousHallwayPos, StructureTemplateManager manager, @NotNull ServerLevel destinationWorld) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getLongThinHallway(random));
        MatrixTraversal traversal = new MatrixTraversal(NUM_STRUCTURES, LOOPBACK_PROB, DEADEND_PROB, previousHallwayPos.direction);
        traversal.generateMaze();
        List<FunctionSpecifications> list = traversal.getFunctions();
        int hallwayCount = 0;
        for (FunctionSpecifications func : list) {
            if (Objects.equals(func.getFunctionName(), "hallway")) {
                int prob = BeyondTeleporterUpdated.getRandomInRange(random, 1, 6);
                if (prob == 6) {
                    BeyondTeleporterUpdated.placeHallwayRandomSideRoom(manager, destinationWorld, previousHallwayPos);
                    continue;
                }
                if (hallwayCount == 20) {
                    BeyondTeleporterUpdated.placefloor95hallway(manager, destinationWorld, previousHallwayPos);
                } else {
                    BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getLongThinHallway(random));
                }
                ++hallwayCount;
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "deadend")) {
                BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getThinHallwayEnd(random));
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "corner_deadend")) {
                BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallwayEnd(random));
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "stairs")) {
                BeyondTeleporterUpdated.placeStairs(previousHallwayPos, manager, destinationWorld);
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "room")) {
                int prob = BeyondTeleporterUpdated.getRandomInRange(random, 1, 3);
                if (prob == 3) {
                    BeyondTeleporterUpdated.placeOnewayRoomWithoutDoors(manager, destinationWorld, previousHallwayPos);
                    continue;
                }
                BeyondTeleporterUpdated.placeOnewayRoom(manager, destinationWorld, previousHallwayPos);
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "corner")) {
                String side = func.getSuccessDirection();
                if (side == null || side.isBlank()) {
                    side = "right";
                }
                BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getLongThinHallway(random), side);
                continue;
            }
            if (Objects.equals(func.getFunctionName(), "three_way")) {
                BeyondTeleporterUpdated.place2wayHallway(previousHallwayPos, manager, destinationWorld, func.getSuccessDirection(), func.getNotSuccessCase(), func.getHallwayLen());
                continue;
            }
            BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getLongThinHallway(random));
        }
    }

    private static void spawnAllEntities(ServerLevel serverLevel) {
        if (entitySpecifications == null || entitySpecifications.isEmpty()) {
            return;
        }
        for (DungeonEntitiesSpecfications spec : entitySpecifications) {
            ServerLevel world = spec.getWorld();
            BlockPos pos = spec.getPos();
            int floorCount = spec.getFloorCount();
            boolean treasureRoom = spec.isTreasureRoom();
            boolean hallwayEnt = spec.isHallwayEntity();
            if (!treasureRoom) continue;
            BeyondSpawnUtils.spawnMobsAt(world, pos, hallwayEnt, true, treasureRoom);
        }
    }

    private static void placeThinHallways(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos, int n, @NotNull DungeonStructureInfo info) {
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            List<DungeonStructureInfo.DungeonCursor> list;
            BlockPos originPos = new BlockPos((Vec3i)previousHallwayPos.pos);
            BlockPos newHallwayPos = info.calculatePlacementPos(originPos, dir);
            BlockPos entityPos = info.calculateEntityPos(originPos, dir);
            if (info.getAddress().equals("dungeon/floors/1-10/hallway/trap/long_thin/special/slime")) {
                newHallwayPos = newHallwayPos.m_7495_();
            }
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, newHallwayPos, info.getAddress(), new StructurePlaceSettings().m_74379_(info.getRotationTo(dir)).m_74392_(true));
            if (!DontSpawnEntities) {
                BeyondTeleporterUpdated.addFloorEntity(destinationWorld, entityPos, previousHallwayPos.floorcount, false, true);
            }
            if ((list = info.calculateNewCursors(originPos, dir)).isEmpty()) {
                return;
            }
            DungeonStructureInfo.DungeonCursor cursor = list.get(0);
            previousHallwayPos.pos = cursor.pos();
            previousHallwayPos.direction = cursor.facing().m_122433_();
        }
    }

    private static void placeStairs(@NotNull MutableBlockPos previousHallwayPos, StructureTemplateManager manager, @NotNull ServerLevel destinationWorld) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        DungeonStructureInfo info = structureSet.getStairs(random);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos placementPos = info.calculatePlacementPos(previousHallwayPos.pos, dir);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, placementPos, structureSet.getStairs(random).getAddress(), new StructurePlaceSettings().m_74392_(true).m_74379_(info.getRotationTo(dir)));
        DungeonStructureInfo.DungeonCursor cursor = info.calculateNewCursors(previousHallwayPos.pos, dir).get(0);
        previousHallwayPos.pos = cursor.pos();
        previousHallwayPos.direction = cursor.facing().m_122433_();
        ++previousHallwayPos.floorcount;
        MutableBlockPos newHallwayPos = previousHallwayPos.copy();
        if (newHallwayPos.floorcount <= 20) {
            if (newHallwayPos.floorcount % 10 != 0) {
                BeyondTeleporterUpdated.generateMaze(newHallwayPos, manager, destinationWorld);
            } else {
                BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, newHallwayPos, 2, structureSet.getThinHallway(random));
                BeyondTeleporterUpdated.placefloor95hallway(manager, destinationWorld, newHallwayPos);
                BeyondTeleporterUpdated.placeBossRoom(manager, destinationWorld, newHallwayPos);
            }
        } else {
            --newHallwayPos.floorcount;
            BeyondTeleporterUpdated.placeDeadendRoom(manager, destinationWorld, newHallwayPos, false);
        }
    }

    private static void placeDeadendRoom(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos, boolean isTrial) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        DungeonStructureInfo info = structureSet.getDeadEndRoom(random, isTrial);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos newHallwayPos = info.calculatePlacementPos(previousHallwayPos.pos, dir);
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74392_(true).m_74379_(info.getRotationTo(dir));
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, newHallwayPos, info.getAddress(), settings);
    }

    private static void placefloor95hallway(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        RandomSource random;
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        DungeonStructureInfo info = structureSet.getThinHallway(random = destinationWorld.m_213780_(), false);
        if (!(info instanceof ShopStructureInfo)) {
            return;
        }
        ShopStructureInfo shopInfo = (ShopStructureInfo)info;
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos newHallwayPos = info.calculatePlacementPos(previousHallwayPos.pos, dir);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, newHallwayPos, info.getAddress(), new StructurePlaceSettings().m_74392_(true).m_74379_(info.getRotationTo(dir)));
        BlockPos unlockerPos = previousHallwayPos.pos.m_5484_(dir, shopInfo.getShopOffset()).m_5484_(dir.m_122428_(), info.getSize().m_123343_() / 2).m_6630_(2);
        if (structureSet == Database.F11_20) {
            unlockerPos = unlockerPos.m_5484_(dir.m_122427_(), 1);
        }
        BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, unlockerPos, info.getRotationTo(dir), true, 1, BeyondTeleporterUpdated.calculateFloorForUnlocker(previousHallwayPos));
        DungeonSaveData.getOverworld((Level)destinationWorld).addFloor95Door(unlockerPos);
        DungeonStructureInfo.DungeonCursor cursor = info.calculateNewCursors(previousHallwayPos.pos, dir).get(0);
        previousHallwayPos.pos = cursor.pos();
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getThinHallway(random));
    }

    private static void placeBossRoom(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        DungeonStructureInfo info = structureSet.getThinHallway(random);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos basePos = new BlockPos((Vec3i)previousHallwayPos.pos);
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(info.getRotationTo(dir)).m_74392_(true);
        List<BossRoomPartStructureInfo> bossRoom = structureSet.getBossRoom();
        for (BossRoomPartStructureInfo bossRoomPart : bossRoom) {
            BlockPos placingPos = bossRoomPart.calculatePlacementPos(basePos, dir);
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, placingPos, bossRoomPart.getAddress(), settings);
        }
        BossRoomPartStructureInfo mainPartInfo = bossRoom.get(0);
        mainPartInfo.getBossSpawner().spawnBoss(destinationWorld, basePos.m_5484_(dir, 10).m_6630_(2), true, previousHallwayPos.floorcount, true);
        BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, basePos.m_5484_(dir, -1).m_6630_(2), info.getRotationTo(dir).m_55952_(Rotation.COUNTERCLOCKWISE_90), true, 0, BeyondTeleporterUpdated.calculateFloorForUnlocker(previousHallwayPos));
        BlockPos exitPosition = mainPartInfo.calculateExitPosition(basePos, dir);
        boolean mustGenFurther = previousHallwayPos.floorcount <= 20;
        BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, exitPosition.m_121945_(dir.m_122424_()).m_6630_(2), info.getRotationTo(dir).m_55952_(Rotation.COUNTERCLOCKWISE_90), true, mustGenFurther ? 0 : 3, BeyondTeleporterUpdated.calculateFloorForUnlocker(previousHallwayPos));
        if (mustGenFurther) {
            previousHallwayPos.pos = new BlockPos((Vec3i)exitPosition);
            BeyondTeleporterUpdated.placeStairs(previousHallwayPos, manager, destinationWorld);
        }
    }

    private static void placeHallwayRandomSideRoom(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, MutableBlockPos previousHallwayPos) {
        RandomSource random = destinationWorld.m_213780_();
        int prob = BeyondTeleporterUpdated.getRandomInRange(random, 1, 9);
        if (prob == 9) {
            BeyondTeleporterUpdated.placeHallwayBothSideRoom(manager, destinationWorld, previousHallwayPos);
            return;
        }
        if (prob <= 4) {
            BeyondTeleporterUpdated.placeHallwayLeftSideRoom(manager, destinationWorld, previousHallwayPos);
        } else {
            BeyondTeleporterUpdated.placeHallwayRightSideRoom(manager, destinationWorld, previousHallwayPos);
        }
    }

    private static void placeHallwayBothSideRoom(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        BlockPos originalPos = new BlockPos((Vec3i)previousHallwayPos.pos);
        DungeonStructureInfo info = structureSet.getBothSideRoom(random);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        StructurePlaceSettings hallway = new StructurePlaceSettings().m_74379_(info.getRotationTo(dir)).m_74392_(true);
        BlockPos hallwayPos = info.calculatePlacementPos(originalPos, dir);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, hallwayPos, info.getAddress(), hallway);
        BlockPos junction = originalPos.m_5484_(dir, info.getSize().m_123341_() / 2);
        DungeonStructureInfo leftDeadEnd = structureSet.getDeadEndRoom(random, false);
        BlockPos leftPos = junction.m_5484_(dir.m_122428_(), info.getSize().m_123343_() / 2 + 1);
        BlockPos leftWithOffset = leftDeadEnd.calculatePlacementPos(leftPos, dir.m_122428_());
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(leftDeadEnd.getRotationTo(dir.m_122428_())).m_74392_(true);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, leftWithOffset, leftDeadEnd.getAddress(), settings);
        BlockPos entityPos = leftDeadEnd.calculateEntityPos(leftPos, dir.m_122428_());
        BeyondTeleporterUpdated.addFloorEntity(destinationWorld, entityPos, previousHallwayPos.floorcount, true, false);
        BlockPos doorPos = leftPos.m_6630_(2).m_121945_(dir.m_122427_());
        BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, doorPos, info.getRotationTo(dir), true, 0, BeyondTeleporterUpdated.calculateFloorForUnlocker(previousHallwayPos));
        DungeonStructureInfo rightDeadEnd = structureSet.getDeadEndRoom(random, false);
        BlockPos rightPos = junction.m_5484_(dir.m_122427_(), info.getSize().m_123343_() / 2 + 1);
        BlockPos rightWithOffset = rightDeadEnd.calculatePlacementPos(rightPos, dir.m_122427_());
        settings = new StructurePlaceSettings().m_74379_(rightDeadEnd.getRotationTo(dir.m_122427_())).m_74392_(true);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, rightWithOffset, rightDeadEnd.getAddress(), settings);
        entityPos = rightDeadEnd.calculateEntityPos(rightPos, dir.m_122427_());
        BeyondTeleporterUpdated.addFloorEntity(destinationWorld, entityPos, previousHallwayPos.floorcount, true, false);
        doorPos = rightPos.m_6630_(2).m_121945_(dir.m_122428_());
        BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, doorPos, info.getRotationTo(dir), true, 0, BeyondTeleporterUpdated.calculateFloorForUnlocker(previousHallwayPos));
        DungeonStructureInfo.DungeonCursor cursor = info.calculateNewCursors(originalPos, dir).get(0);
        previousHallwayPos.pos = cursor.pos();
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 2, structureSet.getLongThinHallway(random));
    }

    private static void placeHallwayLeftSideRoom(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        BlockPos originalPos = new BlockPos((Vec3i)previousHallwayPos.pos);
        DungeonStructureInfo info = structureSet.getLeftSideRoom(random);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        StructurePlaceSettings hallway = new StructurePlaceSettings().m_74379_(info.getRotationTo(dir)).m_74392_(true);
        BlockPos hallwayPos = info.calculatePlacementPos(originalPos, dir);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, hallwayPos, info.getAddress(), hallway);
        BlockPos junction = originalPos.m_5484_(dir, info.getSize().m_123341_() / 2);
        DungeonStructureInfo leftDeadEnd = structureSet.getDeadEndRoom(random);
        BlockPos leftPos = junction.m_5484_(dir.m_122428_(), info.getSize().m_123343_() / 2 + 1);
        BlockPos leftWithOffset = leftDeadEnd.calculatePlacementPos(leftPos, dir.m_122428_());
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(leftDeadEnd.getRotationTo(dir.m_122428_())).m_74392_(true);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, leftWithOffset, leftDeadEnd.getAddress(), settings);
        BlockPos entityPos = leftDeadEnd.calculateEntityPos(leftPos, dir.m_122428_());
        BeyondTeleporterUpdated.addFloorEntity(destinationWorld, entityPos, previousHallwayPos.floorcount, true, false);
        BlockPos doorPos = leftPos.m_6630_(2).m_121945_(dir.m_122427_());
        BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, doorPos, info.getRotationTo(dir), true, 0, BeyondTeleporterUpdated.calculateFloorForUnlocker(previousHallwayPos));
        DungeonStructureInfo.DungeonCursor cursor = info.calculateNewCursors(originalPos, dir).get(0);
        previousHallwayPos.pos = cursor.pos();
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 2, structureSet.getLongThinHallway(random));
    }

    private static void placeHallwayRightSideRoom(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        BlockPos originalPos = new BlockPos((Vec3i)previousHallwayPos.pos);
        DungeonStructureInfo info = structureSet.getRightSideRoom(random);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        StructurePlaceSettings hallway = new StructurePlaceSettings().m_74379_(info.getRotationTo(dir)).m_74392_(true);
        BlockPos hallwayPos = info.calculatePlacementPos(originalPos, dir);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, hallwayPos, info.getAddress(), hallway);
        BlockPos junction = originalPos.m_5484_(dir, info.getSize().m_123341_() / 2);
        DungeonStructureInfo rightDeadEnd = structureSet.getDeadEndRoom(random, false);
        BlockPos rightPos = junction.m_5484_(dir.m_122427_(), info.getSize().m_123343_() / 2 + 1);
        BlockPos rightWithOffset = rightDeadEnd.calculatePlacementPos(rightPos, dir.m_122427_());
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rightDeadEnd.getRotationTo(dir.m_122427_())).m_74392_(true);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, rightWithOffset, rightDeadEnd.getAddress(), settings);
        BlockPos entityPos = rightDeadEnd.calculateEntityPos(rightPos, dir.m_122427_());
        BeyondTeleporterUpdated.addFloorEntity(destinationWorld, entityPos, previousHallwayPos.floorcount, true, false);
        BlockPos doorPos = rightPos.m_6630_(2).m_121945_(dir.m_122428_());
        BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, doorPos, info.getRotationTo(dir), true, 0, BeyondTeleporterUpdated.calculateFloorForUnlocker(previousHallwayPos));
        DungeonStructureInfo.DungeonCursor cursor = info.calculateNewCursors(originalPos, dir).get(0);
        previousHallwayPos.pos = cursor.pos();
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 2, structureSet.getLongThinHallway(random));
    }

    private static void placeCornerHallway(@NotNull MutableBlockPos previousHallwayPos, StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull DungeonStructureInfo thin_hallway) {
        BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, thin_hallway, "right");
    }

    private static void placeCornerHallway(@NotNull MutableBlockPos previousHallwayPos, StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull DungeonStructureInfo thin_hallway, @NotNull String side) {
        String s;
        Rotation baseRot;
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        DungeonStructureInfo info = structureSet.getCornerHallway(random);
        String CORNERHALLWAY = thin_hallway.getAddress().equals("dungeon/hallway/trap/long_thin_hallway_vanta") ? "dungeon/hallway/trap/thin_hallway_corner_vanta" : info.getAddress();
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos originalPos = new BlockPos((Vec3i)previousHallwayPos.pos);
        BlockPos placementPos = info.calculatePlacementPos(originalPos, dir);
        Rotation chosenRot = baseRot = info.getRotationTo(dir);
        String string = s = side == null ? "right" : side.toLowerCase(Locale.ROOT).trim();
        if ("left".equals(s)) {
            chosenRot = baseRot.m_55952_(Rotation.CLOCKWISE_90);
            placementPos = info.calculatePlacementPos(originalPos, dir, Mirror.FRONT_BACK);
            if (dir == Direction.SOUTH) {
                placementPos = placementPos.m_7918_(5, 0, 9);
            } else if (dir == Direction.WEST) {
                placementPos = placementPos.m_7918_(-9, 0, 5);
            } else if (dir == Direction.NORTH) {
                placementPos = placementPos.m_7918_(-5, 0, -9);
            } else if (dir == Direction.EAST) {
                placementPos = placementPos.m_7918_(9, 0, -5);
            }
            if (previousHallwayPos.floorcount > 10) {
                if (dir == Direction.SOUTH) {
                    placementPos = placementPos.m_7918_(-1, 0, 1);
                } else if (dir == Direction.WEST) {
                    placementPos = placementPos.m_7918_(-1, 0, -1);
                } else if (dir == Direction.NORTH) {
                    placementPos = placementPos.m_7918_(1, 0, -1);
                } else if (dir == Direction.EAST) {
                    placementPos = placementPos.m_7918_(1, 0, 1);
                }
            }
        } else if (!"right".equals(s)) {
            chosenRot = baseRot;
        }
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, placementPos, CORNERHALLWAY, new StructurePlaceSettings().m_74379_(chosenRot).m_74392_(true));
        List<DungeonStructureInfo.DungeonCursor> cursors = info.calculateNewCursors(originalPos, dir);
        DungeonStructureInfo.DungeonCursor cursor = "left".equals(side) && cursors.size() > 1 ? cursors.get(1) : cursors.get(0);
        previousHallwayPos.pos = cursor.pos();
        previousHallwayPos.direction = cursor.facing().m_122433_();
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, thin_hallway);
    }

    private static void placeOnewayRoomWithoutDoors(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        DungeonStructureInfo info = structureSet.getOneWayRoom(random);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos newHallwayPos = info.calculatePlacementPos(previousHallwayPos.pos, dir);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, newHallwayPos, info.getAddress(), new StructurePlaceSettings().m_74392_(true).m_74379_(info.getRotationTo(dir)));
        DungeonStructureInfo.DungeonCursor cursor = info.calculateNewCursors(previousHallwayPos.pos, dir).get(0);
        previousHallwayPos.pos = cursor.pos();
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getThinHallway(random));
    }

    private static void placeOnewayRoom(StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        DungeonStructureInfo info = structureSet.getOneWayRoom(random);
        ++MutableBlockPos.room_count;
        BlockPos originalPos = new BlockPos((Vec3i)previousHallwayPos.pos);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos newHallwayPos = info.calculatePlacementPos(originalPos, dir);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, newHallwayPos, info.getAddress(), new StructurePlaceSettings().m_74379_(info.getRotationTo(dir)).m_74392_(true));
        previousHallwayPos.pos = info.calculateNewCursors(originalPos, dir).get(0).pos();
        BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(destinationWorld, originalPos.m_6630_(2), info.getRotationTo(dir).m_55952_(Rotation.CLOCKWISE_90), true, 0, BeyondTeleporterUpdated.calculateFloorForUnlocker(previousHallwayPos));
        BlockPos entityPos = info.calculateEntityPos(originalPos, dir);
        BeyondTeleporterUpdated.addFloorEntity(destinationWorld, entityPos, previousHallwayPos.floorcount, false, false);
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getThinHallway(random));
    }

    private static void place2wayHallway(@NotNull MutableBlockPos previousHallwayPos, StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, String success_direction_left_or_right, String not_success_loopback_or_deadend_or_stairs, int hallway_length) {
        DungeonStructureInfo.DungeonCursor cursor;
        Direction dir;
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        boolean left_success = false;
        int not_success_case = 1;
        if (Objects.equals(not_success_loopback_or_deadend_or_stairs, "loopback")) {
            not_success_case = BeyondTeleporterUpdated.getRandomInRange(random, 1, 3);
        } else if (Objects.equals(not_success_loopback_or_deadend_or_stairs, "deadend")) {
            not_success_case = BeyondTeleporterUpdated.getRandomInRange(random, 4, 5);
        } else if (Objects.equals(not_success_loopback_or_deadend_or_stairs, "stairs")) {
            not_success_case = 6;
        }
        if (Objects.equals(success_direction_left_or_right, "left")) {
            left_success = true;
        }
        if ((dir = Direction.m_122402_((String)previousHallwayPos.direction)) == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos originPos = new BlockPos((Vec3i)previousHallwayPos.pos);
        DungeonStructureInfo junction = structureSet.getJunction(random);
        BlockPos placementPos = junction.calculatePlacementPos(originPos, dir);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, placementPos, junction.getAddress(), new StructurePlaceSettings().m_74379_(junction.getRotationTo(dir)).m_74392_(true));
        List<DungeonStructureInfo.DungeonCursor> cursorList = junction.calculateNewCursors(originPos, dir);
        if (!left_success) {
            cursor = cursorList.get(0);
            previousHallwayPos.direction = cursor.facing().m_122433_();
            previousHallwayPos.pos = cursor.pos();
            DungeonStructureInfo hallway = structureSet.getLongThinHallway(random);
            BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, hallway);
            if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                BeyondTeleporterUpdated.loopbackLeft(previousHallwayPos, manager, destinationWorld);
            } else if (not_success_case == 4 || not_success_case == 5) {
                BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, structureSet.getThinHallway(random));
                int probroomend = BeyondTeleporterUpdated.getRandomInRange(random, 1, 6);
                if (probroomend == 5 || probroomend == 6) {
                    DungeonStructureInfo end = structureSet.getThinHallwayEnd(random);
                    Direction placeDir = Direction.m_122402_((String)previousHallwayPos.direction);
                    if (placeDir == null || placeDir.m_122434_().m_122478_()) {
                        return;
                    }
                    BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, end.calculatePlacementPos(previousHallwayPos.pos, placeDir), end.getAddress(), new StructurePlaceSettings().m_74392_(true).m_74379_(end.getRotationTo(placeDir)));
                } else {
                    previousHallwayPos.direction = dir.m_122428_().m_122433_();
                    BeyondTeleporterUpdated.placeDeadendRoom(manager, destinationWorld, previousHallwayPos, true);
                }
            } else if (not_success_case == 6) {
                BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, structureSet.getThinHallway(random));
                BeyondTeleporterUpdated.placeStairs(previousHallwayPos, manager, destinationWorld);
            }
        } else {
            cursor = cursorList.get(1);
            previousHallwayPos.direction = cursor.facing().m_122433_();
            previousHallwayPos.pos = cursor.pos();
            DungeonStructureInfo hallway = structureSet.getLongThinHallway(random);
            BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, hallway);
            if (not_success_case == 1 || not_success_case == 2 || not_success_case == 3) {
                BeyondTeleporterUpdated.loopbackRight(previousHallwayPos, manager, destinationWorld);
            } else if (not_success_case == 4 || not_success_case == 5) {
                BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, structureSet.getThinHallway(random));
                int probroomend = BeyondTeleporterUpdated.getRandomInRange(random, 1, 6);
                if (probroomend == 5 || probroomend == 6) {
                    BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getThinHallwayEnd(random));
                } else {
                    BeyondTeleporterUpdated.placeDeadendRoom(manager, destinationWorld, previousHallwayPos, true);
                }
            } else if (not_success_case == 6) {
                BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, hallway_length, structureSet.getThinHallway(random));
                BeyondTeleporterUpdated.placeStairs(previousHallwayPos, manager, destinationWorld);
            }
        }
        cursor = !left_success ? cursorList.get(1) : cursorList.get(0);
        previousHallwayPos.pos = cursor.pos();
        previousHallwayPos.direction = cursor.facing().m_122433_();
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getLongThinHallway(random));
    }

    private static void loopbackLeft(@NotNull MutableBlockPos previousHallwayPos, StructureTemplateManager manager, @NotNull ServerLevel destinationWorld) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        int prob = BeyondTeleporterUpdated.getRandomInRange(random, 1, 6);
        if (prob < 5) {
            BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallway(random));
            BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallway(random));
            BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallwayEnd(random));
        } else {
            int probroomend = BeyondTeleporterUpdated.getRandomInRange(random, 1, 6);
            if (probroomend == 5 || probroomend == 6) {
                BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallwayEnd(random));
            } else {
                BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallway(random));
                BeyondTeleporterUpdated.placeDeadendRoom(manager, destinationWorld, previousHallwayPos, false);
            }
        }
    }

    private static void loopbackRight(@NotNull MutableBlockPos previousHallwayPos, StructureTemplateManager manager, @NotNull ServerLevel destinationWorld) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        int prob = BeyondTeleporterUpdated.getRandomInRange(random, 1, 6);
        if (prob < 5) {
            int prob2 = BeyondTeleporterUpdated.getRandomInRange(random, 1, 2);
            if (prob2 == 2) {
                BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, 1, structureSet.getThinHallway(random));
                BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallway(random));
            }
            BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallway(random));
            BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallwayEnd(random));
        } else {
            int probroomend = BeyondTeleporterUpdated.getRandomInRange(random, 1, 6);
            if (probroomend == 5 || probroomend == 6) {
                BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallwayEnd(random));
            } else {
                BeyondTeleporterUpdated.placeCornerHallway(previousHallwayPos, manager, destinationWorld, structureSet.getThinHallway(random));
                BeyondTeleporterUpdated.placeDeadendRoom(manager, destinationWorld, previousHallwayPos, false);
            }
        }
    }

    private static void placeLongCornerHallway(@NotNull MutableBlockPos previousHallwayPos, StructureTemplateManager manager, @NotNull ServerLevel destinationWorld, int length) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        RandomSource random = destinationWorld.m_213780_();
        DungeonStructureInfo corner = structureSet.getCornerHallway(random);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos originalPos = new BlockPos((Vec3i)previousHallwayPos.pos);
        BlockPos placementPos = corner.calculatePlacementPos(originalPos, dir);
        BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, placementPos, corner.getAddress(), new StructurePlaceSettings().m_74379_(corner.getRotationTo(dir)).m_74392_(true));
        DungeonStructureInfo.DungeonCursor cursor = corner.calculateNewCursors(originalPos, dir).get(0);
        previousHallwayPos.pos = cursor.pos();
        previousHallwayPos.direction = cursor.facing().m_122433_();
        if (length < 1) {
            length = 1;
        } else if (length > 2) {
            length = 2;
        }
        DungeonStructureInfo info = structureSet.getThinHallway(random);
        BeyondTeleporterUpdated.placeThinHallways(manager, destinationWorld, previousHallwayPos, length, info);
    }

    private static void placeDesertBossRoom(StructureTemplateManager manager, ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos basePos = new BlockPos((Vec3i)previousHallwayPos.pos);
        List<BossRoomPartStructureInfo> bossRoom = structureSet.getBossRoom();
        for (BossRoomPartStructureInfo bossRoomPart : bossRoom) {
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(bossRoomPart.getRotationTo(dir)).m_74392_(true);
            BlockPos placingPos = bossRoomPart.calculatePlacementPos(basePos, dir);
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, placingPos, bossRoomPart.getAddress(), settings);
        }
        BossRoomPartStructureInfo mainPartInfo = bossRoom.get(0);
        mainPartInfo.getBossSpawner().spawnBoss(destinationWorld, basePos.m_5484_(dir, 10).m_6630_(2), true, previousHallwayPos.floorcount, true);
        previousHallwayPos.pos = mainPartInfo.calculateExitPosition(basePos, dir);
    }

    private static void placeSwampBossRoom(StructureTemplateManager manager, ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos basePos = new BlockPos((Vec3i)previousHallwayPos.pos);
        List<BossRoomPartStructureInfo> bossRoom = structureSet.getBossRoom();
        for (BossRoomPartStructureInfo bossRoomPart : bossRoom) {
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(bossRoomPart.getRotationTo(dir)).m_74392_(true);
            BlockPos placingPos = bossRoomPart.calculatePlacementPos(basePos, dir);
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, placingPos, bossRoomPart.getAddress(), settings);
        }
        BossRoomPartStructureInfo mainPartInfo = bossRoom.get(0);
        mainPartInfo.getBossSpawner().spawnBoss(destinationWorld, basePos.m_5484_(dir, 10).m_6630_(2), true, previousHallwayPos.floorcount, true);
        previousHallwayPos.pos = mainPartInfo.calculateExitPosition(basePos, dir);
    }

    private static void placePlainBossRoom(StructureTemplateManager manager, ServerLevel destinationWorld, @NotNull MutableBlockPos previousHallwayPos) {
        DungeonStructureSet structureSet = Database.getByFloor(previousHallwayPos.floorcount);
        Direction dir = Direction.m_122402_((String)previousHallwayPos.direction);
        if (dir == null || dir.m_122434_().m_122478_()) {
            return;
        }
        BlockPos basePos = new BlockPos((Vec3i)previousHallwayPos.pos);
        List<BossRoomPartStructureInfo> bossRoom = structureSet.getBossRoom();
        for (BossRoomPartStructureInfo bossRoomPart : bossRoom) {
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(bossRoomPart.getRotationTo(dir)).m_74392_(true);
            BlockPos placingPos = bossRoomPart.calculatePlacementPos(basePos, dir);
            BeyondTeleporterUpdated.placeStructure(manager, destinationWorld, placingPos, bossRoomPart.getAddress(), settings);
        }
        BossRoomPartStructureInfo mainPartInfo = bossRoom.get(0);
        mainPartInfo.getBossSpawner().spawnBoss(destinationWorld, basePos.m_5484_(dir, 10).m_6630_(2), true, previousHallwayPos.floorcount, true);
        previousHallwayPos.pos = mainPartInfo.calculateExitPosition(basePos, dir);
    }

    private static void addFloorEntity(ServerLevel world, BlockPos pos, int floorCount, boolean treasureRoom, boolean hallwayEntity) {
        if (STOPSPAWNS) {
            return;
        }
        if (entitySpawnFrequency > 0) {
            --entitySpawnFrequency;
            return;
        }
        entitySpawnFrequency = SPAWN_FREQUENCY;
        DungeonEntitiesSpecfications newEntity = new DungeonEntitiesSpecfications(world, pos, floorCount, treasureRoom, hallwayEntity);
        if (entitySpecifications == null) {
            entitySpecifications = new ArrayList<DungeonEntitiesSpecfications>();
        }
        entitySpecifications.add(newEntity);
    }

    private static void spawnLivingArmorAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        LivingArmorEntity livingArmor = (LivingArmorEntity)((EntityType)BeyondEntities.LIVING_ARMOR.get()).m_20615_((Level)world);
        if (livingArmor != null) {
            if (hallwayEntity) {
                livingArmor.getPersistentData().m_128379_("hallwayEntity", true);
            }
            livingArmor.getPersistentData().m_128405_("floorCount", floorCount);
            livingArmor.getPersistentData().m_128379_("respawn", respawn);
            livingArmor.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            livingArmor.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            livingArmor.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            livingArmor.m_21530_();
            livingArmor.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)livingArmor);
        }
    }

    private static void spawnScarletSlimeAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        ScarletSlimeEntity scarletSlime = (ScarletSlimeEntity)((EntityType)BeyondEntities.SCARLET_SLIME.get()).m_20615_((Level)world);
        if (scarletSlime != null) {
            if (hallwayEntity) {
                scarletSlime.getPersistentData().m_128379_("hallwayEntity", true);
            }
            scarletSlime.getPersistentData().m_128405_("floorCount", floorCount);
            scarletSlime.getPersistentData().m_128379_("respawn", respawn);
            scarletSlime.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            scarletSlime.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            scarletSlime.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            scarletSlime.m_21530_();
            scarletSlime.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)scarletSlime);
        }
    }

    private static void spawnMageAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        MageEntity mage = (MageEntity)((EntityType)BeyondEntities.MAGE.get()).m_20615_((Level)world);
        if (mage != null) {
            if (hallwayEntity) {
                mage.getPersistentData().m_128379_("hallwayEntity", true);
            }
            mage.getPersistentData().m_128405_("floorCount", floorCount);
            mage.getPersistentData().m_128379_("respawn", respawn);
            mage.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            mage.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            mage.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            mage.m_21530_();
            mage.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)mage);
        }
    }

    private static void spawnSkullNightAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        SkullNightEntity skullNight = (SkullNightEntity)((EntityType)BeyondEntities.SKULL_NIGHT.get()).m_20615_((Level)world);
        if (skullNight != null) {
            if (hallwayEntity) {
                skullNight.getPersistentData().m_128379_("hallwayEntity", true);
            }
            skullNight.getPersistentData().m_128405_("floorCount", floorCount);
            skullNight.getPersistentData().m_128379_("respawn", respawn);
            skullNight.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            skullNight.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            skullNight.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            skullNight.m_21530_();
            skullNight.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)skullNight);
        }
    }

    private static void spawnMarkLaurenAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean repsawn) {
        MarkLaurenEntity markLauren = (MarkLaurenEntity)((EntityType)TensuraEntityTypes.MARK_LAUREN.get()).m_20615_((Level)world);
        if (markLauren != null) {
            if (hallwayEntity) {
                markLauren.getPersistentData().m_128379_("hallwayEntity", true);
            }
            markLauren.getPersistentData().m_128405_("floorCount", floorCount);
            markLauren.getPersistentData().m_128379_("respawn", repsawn);
            markLauren.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            markLauren.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            markLauren.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            markLauren.m_21530_();
            markLauren.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)markLauren);
        }
    }

    private static void spawnShinjiTanimuraAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        ShinjiTanimuraEntity shinjiTanimura = (ShinjiTanimuraEntity)((EntityType)TensuraEntityTypes.SHINJI_TANIMURA.get()).m_20615_((Level)world);
        if (shinjiTanimura != null) {
            if (hallwayEntity) {
                shinjiTanimura.getPersistentData().m_128379_("hallwayEntity", true);
            }
            shinjiTanimura.getPersistentData().m_128405_("floorCount", floorCount);
            shinjiTanimura.getPersistentData().m_128379_("respawn", respawn);
            shinjiTanimura.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            shinjiTanimura.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            shinjiTanimura.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            shinjiTanimura.m_21530_();
            shinjiTanimura.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)shinjiTanimura);
        }
    }

    private static void spawnShinRyuseiAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        ShinRyuseiEntity shinRyusei = (ShinRyuseiEntity)((EntityType)TensuraEntityTypes.SHIN_RYUSEI.get()).m_20615_((Level)world);
        if (shinRyusei != null) {
            if (hallwayEntity) {
                shinRyusei.getPersistentData().m_128379_("hallwayEntity", true);
            }
            shinRyusei.getPersistentData().m_128405_("floorCount", floorCount);
            shinRyusei.getPersistentData().m_128379_("respawn", respawn);
            shinRyusei.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            shinRyusei.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            shinRyusei.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            shinRyusei.m_21530_();
            shinRyusei.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)shinRyusei);
        }
    }

    public static void spawnBulldeerAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        BulldeerEntity bulldeerEntity = (BulldeerEntity)((EntityType)TensuraEntityTypes.BULLDEER.get()).m_20615_((Level)world);
        if (bulldeerEntity != null) {
            if (hallwayEntity) {
                bulldeerEntity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            bulldeerEntity.getPersistentData().m_128405_("floorCount", floorCount);
            bulldeerEntity.getPersistentData().m_128379_("respawn", respawn);
            bulldeerEntity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            bulldeerEntity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            bulldeerEntity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            bulldeerEntity.m_21530_();
            bulldeerEntity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)bulldeerEntity);
        }
    }

    public static void spawnOneEyedOwlAt(@NotNull ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        int getrandomowls = BeyondTeleporterUpdated.getRandomInRange(world.m_213780_(), 2, 5);
        for (int i = 0; i < getrandomowls; ++i) {
            OneEyedOwlEntity oneEyedOwlEntity = (OneEyedOwlEntity)((EntityType)TensuraEntityTypes.ONE_EYED_OWL.get()).m_20615_((Level)world);
            if (oneEyedOwlEntity != null) {
                if (hallwayEntity) {
                    oneEyedOwlEntity.getPersistentData().m_128379_("hallwayEntity", true);
                }
                oneEyedOwlEntity.getPersistentData().m_128405_("floorCount", floorCount);
                oneEyedOwlEntity.getPersistentData().m_128379_("respawn", respawn);
                oneEyedOwlEntity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
                oneEyedOwlEntity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
                oneEyedOwlEntity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
                oneEyedOwlEntity.m_21530_();
                oneEyedOwlEntity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                world.m_7967_((Entity)oneEyedOwlEntity);
            }
            respawn = false;
        }
    }

    public static void spawnDragonPeacockAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        DragonPeacockEntity dragonPeacockEntity = (DragonPeacockEntity)((EntityType)TensuraEntityTypes.DRAGON_PEACOCK.get()).m_20615_((Level)world);
        if (dragonPeacockEntity != null) {
            if (hallwayEntity) {
                dragonPeacockEntity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            dragonPeacockEntity.getPersistentData().m_128405_("floorCount", floorCount);
            dragonPeacockEntity.getPersistentData().m_128379_("respawn", respawn);
            dragonPeacockEntity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            dragonPeacockEntity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            dragonPeacockEntity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            dragonPeacockEntity.m_21530_();
            dragonPeacockEntity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)dragonPeacockEntity);
        }
    }

    public static void spawnMultipleSmallSlimes(@NotNull ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        int count = BeyondTeleporterUpdated.getRandomInRange(world.m_213780_(), 5, 7);
        for (int i = 0; i < count; ++i) {
            double offsetX = (world.f_46441_.m_188500_() - 0.5) * 0.5;
            double offsetZ = (world.f_46441_.m_188500_() - 0.5) * 0.5;
            if (i > 0) {
                respawn = false;
            }
            BeyondTeleporterUpdated.spawnSmallSlimeAt(world, pos, offsetX, offsetZ, hallwayEntity, floorCount, respawn);
        }
    }

    public static void spawnSmallSlimeAt(ServerLevel world, BlockPos pos, double offsetX, double offsetZ, boolean hallwayEntity, int floorCount, boolean respawn) {
        SlimeEntity slime = (SlimeEntity)((EntityType)TensuraEntityTypes.SLIME.get()).m_20615_((Level)world);
        if (slime != null) {
            int random_size = BeyondTeleporterUpdated.getRandomInRange(world.m_213780_(), 1, 4);
            slime.setSize(random_size, true);
            if (hallwayEntity) {
                slime.getPersistentData().m_128379_("hallwayEntity", true);
            }
            slime.getPersistentData().m_128405_("floorCount", floorCount);
            slime.getPersistentData().m_128379_("respawn", respawn);
            slime.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            slime.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            slime.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            slime.m_21530_();
            slime.m_6034_((double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5 + offsetZ);
            world.m_7967_((Entity)slime);
        }
    }

    public static void spawnHornedRabbitsAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        HornedRabbitEntity entity = (HornedRabbitEntity)((EntityType)TensuraEntityTypes.HORNED_RABBIT.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnBarghastAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        BarghestEntity barghestEntity = (BarghestEntity)((EntityType)TensuraEntityTypes.BARGHEST.get()).m_20615_((Level)world);
        if (barghestEntity != null) {
            if (hallwayEntity) {
                barghestEntity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            barghestEntity.getPersistentData().m_128405_("floorCount", floorCount);
            barghestEntity.getPersistentData().m_128379_("respawn", respawn);
            barghestEntity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            barghestEntity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            barghestEntity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            barghestEntity.m_21530_();
            barghestEntity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)barghestEntity);
        }
    }

    public static void spawnHoundDogAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        HoundDogEntity entity = (HoundDogEntity)((EntityType)TensuraEntityTypes.HOUND_DOG.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnHoverLizardAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        HoverLizardEntity entity = (HoverLizardEntity)((EntityType)TensuraEntityTypes.HOVER_LIZARD.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnLeechLizardAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        LeechLizardEntity entity = (LeechLizardEntity)((EntityType)TensuraEntityTypes.LEECH_LIZARD.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnDireworlfAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        DirewolfEntity entity = (DirewolfEntity)((EntityType)TensuraEntityTypes.DIREWOLF.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnGiantBatAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        GiantBatEntity entity = (GiantBatEntity)((EntityType)TensuraEntityTypes.GIANT_BAT.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnGiantAntAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        GiantAntEntity entity = (GiantAntEntity)((EntityType)TensuraEntityTypes.GIANT_ANT.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnZombieAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_((Level)world);
        if (zombie != null) {
            if (hallwayEntity) {
                zombie.getPersistentData().m_128379_("hallwayEntity", true);
            }
            zombie.getPersistentData().m_128405_("floorCount", floorCount);
            zombie.getPersistentData().m_128379_("respawn", respawn);
            zombie.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            zombie.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            zombie.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            zombie.m_21530_();
            zombie.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)zombie);
        }
    }

    public static void spawnBlackSpiderAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        BossBlackSpiderEntity entity = (BossBlackSpiderEntity)((EntityType)BeyondEntities.BOSS_BLACK_SPIDER.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128379_("isBoss", true);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnEvilCentipede(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        EvilCentipedeBossEntity entity = (EvilCentipedeBossEntity)((EntityType)BeyondEntities.EVIL_CENTIPEDE_BOSS.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128379_("isBoss", true);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            BeyondTeleporterUpdated.setBossElite((LivingEntity)entity);
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnOgreLord(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        OgreLordEntity entity = (OgreLordEntity)((EntityType)BeyondEntities.OGRE_LORD.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128379_("isBoss", true);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            BeyondTeleporterUpdated.setBossElite((LivingEntity)entity);
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
            for (int i = 0; i < 5; ++i) {
                double angle = Math.PI * 2 * (double)i / 5.0;
                double radius = 2.5;
                double offsetX = Math.cos(angle) * radius;
                double offsetZ = Math.sin(angle) * radius;
                OgreSubEntity sub = (OgreSubEntity)((EntityType)BeyondEntities.OGRE_SUB.get()).m_20615_((Level)world);
                if (sub == null) continue;
                BlockPos subPos = pos.m_7918_((int)offsetX, 0, (int)offsetZ);
                sub.m_6034_((double)subPos.m_123341_() + 0.5, subPos.m_123342_(), (double)subPos.m_123343_() + 0.5);
                sub.m_21530_();
                world.m_7967_((Entity)sub);
            }
        }
    }

    public static void spawnGozul(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        GozulEntity entity = (GozulEntity)((EntityType)BeyondEntities.GOZUL.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128379_("isBoss", true);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            BeyondTeleporterUpdated.setBossElite((LivingEntity)entity);
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnPlainBoss(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        if (world.m_213780_().m_188499_()) {
            BeyondTeleporterUpdated.spawnMezul(world, pos, hallwayEntity, floorCount, respawn);
        } else {
            BeyondTeleporterUpdated.spawnGozul(world, pos, hallwayEntity, floorCount, respawn);
        }
    }

    public static void spawnMezul(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        MezulEntity entity = (MezulEntity)((EntityType)BeyondEntities.MEZUL.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128379_("isBoss", true);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            BeyondTeleporterUpdated.setBossElite((LivingEntity)entity);
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnTempestSerpant(ServerLevel world, BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn) {
        TempestSerpentBossEntity entity = (TempestSerpentBossEntity)((EntityType)BeyondEntities.TEMPEST_SERPENT_BOSS.get()).m_20615_((Level)world);
        if (entity != null) {
            if (hallwayEntity) {
                entity.getPersistentData().m_128379_("hallwayEntity", true);
            }
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128379_("isBoss", true);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            BeyondTeleporterUpdated.setBossElite((LivingEntity)entity);
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void setBossElite(LivingEntity entity) {
        TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> EliteMobCapability.getFrom(entity).ifPresent(cap1 -> {
            cap1.setElite(true);
            EliteMobCapability.sync(entity);
            BeyondTeleporterUpdated.applyRandomSkillLogic(entity);
            boolean epSet = false;
            for (EntityEPCount entityEP : TensuraData.getEntityEP()) {
                AttributeInstance aura;
                if (!entityEP.getEntity().equals((Object)EntityType.m_20613_((EntityType)entity.m_6095_()))) continue;
                int minEP = entityEP.getMinEP();
                int maxEP = Math.max(minEP + 1, entityEP.getMaxEP() + 1);
                double randomEP = entity.m_217043_().m_216339_(0, maxEP - minEP);
                AttributeInstance magicule = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                if (magicule != null) {
                    magicule.m_22100_((double)minEP / 2.0);
                    randomEP += magicule.m_22135_();
                }
                if ((aura = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())) != null) {
                    aura.m_22100_((double)minEP / 2.0);
                    randomEP += aura.m_22135_();
                }
                cap.setEP(entity, randomEP);
                epSet = true;
                for (ResourceLocation skillID : entityEP.getSkills()) {
                    ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillID);
                    if (skill == null) continue;
                    TensuraSkillInstance instance = new TensuraSkillInstance(skill);
                    SkillAPI.getSkillsFrom((Entity)entity).learnSkill((ManasSkillInstance)instance);
                    if (!instance.canBeToggled(entity)) continue;
                    instance.setToggled(true);
                }
                RaceSelectionMenu.grantLearningResistance((LivingEntity)entity);
                break;
            }
            if (!epSet || cap.getEP() <= 0.0) {
                AttributeInstance aura;
                double energy = 100.0f * entity.m_21233_();
                AttributeInstance magicule = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                if (magicule != null) {
                    energy += magicule.m_22135_();
                }
                if ((aura = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())) != null) {
                    energy += aura.m_22135_();
                }
                cap.setEP(entity, energy);
            }
            if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.MONSTER)) {
                cap.setMajin(true);
            }
            BeyondTeleporterUpdated.applyEPToEntity(entity, cap.getEP());
            TensuraEPCapability.sync((LivingEntity)entity);
        }));
    }

    private static void applyEPToEntity(LivingEntity entity, double amount) {
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
            cap.setEP(entity, amount * 10.0, true);
            cap.setCurrentEP(entity, cap.getEP());
            TensuraEPCapability.sync((LivingEntity)entity);
        });
    }

    private static void applyRandomSkillLogic(LivingEntity living) {
        TensuraEPCapability.getFrom((LivingEntity)living).ifPresent(cap -> {
            BeyondTeleporterUpdated.assignRandomSkill(living, UNIQUE_SKILL_MAP, UNIQUE_SKILL);
            BeyondTeleporterUpdated.assignRandomSkill(living, EXTRA_SKILL_MAP, EXTRA_SKILL);
        });
    }

    private static void assignRandomSkill(LivingEntity living, @NotNull Map<String, RegistryObject<? extends Skill>> skillMap, String @NotNull [] skillArray) {
        String randomSkill = skillArray[new Random().nextInt(skillArray.length)];
        RegistryObject<? extends Skill> skillRegistryObject = skillMap.get(randomSkill);
        if (skillRegistryObject != null) {
            ResourceLocation skillId = skillRegistryObject.getId();
            ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillId);
            if (skill != null) {
                TensuraSkillInstance instance = new TensuraSkillInstance(skill);
                SkillAPI.getSkillsFrom((Entity)living).learnSkill((ManasSkillInstance)instance);
                if (instance.canBeToggled(living)) {
                    instance.setToggled(true);
                }
                instance.setMastery(skill.getMaxMastery());
                instance.markDirty();
                SkillAPI.getSkillsFrom((Entity)living).syncChanges();
                if (living instanceof LivingEntity) {
                    instance.onSkillMastered(living);
                }
                living.m_213846_((Component)Component.m_237110_((String)"tensura.skill.mastery", (Object[])new Object[]{skill.getName()}).m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    public static boolean checkfloor95door(BlockPos pos, Level level) {
        if (level == null || level.m_7654_() == null) {
            return false;
        }
        return DungeonSaveData.get(level.m_7654_().m_129783_()).getFloor95Doors().contains(pos);
    }

    public static int checkLobbyOrLastKnownLocationDoor(BlockPos pos, Level level) {
        if (level == null || level.m_7654_() == null) {
            return 0;
        }
        BlockPos lastKnownPosDoor = DungeonSaveData.getOverworld(level).getBackToLastKnownLocationDoor();
        BlockPos BackToLobbyDoor = DungeonSaveData.getOverworld(level).getBackToLobbyDoor();
        if (pos.m_123341_() == BackToLobbyDoor.m_123341_() && pos.m_123342_() == BackToLobbyDoor.m_123342_() && pos.m_123343_() == BackToLobbyDoor.m_123343_()) {
            return -1;
        }
        if (pos.m_123341_() == lastKnownPosDoor.m_123341_() && pos.m_123342_() == lastKnownPosDoor.m_123342_() && pos.m_123343_() == lastKnownPosDoor.m_123343_()) {
            return 1;
        }
        return 0;
    }

    public static boolean checkBossRushDoor(BlockPos pos, Level level) {
        if (level == null || level.m_7654_() == null) {
            return false;
        }
        BlockPos BossRushTeleporterDoor = DungeonSaveData.getOverworld((Level)level.m_7654_().m_129783_()).getBossRushTeleporterDoor();
        if (BossRushTeleporterDoor == null) {
            return false;
        }
        return pos.m_123341_() == BossRushTeleporterDoor.m_123341_() && pos.m_123342_() == BossRushTeleporterDoor.m_123342_() && pos.m_123343_() == BossRushTeleporterDoor.m_123343_();
    }

    public static boolean checkDontLetThisDoorOpen(BlockPos pos) {
        if (DontLetThisDoorOpen == null) {
            return false;
        }
        return pos.m_123341_() == DontLetThisDoorOpen.m_123341_() && pos.m_123342_() == DontLetThisDoorOpen.m_123342_() && pos.m_123343_() == DontLetThisDoorOpen.m_123343_();
    }

    public static int getRandomInRange(@NotNull RandomSource random, int min, int max) {
        return random.m_216332_(min, max);
    }

    private static void placeStructure(@NotNull StructureTemplateManager manager, ServerLevel world, BlockPos pos, String structurePath, StructurePlaceSettings settings) {
        Optional opt = manager.m_230407_(Database.rl(structurePath));
        if (opt.isPresent()) {
            ((StructureTemplate)opt.get()).m_230328_((ServerLevelAccessor)world, pos, pos, settings, world.m_213780_(), 3);
            return;
        }
        if (manager.m_230407_(Database.rl("dungeon/floors/1-10/room/trap/treasure/dead_end/empty_chest_room")).isPresent()) {
            System.out.println("Structure path was null:(" + structurePath + "), defaulting to: dungeon/floors/1-10/room/trap/treasure/dead_end/empty_chest_room. at:" + String.valueOf(pos));
            opt = manager.m_230407_(Database.rl("dungeon/floors/1-10/room/trap/treasure/dead_end/empty_chest_room"));
            ((StructureTemplate)opt.get()).m_230328_((ServerLevelAccessor)world, pos, pos, settings, world.m_213780_(), 3);
            return;
        }
        String msg = "Missing structure template: " + structurePath + " at " + String.valueOf(pos);
        throw new IllegalStateException(msg);
    }

    public static void placeDungeonUnlockerBlockWithRotation(ServerLevel destinationWorld, BlockPos pos, Rotation rotation, boolean canGenerate, int type, int floor) {
        if (rotation == null) {
            throw new IllegalArgumentException("Rotation cannot be null.");
        }
        Direction baseDir = Direction.NORTH;
        Direction facing = rotation.m_55954_(baseDir);
        if (!facing.m_122434_().m_122479_()) {
            throw new IllegalArgumentException("DungeonUnlockerBlock can only face horizontal directions.");
        }
        BlockState unlockerState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((DungeonUnlockerBlock)((Object)BeyondBlocks.DUNGEON_UNLOCKER_BLOCK.get())).m_49966_().m_61124_((Property)DungeonUnlockerBlock.FACING, (Comparable)facing)).m_61124_((Property)DungeonUnlockerBlock.CAN_GENERATE, (Comparable)Boolean.valueOf(canGenerate))).m_61124_((Property)DungeonUnlockerBlock.ENABLED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DungeonUnlockerBlock.TYPE, (Comparable)Integer.valueOf(type))).m_61124_((Property)DungeonUnlockerBlock.FLOOR, (Comparable)Integer.valueOf(floor));
        destinationWorld.m_7731_(pos, unlockerState, 3);
    }

    private static int calculateFloorForUnlocker(@NotNull MutableBlockPos pos) {
        return (pos.floorcount - 1) / 10;
    }

    static {
        DontSpawnEntities = false;
        NUM_STRUCTURES = 30;
        LOOPBACK_PROB = 0.75;
        DEADEND_PROB = 0.6;
        BOSS_RUSH = true;
        Floor95ShopPos = new BlockPos(-17, 191, 0);
        BackToLobbyDoor = new BlockPos(-28, 192, 15);
        BackToLastKnownLocationDoor = new BlockPos(-17, 192, -2);
        DontLetThisDoorOpen = null;
        BossRushTeleporterDoor = null;
        UNIQUE_SKILL_MAP = Map.ofEntries(Map.entry("OBSERVER", UniqueSkills.OBSERVER), Map.entry("REAPER", UniqueSkills.REAPER), Map.entry("SEER", UniqueSkills.SEER), Map.entry("FIGHTER", UniqueSkills.FIGHTER), Map.entry("SHADOW_STRIKER", UniqueSkills.SHADOW_STRIKER), Map.entry("SNIPER", UniqueSkills.SNIPER), Map.entry("SURVIVOR", UniqueSkills.SURVIVOR), Map.entry("TUNER", UniqueSkills.TUNER), Map.entry("GOURMAND", UniqueSkills.GOURMAND), Map.entry("ANTI_SKILL", UniqueSkills.ANTI_SKILL), Map.entry("CHOSEN_ONE", UniqueSkills.CHOSEN_ONE), Map.entry("COMMANDER", UniqueSkills.COMMANDER), Map.entry("COOK", UniqueSkills.COOK), Map.entry("ENGORGER", UniqueSkills.ENGORGER), Map.entry("GUARDIAN", UniqueSkills.GUARDIAN), Map.entry("MARTIAL_MASTER", UniqueSkills.MARTIAL_MASTER), Map.entry("MATHEMATICIAN", UniqueSkills.MATHEMATICIAN));
        EXTRA_SKILL_MAP = Map.of("ALL_SEEING_EYE", ExtraSkills.ALL_SEEING_EYE, "STRENGTHEN_BODY", ExtraSkills.STRENGTHEN_BODY, "STEEL_STRENGTH", ExtraSkills.STEEL_STRENGTH, "BLACK_FLAME", ExtraSkills.BLACK_FLAME, "ULTRA_INSTINCT", ExtraSkills.ULTRA_INSTINCT, "HEAVENLY_EYE", ExtraSkills.HEAVENLY_EYE, "MAGIC_JAMMING", ExtraSkills.MAGIC_JAMMING, "ULTRA_REGENERATION", ExtraSkills.ULTRASPEED_REGENERATION);
        UNIQUE_SKILL = new String[]{"OBSERVER", "REAPER", "SEER", "FIGHTER", "SHADOW_STRIKER", "SNIPER", "SURVIVOR", "TUNER", "GOURMAND", "ANTI_SKILL", "CHOSEN_ONE", "COMMANDER", "COOK", "ENGORGER", "GUARDIAN", "MARTIAL_MASTER", "MATHEMATICIAN"};
        EXTRA_SKILL = new String[]{"ALL_SEEING_EYE", "STRENGTHEN_BODY", "STEEL_STRENGTH", "BLACK_FLAME", "ULTRA_INSTINCT", "HEAVENLY_EYE", "MAGIC_JAMMING", "ULTRA_REGENERATION"};
    }
}

