/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network.worldgen.portal.info;

import io.github.Memoires.trbeyond.network.worldgen.portal.info.BaseStructureInfo;
import io.github.Memoires.trbeyond.network.worldgen.portal.info.DungeonStructureInfo;
import io.github.Memoires.trbeyond.network.worldgen.portal.info.InfoBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Mirror;
import org.jetbrains.annotations.NotNull;

public class CornerStructureInfo
extends BaseStructureInfo<CornerInfoBuilder> {
    private BlockPos sideOffset;

    protected CornerStructureInfo(@NotNull CornerInfoBuilder builder) {
        super(builder);
        this.sideOffset = builder.sideOffset;
    }

    @NotNull
    public static CornerInfoBuilder builder() {
        return new CornerInfoBuilder();
    }

    @Override
    public BlockPos calculatePlacementPos(@NotNull BlockPos target, Direction facing, Mirror mirror) {
        return super.calculatePlacementPos(target, facing, mirror);
    }

    @Override
    public List<DungeonStructureInfo.DungeonCursor> calculateNewCursors(@NotNull BlockPos target, @NotNull Direction facing) {
        BlockPos base = target.m_5484_(facing, this.getSize().m_123341_() - this.sideOffset.m_123341_());
        BlockPos cwPos = base.m_5484_(facing.m_122427_(), this.getSize().m_123343_() - this.sideOffset.m_123343_());
        Direction cwFacing = facing.m_122427_();
        BlockPos ccwPos = base.m_5484_(facing.m_122428_(), this.getSize().m_123343_() - this.sideOffset.m_123343_());
        Direction ccwFacing = facing.m_122428_();
        return List.of(new DungeonStructureInfo.DungeonCursor(cwPos, cwFacing), new DungeonStructureInfo.DungeonCursor(ccwPos, ccwFacing));
    }

    public static class CornerInfoBuilder
    extends InfoBuilder<CornerInfoBuilder> {
        private BlockPos sideOffset = new BlockPos(3, 0, 2);

        public CornerStructureInfo build() {
            return new CornerStructureInfo(this);
        }

        public CornerInfoBuilder setSideOffset(BlockPos sideOffset) {
            this.sideOffset = sideOffset;
            return this.getSelf();
        }

        @Override
        protected CornerInfoBuilder getSelf() {
            return this;
        }
    }
}

