/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.network.worldgen.portal.info;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public interface DungeonStructureInfo {
    public Direction getFacing();

    public String getAddress();

    public BlockPos getSize();

    public BlockPos getEntranceOffset();

    default public BlockPos calculatePlacementPos(BlockPos target, Direction facing) {
        return this.calculatePlacementPos(target, facing, Mirror.NONE);
    }

    default public BlockPos calculatePlacementPos(@NotNull BlockPos target, Direction facing, Mirror mirror) {
        Rotation rot = this.getRotationTo(facing);
        BlockPos movedEntrance = StructureTemplate.m_74593_((BlockPos)this.getEntranceOffset(), (Mirror)mirror, (Rotation)rot, (BlockPos)BlockPos.f_121853_);
        return target.m_121996_((Vec3i)movedEntrance);
    }

    public List<DungeonCursor> calculateNewCursors(BlockPos var1, Direction var2);

    public BlockPos calculateEntityPos(BlockPos var1, Direction var2);

    default public Rotation getRotationTo(@NotNull Direction target) {
        int diff = (this.getFacing().m_122416_() - target.m_122416_() + 4) % 4;
        return switch (diff) {
            case 0 -> Rotation.CLOCKWISE_180;
            case 1 -> Rotation.CLOCKWISE_90;
            case 2 -> Rotation.NONE;
            case 3 -> Rotation.COUNTERCLOCKWISE_90;
            default -> throw new IllegalStateException("Impossible rotation: " + diff);
        };
    }

    public record DungeonCursor(BlockPos pos, Direction facing) {
    }
}

