/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.procedures;

import io.github.Memoires.trbeyond.TRBeyond;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MezulAttackDamagingProcedure {
    private static final float BLOW_DAMAGE = 1000.0f;
    private static final float DASH_DAMAGE = 375.0f;
    private static final float THRUST_DAMAGE = 1000.0f;
    private static final float THRUST_FOLLOW_UP_DAMAGE = 1500.0f;
    private static final int ATTACK_RANGE = 6;
    private static final DamageSource PHYSICAL_DAMAGE = new DamageSource("Physical");

    public static void execute(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        List<Player> nearbyPlayers = MezulAttackDamagingProcedure.getNearbyPlayers(world, entity);
        if (nearbyPlayers.isEmpty() || !entity.getPersistentData().m_128471_("dmg")) {
            return;
        }
        Player target = MezulAttackDamagingProcedure.getNearestPlayer(world, entity);
        if (target == null) {
            return;
        }
        if (entity.getPersistentData().m_128471_("blow")) {
            MezulAttackDamagingProcedure.performBlowAttack(entity, (Entity)target);
        }
        if (entity.getPersistentData().m_128471_("dash")) {
            MezulAttackDamagingProcedure.performDashAttack(entity, (Entity)target);
        }
        if (entity.getPersistentData().m_128471_("thrust")) {
            MezulAttackDamagingProcedure.performThrustAttack(world, entity, (Entity)target);
        }
    }

    private static List<Player> getNearbyPlayers(LevelAccessor world, Entity entity) {
        return world.m_6443_(Player.class, AABB.m_165882_((Vec3)new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()), (double)6.0, (double)6.0, (double)6.0), e -> true);
    }

    private static Player getNearestPlayer(LevelAccessor world, Entity entity) {
        return world.m_6443_(Player.class, AABB.m_165882_((Vec3)new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()), (double)6.0, (double)6.0, (double)6.0), e -> true).stream().min(Comparator.comparingDouble(player -> player.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()))).orElse(null);
    }

    private static void knockbackTarget(Entity entity, Entity target) {
        target.m_20256_(new Vec3(entity.m_20154_().f_82479_, 0.2, entity.m_20154_().f_82481_));
    }

    private static void performBlowAttack(Entity entity, Entity target) {
        MezulAttackDamagingProcedure.knockbackTarget(entity, target);
        target.m_6469_(PHYSICAL_DAMAGE, 1000.0f);
    }

    private static void performDashAttack(Entity entity, Entity target) {
        MezulAttackDamagingProcedure.knockbackTarget(entity, target);
        target.m_6469_(PHYSICAL_DAMAGE, 375.0f);
    }

    private static void performThrustAttack(LevelAccessor world, Entity entity, Entity target) {
        target.m_6469_(PHYSICAL_DAMAGE, 1000.0f);
        TRBeyond.queueServerWork(3, () -> {
            List<Player> playersStillNearby = MezulAttackDamagingProcedure.getNearbyPlayers(world, entity);
            if (playersStillNearby.isEmpty()) {
                return;
            }
            Player nearestPlayer = MezulAttackDamagingProcedure.getNearestPlayer(world, entity);
            if (nearestPlayer == null) {
                return;
            }
            for (int i = 0; i < 3; ++i) {
                nearestPlayer.m_6469_(PHYSICAL_DAMAGE, 1500.0f);
            }
        });
    }
}

