/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.procedures;

import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.capability.entities.EliteMobProvider;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlocks;
import io.github.Memoires.trbeyond.util.BeyondDamageSources;
import io.github.Memoires.trbeyond.util.PrimedChestSpawnTracker;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnPlayerDeathProcedure {
    @SubscribeEvent
    public static void onPlayerKilled(LivingDeathEvent event) {
        boolean diedFromParalysis;
        boolean diedFromSuffocation;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Entity sourceEntity = event.getSource().m_7639_();
        Level level = player.f_19853_;
        BlockPos feetPos = player.m_20183_();
        BlockPos headPos = feetPos.m_7494_();
        Block feetBlock = level.m_8055_(feetPos).m_60734_();
        Block headBlock = level.m_8055_(headPos).m_60734_();
        System.out.println("[DEBUG DAMAGE SOURCE] " + String.valueOf(event.getSource()));
        System.out.println("[DEBUG SOURCE ENTITY] " + String.valueOf(sourceEntity));
        boolean bl = diedFromSuffocation = event.getSource() == TensuraDamageSources.SUFFOCATE;
        if (diedFromSuffocation && (feetBlock == BeyondBlocks.SEALING_AIR.get() || headBlock == BeyondBlocks.SEALING_AIR.get())) {
            OnPlayerDeathProcedure.awardAdvancement(player, "trbeyond", "lifes_not_fair");
        }
        boolean bl2 = diedFromParalysis = event.getSource() == BeyondDamageSources.PARALYSIS;
        if (diedFromParalysis && OnPlayerDeathProcedure.isAnyParalysisChestNearby(level, player.m_20183_(), 3)) {
            OnPlayerDeathProcedure.awardAdvancement(player, "trbeyond", "better_luck_next_time");
        }
        boolean diedFromExplosion = event.getSource().m_19372_();
        System.out.println("[DEBUG Explosion Check] Explosion=" + diedFromExplosion + " | NearChest=" + PrimedChestSpawnTracker.isPrimedChestNear((Entity)player, 20.0));
        if (diedFromExplosion && PrimedChestSpawnTracker.isPrimedChestNear((Entity)player, 20.0)) {
            OnPlayerDeathProcedure.awardAdvancement(player, "trbeyond", "a_scary_place");
        }
        if (sourceEntity == null) {
            return;
        }
        LazyOptional cap = sourceEntity.getCapability(EliteMobProvider.ELITE_CAPABILITY);
        cap.ifPresent(eliteData -> {
            if (eliteData.isElite()) {
                OnPlayerDeathProcedure.awardAdvancement(player, "trbeyond", "what_was_that");
            }
        });
    }

    private static void awardAdvancement(ServerPlayer player, String namespace, String path) {
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        ResourceLocation advId = new ResourceLocation(namespace, path);
        Advancement advancement = server.m_129889_().m_136041_(advId);
        if (advancement != null) {
            AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
            for (String criterion : progress.m_8219_()) {
                player.m_8960_().m_135988_(advancement, criterion);
            }
            System.out.println("[DEBUG] Advancement awarded: " + path);
        } else {
            System.out.println("[DEBUG] Advancement not found: " + path);
        }
    }

    private static boolean isAnyParalysisChestNearby(Level level, BlockPos center, int radius) {
        Block[] chestBlocks = new Block[]{(Block)BeyondBlocks.GOLD_PARALYSIS_CHEST.get(), (Block)BeyondBlocks.SILVER_PARALYSIS_CHEST.get(), (Block)BeyondBlocks.BRONZE_PARALYSIS_CHEST.get()};
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos checkPos = center.m_7918_(dx, dy, dz);
                    Block foundBlock = level.m_8055_(checkPos).m_60734_();
                    for (Block target : chestBlocks) {
                        if (foundBlock != target) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

