/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.procedures;

import io.github.Memoires.trbeyond.TRBeyond;
import io.github.Memoires.trbeyond.entity.custom.LivingArmorEntity;
import io.github.Memoires.trbeyond.entity.custom.MageEntity;
import io.github.Memoires.trbeyond.entity.custom.MilimSlimeScarletEntity;
import io.github.Memoires.trbeyond.entity.custom.SkullNightEntity;
import io.github.Memoires.trbeyond.registry.sounds.BeyondSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;

public class SlimeAttacksProcedure {
    public static void execute(LevelAccessor world, Entity target, Entity sourceentity) {
        if (target == null || sourceentity == null) {
            return;
        }
        if (!(sourceentity instanceof MilimSlimeScarletEntity)) {
            return;
        }
        MilimSlimeScarletEntity slime = (MilimSlimeScarletEntity)sourceentity;
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (!SlimeAttacksProcedure.isValidTarget(slime, livingTarget)) {
            return;
        }
        if (!"empty".equals(slime.animationprocedure)) {
            return;
        }
        int rnd = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)2);
        SlimeAttacksProcedure.performAttack(world, slime, livingTarget, rnd);
    }

    private static void performAttack(LevelAccessor world, MilimSlimeScarletEntity slime, LivingEntity target, int rnd) {
        if (slime.getPersistentData().m_128471_("dmg")) {
            return;
        }
        slime.getPersistentData().m_128379_("dmg", true);
        switch (rnd) {
            case 1: {
                slime.setAnimation("animation.model.dash");
                slime.f_19853_.m_6263_(null, slime.m_20185_(), slime.m_20186_(), slime.m_20189_(), (SoundEvent)BeyondSoundEvents.milim_slime_dash.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                TRBeyond.queueServerWork(5, () -> {
                    if ("animation.model.dash".equals(slime.animationprocedure) && target.m_6084_()) {
                        target.m_6469_((DamageSource)new EntityDamageSource("Physical", (Entity)slime), 1000.0f);
                    }
                    SlimeAttacksProcedure.resetAttack(slime, 10);
                });
                break;
            }
            case 2: {
                slime.setAnimation("animation.model.pop");
                TRBeyond.queueServerWork(5, () -> {
                    if ("animation.model.pop".equals(slime.animationprocedure) && target.m_6084_()) {
                        target.m_6469_((DamageSource)new EntityDamageSource("Physical", (Entity)slime), 1000.0f);
                    }
                    SlimeAttacksProcedure.resetAttack(slime, 20);
                });
            }
        }
    }

    private static void resetAttack(MilimSlimeScarletEntity slime, int delay) {
        TRBeyond.queueServerWork(delay, () -> {
            slime.getPersistentData().m_128379_("dmg", false);
            slime.setAnimation("empty");
        });
    }

    private static boolean isValidTarget(MilimSlimeScarletEntity slime, LivingEntity entity) {
        if (entity == slime) {
            return false;
        }
        if (entity instanceof MilimSlimeScarletEntity) {
            return false;
        }
        if (entity instanceof LivingArmorEntity) {
            return false;
        }
        if (entity instanceof SkullNightEntity) {
            return false;
        }
        return !(entity instanceof MageEntity);
    }
}

