/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.util;

import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.entity.DirewolfEntity;
import com.github.manasmods.tensura.entity.SlimeEntity;
import com.github.manasmods.tensura.entity.SupermassiveSlimeEntity;
import com.github.manasmods.tensura.entity.variant.DirewolfVariant;
import io.github.Memoires.trbeyond.config.FloorSpawnConfig;
import io.github.Memoires.trbeyond.config.ServerConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BeyondSpawnUtils {
    public static void spawnMobsAt(ServerLevel world, BlockPos pos, boolean hallwayEntity, boolean respawn, boolean treasure) {
        int floorCount = BeyondSpawnUtils.GetFloorFromBlockPos(pos);
        FloorSpawnConfig.SpawnParams type = BeyondSpawnUtils.ChooseEntity(floorCount, treasure, world.m_213780_());
        if (type == null) {
            return;
        }
        int amount = BeyondSpawnUtils.getRandomInRange(type.minCount(), type.maxCount());
        BeyondSpawnUtils.spawnMob(pos, hallwayEntity, floorCount, respawn, type.entityType(), amount, world, treasure);
    }

    public static void spawnMob(BlockPos pos, boolean hallwayEntity, int floorCount, boolean respawn, EntityType<?> type, int amount, ServerLevel world, boolean treasureRoom) {
        for (int i = 0; i < amount; ++i) {
            Entity entity = type.m_20615_((Level)world);
            if (entity == null) continue;
            if (entity instanceof SlimeEntity) {
                SlimeEntity slime = (SlimeEntity)entity;
                if (!(entity instanceof SupermassiveSlimeEntity)) {
                    int random_size = BeyondSpawnUtils.getRandomInRange(1, 4);
                    slime.setSize(random_size, true);
                }
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_21530_();
                if (entity instanceof NeutralMob) {
                    mob.f_21346_.m_148096_();
                    List goals = mob.f_21345_.m_148105_().stream().toList();
                    boolean hasAttackGoal = false;
                    for (WrappedGoal goal : goals) {
                        Goal goalType = goal.m_26015_();
                        if (!(goalType instanceof MeleeAttackGoal) && !(goalType instanceof RangedAttackGoal)) continue;
                        hasAttackGoal = true;
                    }
                    if (!hasAttackGoal) {
                        mob.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)mob, 2.0, true));
                    }
                    mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, Player.class, true));
                }
            }
            if (10 < floorCount && floorCount < 20 && entity instanceof DirewolfEntity) {
                DirewolfEntity direwolfEntity = (DirewolfEntity)entity;
                float rand = world.m_213780_().m_188501_();
                if ((double)rand < 0.1) {
                    direwolfEntity.setVariant(DirewolfVariant.MYSTIC_WIND_WOLF);
                } else if ((double)rand < 0.4) {
                    direwolfEntity.setVariant(DirewolfVariant.GREEN_FANG);
                }
            }
            entity.getPersistentData().m_128379_("hallwayEntity", hallwayEntity);
            entity.getPersistentData().m_128405_("floorCount", floorCount);
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_(entity);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            BeyondSpawnUtils.IncreaseEntityEPBasedOnFloor(livingEntity, floorCount);
        }
    }

    public static FloorSpawnConfig.SpawnParams ChooseEntity(int floor, boolean treasure, RandomSource random) {
        WeightedRandomList<WeightedEntry.Wrapper<FloorSpawnConfig.SpawnParams>> mobs = treasure ? ServerConfig.INSTANCE.floorSpawnConfig.getTreasureFloorRandomEntryList(floor) : ServerConfig.INSTANCE.floorSpawnConfig.getFloorRandomEntryList(floor);
        if (!mobs.m_146337_()) {
            return mobs.m_216829_(random).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
        }
        return new FloorSpawnConfig.SpawnParams(EntityType.f_20549_, 0, 1);
    }

    private static int getRandomInRange(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static int GetFloorFromBlockPos(BlockPos pos) {
        int y = pos.m_123342_();
        int floorMajorComponent = 0;
        int floorMinorComponent = 0;
        floorMajorComponent = Math.max(floorMajorComponent, 0);
        floorMajorComponent = Math.min(floorMajorComponent, 9);
        switch (floorMajorComponent) {
            case 0: {
                if (y > 190) {
                    return 95;
                }
                floorMinorComponent = (int)((143.0f - (float)y) / 16.0f);
                if (floorMinorComponent > 10) {
                    floorMinorComponent = (int)((93.0f - (float)y) / 12.0f);
                    floorMinorComponent = Math.max(floorMinorComponent, 11);
                }
                floorMinorComponent = Math.max(floorMinorComponent, 1);
                floorMinorComponent = Math.min(floorMinorComponent, 20);
            }
        }
        return floorMinorComponent + floorMajorComponent * 10;
    }

    public static void IncreaseEntityEPBasedOnFloor(LivingEntity livingEntity, int floorCount) {
        double newEP = TensuraEPCapability.getEP((LivingEntity)livingEntity) * (1.0 + (double)floorCount * 0.05);
        TensuraEPCapability.setLivingEP((LivingEntity)livingEntity, (double)newEP);
        TensuraEPCapability.healSpiritualHealth((LivingEntity)livingEntity, (double)Double.MAX_VALUE);
        TensuraEPCapability.setCurrentLivingEP((LivingEntity)livingEntity, (double)newEP);
    }
}

