/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.util;

import io.github.Memoires.trbeyond.network.BeyondNetwork;
import io.github.Memoires.trbeyond.network.ConfigSyncPacket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConfigHandler {
    private static final Map<UUID, Integer> pendingSyncs = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            pendingSyncs.put(player2.m_20148_(), 20);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.SERVER) {
            return;
        }
        Iterator<Map.Entry<UUID, Integer>> it = pendingSyncs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Integer> entry = it.next();
            UUID uuid = entry.getKey();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                ServerPlayer player = event.getServer().m_6846_().m_11259_(uuid);
                if (player != null) {
                    BeyondNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)ConfigSyncPacket.fromConfig());
                    System.out.println("[Server] Sent ConfigSyncPacket to " + player.m_7755_().getString());
                }
                it.remove();
                continue;
            }
            entry.setValue(ticksLeft);
        }
    }
}

