/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.util;

import io.github.Memoires.trbeyond.block.DungeonUnlockerBlock;
import io.github.Memoires.trbeyond.network.worldgen.portal.BeyondTeleporterUpdated;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DoorRefreshManager {
    private static final int REFRESH_INTERVAL = 240;
    private static final Map<ServerLevel, Map<BlockPos, DoorInfo>> doorsByWorld = new ConcurrentHashMap<ServerLevel, Map<BlockPos, DoorInfo>>();

    public static void registerDoor(ServerLevel world, BlockPos doorPos, Rotation rotation) {
        doorsByWorld.computeIfAbsent(world, lvl -> new ConcurrentHashMap()).put(doorPos, new DoorInfo(240, rotation));
    }

    public static void registerDoor(ServerLevel world, BlockPos doorPos) {
        DoorRefreshManager.registerDoor(world, doorPos, Rotation.NONE);
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = evt.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Map<BlockPos, DoorInfo> timers = doorsByWorld.get(serverLevel);
        if (timers == null || timers.isEmpty()) {
            return;
        }
        for (Map.Entry<BlockPos, DoorInfo> entry : timers.entrySet()) {
            BlockPos pos = entry.getKey();
            DoorInfo info = entry.getValue();
            --info.ticksRemaining;
            if (info.ticksRemaining > 0) continue;
            DoorRefreshManager.refreshDoor(serverLevel, pos, info.rotation, (Integer)serverLevel.m_8055_(pos).m_61143_((Property)DungeonUnlockerBlock.TYPE));
            info.ticksRemaining = 240;
        }
    }

    private static void refreshDoor(ServerLevel world, BlockPos pos, Rotation rotation, int Type2) {
        BlockState state = world.m_8055_(pos);
        if (!state.m_61138_((Property)DungeonUnlockerBlock.FLOOR)) {
            return;
        }
        int floor = (Integer)state.m_61143_((Property)DungeonUnlockerBlock.FLOOR);
        world.m_7471_(pos, false);
        world.m_7471_(pos.m_6630_(1), false);
        world.m_7471_(pos.m_6630_(2), false);
        BeyondTeleporterUpdated.placeDungeonUnlockerBlockWithRotation(world, pos, rotation, true, Type2, floor);
    }

    private static final class DoorInfo {
        int ticksRemaining;
        Rotation rotation;

        DoorInfo(int ticksRemaining, Rotation rotation) {
            this.ticksRemaining = ticksRemaining;
            this.rotation = rotation;
        }
    }
}

