/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DungeonWeightedList<T> {
    private final List<WeightedEntry<T>> entries = new ArrayList<WeightedEntry<T>>();
    private final WeightSummary totalWeight = new WeightSummary();
    private boolean dirty = false;

    private DungeonWeightedList() {
    }

    @NotNull
    public static <T> DungeonWeightedList<T> newList() {
        return new DungeonWeightedList<T>();
    }

    public DungeonWeightedList<T> add(Supplier<Float> weight, @NotNull List<T> values) {
        return this.add(weight, values, () -> true);
    }

    public DungeonWeightedList<T> add(Supplier<Float> weight, @NotNull List<T> values, WeightedEntryCondition condition) {
        this.entries.add(new WeightedEntry<T>(weight, values, condition));
        this.dirty = true;
        return this;
    }

    @Nullable
    public T getRandom(RandomSource random, boolean testValue) {
        if (this.entries.isEmpty()) {
            return null;
        }
        float chance = random.m_188501_();
        float acc = 0.0f;
        List<WeightedEntry> allowed = this.entries.stream().filter(entry -> entry.condition().test() == testValue).toList();
        for (WeightedEntry entry2 : allowed) {
            if (!(chance <= (acc += entry2.weight().get().floatValue()))) continue;
            return entry2.getRandom(random);
        }
        return null;
    }

    private void updateWeights() {
        if (!this.dirty) {
            return;
        }
        for (WeightedEntry<T> entry : this.entries) {
            if (entry.condition.test()) {
                this.totalWeight.increaseEnabledWeight(entry.weight().get().floatValue());
                continue;
            }
            this.totalWeight.increaseDisableWeight(entry.weight().get().floatValue());
        }
        this.dirty = false;
    }

    private void normalize() {
        this.updateWeights();
        if (this.entries.isEmpty()) {
            return;
        }
        for (int q = 0; q < this.entries.size(); ++q) {
            WeightedEntry<T> e = this.entries.get(q);
            float weight = this.totalWeight.getWeight(e.condition().test());
            float testWeight = weight > 0.0f ? e.weight().get().floatValue() / weight : 0.0f;
            this.entries.set(q, new WeightedEntry<T>(() -> Float.valueOf(testWeight), e.values(), e.condition()));
        }
        this.totalWeight.setDisableWeight(1.0f);
        this.totalWeight.setEnabledWeight(1.0f);
    }

    public DungeonWeightedList<T> end() {
        this.normalize();
        return this;
    }

    private static class WeightSummary {
        private float enabledWeight = 0.0f;
        private float disableWeight = 0.0f;

        private WeightSummary() {
        }

        public void increaseEnabledWeight(float value) {
            this.enabledWeight += value;
        }

        public void increaseDisableWeight(float value) {
            this.disableWeight += value;
        }

        public void setEnabledWeight(float enabledWeight) {
            this.enabledWeight = enabledWeight;
        }

        public void setDisableWeight(float disableWeight) {
            this.disableWeight = disableWeight;
        }

        public float getEnabledWeight() {
            return this.enabledWeight;
        }

        public float getDisableWeight() {
            return this.disableWeight;
        }

        public float getWeight(boolean value) {
            return value ? this.enabledWeight : this.disableWeight;
        }
    }

    @FunctionalInterface
    public static interface WeightedEntryCondition
    extends BooleanSupplier {
        @Override
        public boolean getAsBoolean();

        default public boolean test() {
            return this.getAsBoolean();
        }
    }

    public record WeightedEntry<T>(Supplier<Float> weight, List<T> values, WeightedEntryCondition condition) {
        @Nullable
        public T getRandom(@NotNull RandomSource randomSource) {
            return this.values.get(randomSource.m_188503_(this.values().size()));
        }
    }
}

