/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.util;

import io.github.Memoires.trbeyond.util.FunctionSpecifications;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class MatrixTraversal {
    private List<FunctionSpecifications> functionList = new ArrayList<FunctionSpecifications>();
    private double probabilityRight = 0.5;
    private double probabilityOne = 1.0;
    private double probabilityRoom = 0.15;
    private int numOfStructures;
    private boolean stairsPlaced;
    private double loopbackProb;
    private double deadendProb;
    private int rows;
    private int columns;
    private String[][] matrix;
    private int currentRow;
    private int currentCol;
    private String currentDirection;
    private Random random;
    private int hallwaysSinceTurn = 0;
    private static final int MIN_HALLWAYS_BEFORE_TURN = 4;
    private int hallwaysSinceRoom = 999;
    private int turnBalance = 0;
    private final double CORNER_PROB = 0.15;

    public MatrixTraversal(int numOfStructures, double loopbackProb, double deadendProb, int rows, int columns, String direction) {
        this.numOfStructures = numOfStructures;
        this.stairsPlaced = false;
        this.loopbackProb = loopbackProb;
        this.deadendProb = deadendProb;
        this.rows = numOfStructures + 50;
        this.columns = numOfStructures + 50;
        if (this.columns % 2 == 0) {
            ++this.columns;
        }
        if (this.rows < this.columns) {
            this.rows = this.columns;
        }
        this.matrix = new String[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.matrix[i][j] = " ";
            }
        }
        this.currentRow = this.rows / 2;
        this.currentCol = this.columns / 2;
        this.matrix[this.currentRow][this.currentCol] = "i";
        this.currentDirection = direction;
        this.random = new Random();
        this.moveUp("1");
        this.hallwaysSinceTurn = 1;
    }

    public MatrixTraversal(int numOfStructures, double loopbackProb, double deadendProb, String direction) {
        this(numOfStructures, loopbackProb, deadendProb, 100, 100, direction);
    }

    public void displayMatrix() {
        for (int i = 0; i < this.rows; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.columns; ++j) {
                sb.append(this.matrix[i][j]).append(" ");
            }
            System.out.println(sb.toString().trim());
        }
    }

    public String readUp() {
        int[] off = this.dirOffset(this.currentDirection);
        int r = this.currentRow + off[0];
        int c = this.currentCol + off[1];
        if (r < 0 || r >= this.rows || c < 0 || c >= this.columns) {
            return " ";
        }
        return this.matrix[r][c];
    }

    private int[] dirOffset(String dir) {
        int[] nArray;
        switch (dir) {
            case "north": {
                int[] nArray2 = new int[2];
                nArray2[0] = -1;
                nArray = nArray2;
                nArray2[1] = 0;
                break;
            }
            case "south": {
                int[] nArray3 = new int[2];
                nArray3[0] = 1;
                nArray = nArray3;
                nArray3[1] = 0;
                break;
            }
            case "west": {
                int[] nArray4 = new int[2];
                nArray4[0] = 0;
                nArray = nArray4;
                nArray4[1] = -1;
                break;
            }
            case "east": {
                int[] nArray5 = new int[2];
                nArray5[0] = 0;
                nArray = nArray5;
                nArray5[1] = 1;
                break;
            }
            default: {
                int[] nArray6 = new int[2];
                nArray6[0] = 0;
                nArray = nArray6;
                nArray6[1] = 0;
            }
        }
        return nArray;
    }

    private String rotateRight(String dir) {
        return switch (dir) {
            case "north" -> "east";
            case "east" -> "south";
            case "south" -> "west";
            case "west" -> "north";
            default -> dir;
        };
    }

    private String rotateLeft(String dir) {
        return switch (dir) {
            case "north" -> "west";
            case "west" -> "south";
            case "south" -> "east";
            case "east" -> "north";
            default -> dir;
        };
    }

    private boolean moveRelativeAndMark(String relative, String value) {
        String moveDir = this.currentDirection;
        switch (relative) {
            case "forward": {
                moveDir = this.currentDirection;
                break;
            }
            case "back": {
                moveDir = this.rotateRight(this.rotateRight(this.currentDirection));
                break;
            }
            case "left": {
                moveDir = this.rotateLeft(this.currentDirection);
                break;
            }
            case "right": {
                moveDir = this.rotateRight(this.currentDirection);
                break;
            }
        }
        int[] off = this.dirOffset(moveDir);
        int r = this.currentRow + off[0];
        int c = this.currentCol + off[1];
        if (r < 0 || r >= this.rows || c < 0 || c >= this.columns) {
            return false;
        }
        if (!this.matrix[r][c].equals(" ")) {
            return false;
        }
        this.currentRow = r;
        this.currentCol = c;
        this.matrix[r][c] = value;
        return true;
    }

    public void moveUp(String value) {
        this.moveRelativeAndMark("forward", value);
    }

    public void moveDown(String value) {
        this.moveRelativeAndMark("back", value);
    }

    public void moveLeft(String value) {
        this.moveRelativeAndMark("left", value);
    }

    public void moveRight(String value) {
        this.moveRelativeAndMark("right", value);
    }

    public void setDirection(String direction) {
        if (!(direction.equals("east") || direction.equals("west") || direction.equals("north") || direction.equals("south"))) {
            throw new IllegalArgumentException("Invalid direction. Choose from 'east', 'west', 'north', 'south'.");
        }
        this.currentDirection = direction;
    }

    public void placeDeadend() {
        this.moveUp("D");
        this.functionList.add(new FunctionSpecifications("deadend"));
    }

    public void placeCornerDeadend() {
        this.moveUp("2");
        this.changeRightPerspective();
        this.placeDeadend();
        if (!this.functionList.isEmpty()) {
            this.functionList.remove(this.functionList.size() - 1);
        }
        this.functionList.add(new FunctionSpecifications("corner_deadend"));
    }

    public void placeStairs() {
        if (!this.stairsPlaced) {
            this.moveUp("S");
            this.stairsPlaced = true;
            this.functionList.add(new FunctionSpecifications("stairs"));
            this.turnBalance = 0;
            this.hallwaysSinceRoom = 0;
            this.hallwaysSinceTurn = 0;
        } else {
            this.placeDeadend();
        }
    }

    public void placeOne() {
        this.moveUp("1");
        this.functionList.add(new FunctionSpecifications("hallway"));
    }

    public void placeRoom() {
        this.moveUp("R");
        this.placeOne();
        if (!this.functionList.isEmpty()) {
            this.functionList.remove(this.functionList.size() - 1);
        }
        this.functionList.add(new FunctionSpecifications("room"));
        this.placeOne();
        this.hallwaysSinceTurn = 0;
    }

    public void placeTwo() {
        this.moveUp("2");
        this.changeRightPerspective();
        this.placeOne();
        if (!this.functionList.isEmpty()) {
            this.functionList.remove(this.functionList.size() - 1);
        }
        this.functionList.add(new FunctionSpecifications("corner"));
        this.hallwaysSinceTurn = 0;
    }

    public int determineHallwayLength() {
        int maxLength = 6;
        int length = 0;
        int[] off = this.dirOffset(this.currentDirection);
        int r = this.currentRow;
        int c = this.currentCol;
        for (int i = 0; i < maxLength && (r += off[0]) >= 0 && r < this.rows && (c += off[1]) >= 0 && c < this.columns && this.matrix[r][c].equals(" "); ++i) {
            ++length;
        }
        return length;
    }

    public void placeThree(String successDirectionLeftOrRight, String notSuccessLoopbackDeadendStairs, int hallwayLength) {
        this.moveUp("3");
        String originalDirection = this.currentDirection;
        int originalRow = this.currentRow;
        int originalCol = this.currentCol;
        if (successDirectionLeftOrRight.equals("right")) {
            this.changeLeftPerspective();
            if (notSuccessLoopbackDeadendStairs.equals("loopback")) {
                this.moveUp("L");
                this.placeTwo();
                this.placeCornerDeadend();
                if (this.functionList.size() >= 2) {
                    this.functionList.remove(this.functionList.size() - 1);
                    this.functionList.remove(this.functionList.size() - 1);
                }
                this.functionList.add(new FunctionSpecifications("three_way", "right", "loopback", 1));
            } else if (notSuccessLoopbackDeadendStairs.equals("deadend")) {
                int hallwayLen = this.determineHallwayLength();
                String st = "D" + (hallwayLen - 1);
                this.moveUp(st);
                for (int i = 0; i < hallwayLen - 1; ++i) {
                    this.moveUp("1");
                }
                this.placeDeadend();
                if (!this.functionList.isEmpty()) {
                    this.functionList.remove(this.functionList.size() - 1);
                }
                this.functionList.add(new FunctionSpecifications("three_way", "right", "deadend", hallwayLen - 1));
            } else if (notSuccessLoopbackDeadendStairs.equals("stairs")) {
                int hallwayLen = this.determineHallwayLength();
                String st = "S" + (hallwayLen - 1);
                this.moveUp(st);
                for (int i = 0; i < hallwayLen - 1; ++i) {
                    this.moveUp("1");
                }
                this.placeStairs();
                if (!this.functionList.isEmpty()) {
                    this.functionList.remove(this.functionList.size() - 1);
                }
                this.functionList.add(new FunctionSpecifications("three_way", "right", "stairs", hallwayLen - 1));
            }
            this.currentRow = originalRow;
            this.currentCol = originalCol;
            this.currentDirection = originalDirection;
            this.changeRightPerspective();
            this.moveUp("1");
        } else {
            this.changeRightPerspective();
            if (notSuccessLoopbackDeadendStairs.equals("loopback")) {
                this.moveUp("L");
                this.placeTwo();
                this.placeCornerDeadend();
                if (this.functionList.size() >= 2) {
                    this.functionList.remove(this.functionList.size() - 1);
                    this.functionList.remove(this.functionList.size() - 1);
                }
                this.functionList.add(new FunctionSpecifications("three_way", "left", "loopback", 1));
            } else if (notSuccessLoopbackDeadendStairs.equals("deadend")) {
                int hallwayLen = this.determineHallwayLength();
                String st = "D" + (hallwayLen - 1);
                this.moveUp(st);
                for (int i = 0; i < hallwayLen - 1; ++i) {
                    this.moveUp("1");
                }
                this.placeDeadend();
                if (!this.functionList.isEmpty()) {
                    this.functionList.remove(this.functionList.size() - 1);
                }
                this.functionList.add(new FunctionSpecifications("three_way", "left", "deadend", hallwayLen - 1));
            } else if (notSuccessLoopbackDeadendStairs.equals("stairs")) {
                int hallwayLen = this.determineHallwayLength();
                String st = "S" + (hallwayLen - 1);
                this.moveUp(st);
                for (int i = 0; i < hallwayLen - 1; ++i) {
                    this.moveUp("1");
                }
                this.placeStairs();
                if (!this.functionList.isEmpty()) {
                    this.functionList.remove(this.functionList.size() - 1);
                }
                this.functionList.add(new FunctionSpecifications("three_way", "left", "stairs", hallwayLen - 1));
            }
            this.currentRow = originalRow;
            this.currentCol = originalCol;
            this.currentDirection = originalDirection;
            this.changeLeftPerspective();
            this.moveUp("1");
        }
    }

    public void changeRightPerspective() {
        switch (this.currentDirection) {
            case "east": {
                this.setDirection("south");
                break;
            }
            case "south": {
                this.setDirection("west");
                break;
            }
            case "west": {
                this.setDirection("north");
                break;
            }
            case "north": {
                this.setDirection("east");
                break;
            }
        }
    }

    public void changeLeftPerspective() {
        switch (this.currentDirection) {
            case "east": {
                this.setDirection("north");
                break;
            }
            case "north": {
                this.setDirection("west");
                break;
            }
            case "west": {
                this.setDirection("south");
                break;
            }
            case "south": {
                this.setDirection("east");
                break;
            }
        }
    }

    public void exampleMaze() {
        this.placeOne();
        this.placeOne();
        this.placeTwo();
        this.placeOne();
        this.placeOne();
        this.placeRoom();
        this.placeThree("left", "loopback", 1);
        this.placeOne();
        this.placeRoom();
        this.placeOne();
        this.placeRoom();
        this.placeThree("left", "loopback", 1);
        this.placeOne();
        this.placeOne();
        this.placeOne();
        this.placeThree("right", "loopback", 1);
        this.placeOne();
        this.placeRoom();
        this.placeThree("right", "deadend", 5);
        this.placeOne();
        this.placeOne();
        this.placeThree("left", "deadend", 2);
        this.placeOne();
        this.placeTwo();
        this.placeOne();
        this.placeOne();
        this.placeOne();
        this.placeOne();
        this.placeOne();
        this.placeTwo();
        this.placeOne();
        this.placeOne();
        this.placeStairs();
    }

    public void placeThreeAndTurn(String direction) {
        double r = this.random.nextDouble();
        double currentLoopbackProb = this.loopbackProb;
        double currentDeadendProb = this.deadendProb;
        if (r < currentLoopbackProb) {
            this.placeThree(direction, "loopback", 1);
        } else if (!this.stairsPlaced) {
            double p = this.random.nextDouble();
            if (p < currentDeadendProb) {
                this.placeThree(direction, "deadend", 1);
            } else {
                this.placeThree(direction, "stairs", 1);
            }
        } else {
            this.placeThree(direction, "deadend", 1);
        }
    }

    private boolean placeCornerSide(String side) {
        boolean rightTurn = "right".equals(side);
        int[] fOff = this.dirOffset(this.currentDirection);
        int fR = this.currentRow + fOff[0];
        int fC = this.currentCol + fOff[1];
        String turnDir = rightTurn ? this.rotateRight(this.currentDirection) : this.rotateLeft(this.currentDirection);
        int[] tOff = this.dirOffset(turnDir);
        int tR = fR + tOff[0];
        int tC = fC + tOff[1];
        if (fR < 0 || fR >= this.rows || fC < 0 || fC >= this.columns) {
            return false;
        }
        if (tR < 0 || tR >= this.rows || tC < 0 || tC >= this.columns) {
            return false;
        }
        if (!this.matrix[fR][fC].equals(" ")) {
            return false;
        }
        if (!this.matrix[tR][tC].equals(" ")) {
            return false;
        }
        this.matrix[fR][fC] = "2";
        this.matrix[tR][tC] = "1";
        this.currentRow = tR;
        this.currentCol = tC;
        this.currentDirection = turnDir;
        this.functionList.add(new FunctionSpecifications("corner", side, null, 1));
        this.turnBalance = rightTurn ? ++this.turnBalance : --this.turnBalance;
        this.hallwaysSinceRoom = 0;
        this.hallwaysSinceTurn = 0;
        return true;
    }

    public void generateMaze() {
        int target = Math.max(1, this.numOfStructures);
        ArrayDeque<PosState> stack = new ArrayDeque<PosState>();
        stack.push(new PosState(this.currentRow, this.currentCol, this.currentDirection));
        int placed = 0;
        while (!stack.isEmpty() && placed < target) {
            PosState state = (PosState)stack.peek();
            this.currentRow = state.r;
            this.currentCol = state.c;
            this.currentDirection = state.dir;
            ArrayList<String> moves = new ArrayList<String>();
            moves.add("forward");
            moves.add("left");
            moves.add("right");
            Collections.shuffle(moves, this.random);
            boolean moved = false;
            for (String rel : moves) {
                boolean ok;
                int prevR = this.currentRow;
                int prevC = this.currentCol;
                String prevDir = this.currentDirection;
                boolean attemptedCorner = false;
                boolean cornerSucceeded = false;
                if (this.hallwaysSinceTurn >= 4 && this.random.nextDouble() < 0.15) {
                    String chosenSide;
                    attemptedCorner = true;
                    String string = chosenSide = this.random.nextBoolean() ? "right" : "left";
                    if (this.turnBalance >= 2) {
                        chosenSide = "left";
                    } else if (this.turnBalance <= -2) {
                        chosenSide = "right";
                    }
                    cornerSucceeded = this.placeCornerSide(chosenSide);
                }
                if (cornerSucceeded) {
                    ++placed;
                    stack.push(new PosState(this.currentRow, this.currentCol, this.currentDirection));
                    moved = true;
                    break;
                }
                boolean placedRoom = false;
                if (this.hallwaysSinceRoom >= 2 && this.random.nextDouble() < this.probabilityRoom) {
                    int[] off = this.dirOffset(this.currentDirection);
                    int r1 = this.currentRow + off[0];
                    int c1 = this.currentCol + off[1];
                    if (r1 >= 0 && r1 < this.rows && c1 >= 0 && c1 < this.columns && this.matrix[r1][c1].equals(" ")) {
                        this.placeRoom();
                        placedRoom = true;
                        ++placed;
                        this.hallwaysSinceRoom = 0;
                        stack.push(new PosState(this.currentRow, this.currentCol, this.currentDirection));
                        moved = true;
                        break;
                    }
                }
                if (ok = this.moveRelativeAndMark(rel, "1")) {
                    this.functionList.add(new FunctionSpecifications("hallway"));
                    ++placed;
                    ++this.hallwaysSinceRoom;
                    ++this.hallwaysSinceTurn;
                    stack.push(new PosState(this.currentRow, this.currentCol, this.currentDirection));
                    moved = true;
                    break;
                }
                this.currentRow = prevR;
                this.currentCol = prevC;
                this.currentDirection = prevDir;
            }
            if (moved) continue;
            if (!this.matrix[this.currentRow][this.currentCol].equals("i") && !this.matrix[this.currentRow][this.currentCol].equals("D")) {
                this.matrix[this.currentRow][this.currentCol] = "D";
                this.functionList.add(new FunctionSpecifications("deadend"));
            }
            stack.pop();
        }
        if (!this.stairsPlaced) {
            this.placeStairs();
        }
    }

    public List<FunctionSpecifications> readFunctions() {
        for (FunctionSpecifications func : this.functionList) {
            System.out.println(func.toString());
        }
        return this.functionList;
    }

    public List<FunctionSpecifications> getFunctions() {
        return this.functionList;
    }

    private static final class PosState {
        final int r;
        final int c;
        final String dir;

        PosState(int r, int c, String dir) {
            this.r = r;
            this.c = c;
            this.dir = dir;
        }
    }
}

