/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.util;

import io.github.Memoires.trbeyond.block.DungeonChestBlock;
import io.github.Memoires.trbeyond.block.ShrineBlock;
import io.github.Memoires.trbeyond.capability.player.BeyondPlayerCapability;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.util.BeyondSpawnUtils;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RecurringEntitySpawner {
    private static final int TICKS_BETWEEN_SPAWNS = 100;
    private static final int DESPAWN_CHECK_TICKS = 200;
    private static final int DESPAWN_DISTANCE = 60;
    private static final int SPAWNS_NEAR_PLAYER_MAX = 30;
    private static final int SPAWN_CHECK_DISTANCE = 50;
    private static final int MIN_SPAWN_DISTANCE = 15;
    private static final int MAX_SPAWN_DISTANCE = 40;
    private static final int MAX_SPAWN_ATTEMPTS = 40;
    private static final Map<Integer, Integer> occupiedFloors = new HashMap<Integer, Integer>(100);
    private static ServerLevel serverWorld;
    private static final List<randomSpawnInfo> playerInstances;
    private static final Set<Integer> PROHIBITED_SPAWN_FLOORS;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        serverWorld = event.getServer().m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY);
        if (serverWorld != null) {
            if (serverWorld.m_46467_() % 200L == 0L) {
                List<Entity> entities = StreamSupport.stream(serverWorld.m_142646_().m_142273_().spliterator(), false).toList();
                entities.forEach(entity -> {
                    int sourceFloor;
                    int n = sourceFloor = entity.getPersistentData().m_128441_("floorCount") ? entity.getPersistentData().m_128451_("floorCount") : -1;
                    if (!(entity == null || entity.getPersistentData().m_128441_("respawn") && entity.getPersistentData().m_128471_("respawn") || !entity.getPersistentData().m_128441_("hallwayEntity") || !entity.getPersistentData().m_128471_("hallwayEntity") || serverWorld.m_45930_(entity, 60.0) != null && (occupiedFloors.containsKey(sourceFloor) || occupiedFloors.containsKey(sourceFloor - 1)))) {
                        entity.m_146870_();
                    }
                });
            }
            if (serverWorld.m_46467_() % 100L == 0L) {
                int spawnRate = BeyondGamerules.getInt((Level)serverWorld, BeyondGamerules.AMBIENT_MOB_SPAWN_RATE);
                if (Math.random() >= (double)spawnRate / 100.0) {
                    return;
                }
                playerInstances.clear();
                occupiedFloors.clear();
                serverWorld.m_8795_(serverPlayer -> serverPlayer.f_19853_.m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)).forEach(player -> {
                    BlockPos playerPos = player.m_20097_();
                    int currentFloor = BeyondSpawnUtils.GetFloorFromBlockPos(playerPos);
                    if (!PROHIBITED_SPAWN_FLOORS.contains(currentFloor) && player.f_8941_.m_9290_() != GameType.SPECTATOR) {
                        if (occupiedFloors.containsKey(currentFloor)) {
                            occupiedFloors.put(currentFloor, occupiedFloors.get(currentFloor) + 1);
                        } else {
                            occupiedFloors.put(currentFloor, 1);
                        }
                        boolean inShrineChallenge = BeyondPlayerCapability.getFrom((Player)player).map(cap -> {
                            if (cap.getChallengeType() == null) {
                                return false;
                            }
                            return cap.getChallengeType().getCategory().equals("shrine");
                        }).orElse(false);
                        if (inShrineChallenge) {
                            return;
                        }
                        int nearbySpawns = player.m_9236_().m_45976_(LivingEntity.class, new AABB(playerPos.m_175288_(RecurringEntitySpawner.getFloorHeightFromFloor(BeyondSpawnUtils.GetFloorFromBlockPos(playerPos)) - 2)).m_82377_(50.0, 6.0, 50.0)).stream().filter(LivingEntity2 -> LivingEntity2.getPersistentData().m_128441_("hallwayEntity")).toList().size();
                        playerInstances.add(new randomSpawnInfo((Player)player, nearbySpawns, BeyondSpawnUtils.GetFloorFromBlockPos(playerPos)));
                    }
                });
                for (randomSpawnInfo playerInstance : playerInstances) {
                    if (playerInstance.nearbySpawns > 30) continue;
                    BlockPos playerPos = playerInstance.player().m_20097_();
                    for (int i = 0; i < 2; ++i) {
                        int floorCount;
                        BlockPos spawnPos = RecurringEntitySpawner.getRandomSpawnDestination(playerPos, (Level)serverWorld);
                        if (spawnPos == null || (floorCount = BeyondSpawnUtils.GetFloorFromBlockPos(playerPos)) == 1 || floorCount % 10 == 0 || floorCount == 95) continue;
                        boolean treasureRoom = false;
                        for (int dx = -5; dx <= 5; ++dx) {
                            for (int dz = -5; dz <= 5; ++dz) {
                                BlockPos checkPos = spawnPos.m_7918_(dx, 0, dz);
                                Block block1 = serverWorld.m_8055_(checkPos).m_60734_();
                                Block block2 = serverWorld.m_8055_(checkPos.m_7918_(0, 1, 0)).m_60734_();
                                if (!(block1 instanceof ShrineBlock) && !(block1 instanceof DungeonChestBlock) && !(block2 instanceof ShrineBlock) && !(block2 instanceof DungeonChestBlock)) continue;
                                treasureRoom = true;
                            }
                        }
                        boolean hallwayEnt = true;
                        boolean respawn = false;
                        BeyondSpawnUtils.spawnMobsAt(serverWorld, spawnPos, hallwayEnt, respawn, treasureRoom);
                    }
                }
            }
        }
    }

    @Nullable
    private static BlockPos getRandomSpawnDestination(BlockPos sourcePos, Level level) {
        int spawnFloor = BeyondSpawnUtils.GetFloorFromBlockPos(sourcePos);
        if ((double)Mth.m_216267_((RandomSource)level.m_213780_(), (float)0.0f, (float)1.0f) < 0.3) {
            ++spawnFloor;
        }
        int spawnHeight = RecurringEntitySpawner.getFloorHeightFromFloor(spawnFloor);
        BlockPos spawnPos = sourcePos.m_175288_(spawnHeight);
        RandomSource random = level.m_213780_();
        for (int i = 0; i < 40; ++i) {
            int dz;
            float randomDirection = random.m_188501_() * (float)Math.PI * 2.0f;
            int randomDistance = random.m_216332_(15, 40);
            int dx = (int)(Mth.m_14089_((float)randomDirection) * (float)randomDistance);
            BlockPos attemptPos = spawnPos.m_7918_(dx, 0, dz = (int)(Mth.m_14031_((float)randomDirection) * (float)randomDistance));
            if (level.m_8055_(attemptPos).m_60795_() || !level.m_8055_(attemptPos.m_7918_(0, 1, 0)).m_60795_()) continue;
            dx = 0;
            dz = 0;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offsetPos = attemptPos.m_7918_(dx, 1, dz);
                    if (!level.m_8055_(offsetPos).m_60828_((BlockGetter)level, offsetPos)) continue;
                    dx = dx == 0 ? x * -1 : dx;
                    dz = dz == 0 ? z * -1 : dz;
                }
            }
            return attemptPos.m_7918_(dx, 1, dz);
        }
        return null;
    }

    private static int getFloorHeightFromFloor(int floorNumber) {
        if (floorNumber > 1 && floorNumber < 10) {
            return 131 - floorNumber * 16;
        }
        if (floorNumber < 20) {
            return 87 - floorNumber * 12;
        }
        return -1;
    }

    private static int getRandomInRange(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    static {
        playerInstances = new ArrayList<randomSpawnInfo>();
        PROHIBITED_SPAWN_FLOORS = Set.of(Integer.valueOf(1), Integer.valueOf(95));
    }

    private record randomSpawnInfo(Player player, int nearbySpawns, int floor) {
    }
}

