/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.util;

import io.github.Memoires.trbeyond.commands.ClearDungeonCommand;
import io.github.Memoires.trbeyond.entity.misc.MimicChestEntity;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.network.worldgen.portal.BeyondTeleporterUpdated;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import io.github.Memoires.trbeyond.util.TaskScheduler;
import io.github.Memoires.trbeyond.world.BeyondGamerules;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class RespawnEventHandler {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        boolean isBoss;
        ServerLevel serverWorld;
        LivingEntity entity;
        block7: {
            block6: {
                entity = event.getEntity();
                Level level = entity.f_19853_;
                if (!(level instanceof ServerLevel)) break block6;
                serverWorld = (ServerLevel)level;
                if (event.getEntity().f_19853_.m_46472_() == BeyondDungeon.DUNGEON_LEVEL_KEY && !event.getSource().equals(DamageSource.f_19317_)) break block7;
            }
            return;
        }
        int x = entity.getPersistentData().m_128451_("initialPosX");
        int y = entity.getPersistentData().m_128451_("initialPosY");
        int z = entity.getPersistentData().m_128451_("initialPosZ");
        BlockPos deathPos = new BlockPos(x, y, z);
        EntityType entityType = entity.m_6095_();
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
        List nearbyEntities = serverWorld.m_45976_(LivingEntity.class, new AABB(deathPos).m_82400_(10.0));
        if (nearbyEntities.size() >= 10) {
            return;
        }
        Player player = RespawnEventHandler.getPlayer(event);
        int timer = 120;
        if (!entity.getPersistentData().m_128471_("hallwayEntity")) {
            timer = 1200;
        }
        if (isBoss = entity.getPersistentData().m_128471_("isBoss")) {
            timer = 36000;
        }
        TaskScheduler.scheduleTask(new TaskScheduler.ScheduledTask(timer, () -> {
            boolean hallwayEnt = entity.getPersistentData().m_128471_("hallwayEntity");
            boolean respawn = entity.getPersistentData().m_128471_("respawn");
            if (!respawn || ClearDungeonCommand.dungeonCleared) {
                return;
            }
            if (hallwayEnt) {
                int spawnRate = BeyondGamerules.getInt((Level)serverWorld, BeyondGamerules.AMBIENT_MOB_SPAWN_RATE);
                if (Math.random() >= (double)spawnRate / 100.0) {
                    return;
                }
                int floorCount = entity.getPersistentData().m_128451_("floorCount");
                if (player != null) {
                    floorCount = (player.getPersistentData().m_128451_("floor") - 1) * 2;
                }
                boolean treasureRoom = entity.getPersistentData().m_128471_("treasureRoom");
                int entityInt = floorCount < 7 ? (treasureRoom ? RespawnEventHandler.getRandomInRange(5, 9) : RespawnEventHandler.getRandomInRange(1, 4)) : (treasureRoom ? RespawnEventHandler.getRandomInRange(11, 12) : RespawnEventHandler.getRandomInRange(5, 10));
                floorCount = entity.getPersistentData().m_128451_("floorCount");
                if (isBoss) {
                    if (entityType.equals(BeyondEntities.BOSS_BLACK_SPIDER.get())) {
                        BeyondTeleporterUpdated.spawnBlackSpiderAt(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                    } else if (entityType.equals(BeyondEntities.MEZUL.get())) {
                        BeyondTeleporterUpdated.spawnGozul(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                    } else if (entityType.equals(BeyondEntities.GOZUL.get())) {
                        BeyondTeleporterUpdated.spawnMezul(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                    } else if (entityType.equals(BeyondEntities.EVIL_CENTIPEDE_BOSS.get())) {
                        BeyondTeleporterUpdated.spawnEvilCentipede(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                    } else if (entityType.equals(BeyondEntities.TEMPEST_SERPENT_BOSS.get())) {
                        BeyondTeleporterUpdated.spawnTempestSerpant(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                    } else if (entityType.equals(BeyondEntities.OGRE_LORD.get())) {
                        BeyondTeleporterUpdated.spawnOgreLord(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                    }
                } else if (entityInt == 1) {
                    BeyondTeleporterUpdated.spawnBulldeerAt(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                } else if (entityInt == 2) {
                    BeyondTeleporterUpdated.spawnOneEyedOwlAt(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                } else if (entityInt == 3) {
                    BeyondTeleporterUpdated.spawnDragonPeacockAt(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                } else if (entityInt == 4) {
                    BeyondTeleporterUpdated.spawnMultipleSmallSlimes(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                } else if (entityInt == 5) {
                    BeyondTeleporterUpdated.spawnBarghastAt(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                } else if (entityInt == 6) {
                    BeyondTeleporterUpdated.spawnHornedRabbitsAt(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                } else if (entityInt == 7) {
                    BeyondTeleporterUpdated.spawnHoundDogAt(serverWorld, deathPos, hallwayEnt, floorCount, respawn);
                } else if (entityInt == 8) {
                    BeyondTeleporterUpdated.spawnHoverLizardAt(serverWorld, deathPos, hallwayEnt, floorCount, false);
                } else if (entityInt == 9) {
                    int randomCount = RespawnEventHandler.getRandomInRange(3, 4);
                    for (int i = 0; i < randomCount; ++i) {
                        BeyondTeleporterUpdated.spawnLeechLizardAt(serverWorld, deathPos, hallwayEnt, floorCount, false);
                    }
                } else if (entityInt == 10) {
                    BeyondTeleporterUpdated.spawnDireworlfAt(serverWorld, deathPos, hallwayEnt, floorCount, true);
                } else if (entityInt == 11) {
                    int randomCount = RespawnEventHandler.getRandomInRange(3, 4);
                    for (int i = 0; i < randomCount; ++i) {
                        BeyondTeleporterUpdated.spawnGiantBatAt(serverWorld, deathPos, hallwayEnt, floorCount, true);
                    }
                } else if (entityInt == 12) {
                    int randomCount = RespawnEventHandler.getRandomInRange(1, 2);
                    for (int i = 0; i < randomCount; ++i) {
                        BeyondTeleporterUpdated.spawnGiantAntAt(serverWorld, deathPos, hallwayEnt, floorCount, true);
                    }
                }
            }
            if (entityType.equals(EntityType.f_20526_)) {
                BeyondTeleporterUpdated.spawnSmallSlimeAt(serverWorld, deathPos, 0.0, 0.0, false, 0, true);
            } else if (id != null && id.m_135815_().equals("bulldeer")) {
                BeyondTeleporterUpdated.spawnBulldeerAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("one_eyed_owl")) {
                BeyondTeleporterUpdated.spawnOneEyedOwlAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("dragon_peacock")) {
                BeyondTeleporterUpdated.spawnDragonPeacockAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("barghest")) {
                BeyondTeleporterUpdated.spawnBarghastAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("horned_rabbit")) {
                BeyondTeleporterUpdated.spawnHornedRabbitsAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("hound_dog")) {
                BeyondTeleporterUpdated.spawnHoundDogAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("hover_lizard")) {
                BeyondTeleporterUpdated.spawnHoverLizardAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("leech_lizard")) {
                BeyondTeleporterUpdated.spawnLeechLizardAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("direwolf")) {
                BeyondTeleporterUpdated.spawnDireworlfAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("giant_bat")) {
                BeyondTeleporterUpdated.spawnGiantBatAt(serverWorld, deathPos, false, 0, true);
            } else if (id != null && id.m_135815_().equals("giant_ant")) {
                BeyondTeleporterUpdated.spawnGiantAntAt(serverWorld, deathPos, false, 0, true);
            } else if (entityType.equals(BeyondEntities.GOLD_MIMIC_CHEST.get())) {
                RespawnEventHandler.spawnMimic(serverWorld, deathPos, true, true);
            } else if (entityType.equals(BeyondEntities.SILVER_MIMIC_CHEST.get())) {
                RespawnEventHandler.spawnMimic(serverWorld, deathPos, true, false);
            }
        }));
    }

    @Nullable
    private static Player getPlayer(LivingDeathEvent event) {
        Player p;
        Entity killer = event.getSource().m_7639_();
        Player player = killer instanceof Player ? (p = (Player)killer) : null;
        return player;
    }

    private static int getRandomInRange(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static void spawnMimic(ServerLevel world, BlockPos pos, boolean respawn, boolean gold) {
        MimicChestEntity entity = gold ? (MimicChestEntity)((EntityType)BeyondEntities.GOLD_MIMIC_CHEST.get()).m_20615_((Level)world) : (MimicChestEntity)((EntityType)BeyondEntities.SILVER_MIMIC_CHEST.get()).m_20615_((Level)world);
        if (entity != null) {
            entity.getPersistentData().m_128379_("respawn", respawn);
            entity.getPersistentData().m_128405_("initialPosX", pos.m_123341_());
            entity.getPersistentData().m_128405_("initialPosY", pos.m_123342_());
            entity.getPersistentData().m_128405_("initialPosZ", pos.m_123343_());
            entity.m_21530_();
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
        }
    }

    public static void spawnBoss(ServerLevel world, LivingEntity entity) {
        EntityType entityType = entity.m_6095_();
        if (entityType.equals(BeyondEntities.GOZUL.get())) {
            entityType = (EntityType)BeyondEntities.MEZUL.get();
        } else if (entityType.equals(BeyondEntities.MEZUL.get())) {
            entityType = (EntityType)BeyondEntities.GOZUL.get();
        }
        BlockPos pos = entity.m_20183_().m_7949_();
        Entity newEntity = entityType.m_20615_((Level)world);
        if (newEntity != null) {
            newEntity.getPersistentData().m_128379_("isBoss", true);
            if (newEntity instanceof Mob) {
                Mob mob = (Mob)newEntity;
                mob.m_21530_();
                mob.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                world.m_7967_((Entity)mob);
            }
        }
    }
}

