/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.util;

import java.util.PriorityQueue;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class TaskScheduler {
    private static final PriorityQueue<ScheduledTask> TASK_QUEUE = new PriorityQueue();
    private static long CurrentTick = -1L;

    public static void scheduleTask(ScheduledTask task) {
        TASK_QUEUE.add(task);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CurrentTick = CurrentTick > 0L ? ++CurrentTick : (long)event.getServer().m_129921_();
            while (!TASK_QUEUE.isEmpty() && TaskScheduler.TASK_QUEUE.peek().runTicks <= CurrentTick) {
                ScheduledTask task = TASK_QUEUE.poll();
                task.run();
            }
        }
    }

    public static void scheduleRepeatingTask(final int ticks, final RepeatingTask task) {
        TaskScheduler.scheduleTask(new ScheduledTask(ticks, new Runnable(){

            @Override
            public void run() {
                task.run();
                TaskScheduler.scheduleRepeatingTask(ticks, task);
            }
        }));
    }

    public static class ScheduledTask
    implements Comparable<ScheduledTask> {
        public long runTicks;
        public Runnable task;

        public ScheduledTask(int ticks, Runnable task) {
            this.runTicks = (long)ticks + CurrentTick;
            this.task = task;
        }

        @Override
        public int compareTo(@NotNull ScheduledTask o) {
            return Long.compare(this.runTicks, o.runTicks);
        }

        public void run() {
            this.task.run();
        }
    }

    public static interface RepeatingTask
    extends Runnable {
    }
}

