/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TimerUtils {
    private static final Map<String, Timer> timers = new HashMap<String, Timer>();

    public static Timer getOrCreateTimer(String timerName) {
        return timers.computeIfAbsent(timerName, k -> new Timer(timerName));
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (Timer timer : timers.values()) {
                timer.update();
            }
        }
    }

    public static class Timer {
        private int ticksElapsed = 0;
        private int intervalTicks = 60;
        public boolean active = false;
        private Runnable action;

        public Timer(String name) {
        }

        public void start(int intervalTicks, Runnable action) {
            this.intervalTicks = intervalTicks;
            this.ticksElapsed = 0;
            this.active = true;
            this.action = action;
        }

        public void reset() {
            this.ticksElapsed = 0;
        }

        public void stop() {
            this.active = false;
        }

        public void update() {
            if (this.active) {
                ++this.ticksElapsed;
                if (this.ticksElapsed >= this.intervalTicks) {
                    if (this.action != null) {
                        this.action.run();
                    }
                    this.reset();
                }
            }
        }

        public int getTicks() {
            return this.ticksElapsed;
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

