/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.world;

import java.lang.reflect.Method;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class BeyondGamerules {
    public static GameRules.Key<GameRules.BooleanValue> NIGHTMARE_MODE;
    public static GameRules.Key<GameRules.IntegerValue> AMBIENT_MOB_SPAWN_RATE;
    public static GameRules.Key<GameRules.BooleanValue> DISABLE_CHALLENGES;
    public static GameRules.Key<GameRules.BooleanValue> DISABLE_SHRINES;
    public static GameRules.Key<GameRules.BooleanValue> UNIQUE_OVERWORLD;
    public static GameRules.Key<GameRules.BooleanValue> UNIQUE_PARTICLES;
    public static GameRules.Key<GameRules.IntegerValue> UNIQUE_MONSTER_CHANCE;
    public static GameRules.Key<GameRules.IntegerValue> LOOT_EXPLOSION_CHANCE;
    public static GameRules.Key<GameRules.BooleanValue> MOBS_SPAWN_WITH_DUNGEON;
    public static GameRules.Key<GameRules.IntegerValue> DUNGEON_REENTRY_COOLDOWN;
    public static GameRules.Key<GameRules.IntegerValue> DUNGEON_FLOOR_SIZE;
    public static GameRules.Key<GameRules.BooleanValue> BOSS_EP_ONE_TIME_DROP;

    public static void registryGameRules() {
        NIGHTMARE_MODE = GameRules.m_46189_((String)"nightmareMode", (GameRules.Category)GameRules.Category.MISC, BeyondGamerules.createBooleanType(false));
        UNIQUE_MONSTER_CHANCE = GameRules.m_46189_((String)"uniqueMonsterChance", (GameRules.Category)GameRules.Category.SPAWNING, BeyondGamerules.createIntegerType(1));
        UNIQUE_OVERWORLD = GameRules.m_46189_((String)"UniqueMonsterOverworld", (GameRules.Category)GameRules.Category.SPAWNING, BeyondGamerules.createBooleanType(false));
        UNIQUE_PARTICLES = GameRules.m_46189_((String)"UniqueMonsterParticles", (GameRules.Category)GameRules.Category.MOBS, BeyondGamerules.createBooleanType(true));
        LOOT_EXPLOSION_CHANCE = GameRules.m_46189_((String)"lootExplosionChance", (GameRules.Category)GameRules.Category.DROPS, BeyondGamerules.createIntegerType(1));
        AMBIENT_MOB_SPAWN_RATE = GameRules.m_46189_((String)"ambientMobSpawnRate", (GameRules.Category)GameRules.Category.SPAWNING, BeyondGamerules.createIntegerType(100));
        DISABLE_CHALLENGES = GameRules.m_46189_((String)"disablechallenges", (GameRules.Category)GameRules.Category.PLAYER, BeyondGamerules.createBooleanType(false));
        DISABLE_SHRINES = GameRules.m_46189_((String)"disableShrines", (GameRules.Category)GameRules.Category.PLAYER, BeyondGamerules.createBooleanType(false));
        MOBS_SPAWN_WITH_DUNGEON = GameRules.m_46189_((String)"mobsSpawnWithDungeon", (GameRules.Category)GameRules.Category.SPAWNING, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
        DUNGEON_FLOOR_SIZE = GameRules.m_46189_((String)"dungeonFloorSize", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)100));
        BOSS_EP_ONE_TIME_DROP = GameRules.m_46189_((String)"bossEPOneTimeDrop", (GameRules.Category)GameRules.Category.DROPS, BeyondGamerules.createBooleanType(false));
    }

    public static boolean getBoolean(Level level, GameRules.Key<GameRules.BooleanValue> ruleKey) {
        GameRules.BooleanValue boolVal;
        if (level == null) {
            return false;
        }
        GameRules.Value value = level.m_46469_().m_46170_(ruleKey);
        return value instanceof GameRules.BooleanValue && (boolVal = (GameRules.BooleanValue)value).m_46223_();
    }

    public static int getInt(Level level, GameRules.Key<GameRules.IntegerValue> ruleKey) {
        if (level == null) {
            return 0;
        }
        GameRules.Value value = level.m_46469_().m_46170_(ruleKey);
        return ((GameRules.IntegerValue)value).m_46288_();
    }

    private static GameRules.Type<GameRules.BooleanValue> createBooleanType(boolean defaultValue) {
        String[] methodNames;
        for (String name : methodNames = new String[]{"m_46250_", "create"}) {
            try {
                Method createMethod = GameRules.BooleanValue.class.getDeclaredMethod(name, Boolean.TYPE);
                createMethod.setAccessible(true);
                return (GameRules.Type)createMethod.invoke(null, defaultValue);
            }
            catch (NoSuchMethodException createMethod) {
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create boolean GameRule type via method '" + name + "'", e);
            }
        }
        throw new RuntimeException("Failed to create boolean GameRule type: no suitable create method found");
    }

    private static GameRules.Type<GameRules.IntegerValue> createIntegerType(int defaultValue) {
        String[] methodNames;
        for (String name : methodNames = new String[]{"m_46312_", "m_46251_", "create"}) {
            try {
                Method createMethod = GameRules.IntegerValue.class.getDeclaredMethod(name, Integer.TYPE);
                createMethod.setAccessible(true);
                return (GameRules.Type)createMethod.invoke(null, defaultValue);
            }
            catch (NoSuchMethodException createMethod) {
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create integer GameRule type via method '" + name + "'", e);
            }
        }
        throw new RuntimeException("Failed to create integer GameRule type: no suitable create method found");
    }
}

