/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.client.gui;

import com.goodbird.player2npc.client.gui.CharacterCardWidget;
import com.goodbird.player2npc.client.gui.CharacterDetailScreen;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class CharacterSelectionScreen
extends Screen {
    private Character[] characters = null;
    private boolean isLoading = true;

    public CharacterSelectionScreen() {
        super(Component.nullToEmpty((String)"Select a Character"));
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        this.isLoading = true;
        CompletableFuture.supplyAsync(() -> CharacterUtils.requestCharacters((Player)Minecraft.getInstance().player, (String)"player2-ai-npc-minecraft")).thenAcceptAsync(result -> {
            this.characters = result;
            this.isLoading = false;
            this.minecraft.execute(this::createCharacterCards);
        }, (Executor)this.minecraft);
    }

    private void createCharacterCards() {
        if (this.characters != null && this.characters.length != 0) {
            int cardWidth = 100;
            int cardHeight = 130;
            int padding = 30;
            int cardsPerRow = Math.max(1, (this.width - padding) / (cardWidth + padding));
            int totalWidth = cardsPerRow * (cardWidth + padding) - padding;
            int startX = this.width / 2 - totalWidth / 2;
            int startY = 70;
            int currentX = startX;
            int currentY = startY;
            for (Character character : this.characters) {
                this.addRenderableWidget((GuiEventListener)new CharacterCardWidget(currentX, currentY, cardWidth, cardHeight, character, this::onCharacterClicked));
                if ((currentX += cardWidth + padding) + cardWidth <= startX + totalWidth) continue;
                currentX = startX;
                currentY += cardHeight + padding;
            }
        }
    }

    private void onCharacterClicked(Character character) {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new CharacterDetailScreen(this, character));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, "Select a Character", this.width / 2, 20, 0xFFFFFF);
        if (this.isLoading) {
            graphics.drawCenteredString(this.font, "Loading...", this.width / 2, this.height / 2, 0xAAAAAA);
        }
        super.render(graphics, mouseX, mouseY, delta);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

