/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.companion;

import com.goodbird.player2npc.companion.AutomatoneEntity;
import com.goodbird.player2npc.mixins.IEntityPersistentData;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompanionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerPlayer _player;
    private final Map<String, UUID> _companionMap = new ConcurrentHashMap<String, UUID>();
    private final Map<String, CompoundTag> _despawnedCompanionData = new ConcurrentHashMap<String, CompoundTag>();
    private List<Character> _assignedCharacters = new ArrayList<Character>();
    private boolean _needsToSummon = false;
    private static final Map<String, CompanionManager> cache = new HashMap<String, CompanionManager>();

    public CompanionManager(ServerPlayer player) {
        this._player = player;
    }

    public static CompanionManager get(ServerPlayer player) {
        return cache.computeIfAbsent(player.getName().getString(), name -> {
            CompanionManager manager = new CompanionManager(player);
            manager.readFromNbt();
            return manager;
        });
    }

    public static void remove(ServerPlayer player) {
        cache.remove(player.getName().getString());
    }

    public void summonAllCompanionsAsync() {
        this._needsToSummon = true;
        CompletableFuture.supplyAsync(() -> CharacterUtils.requestCharacters((Player)this._player, (String)"player2-ai-npc-minecraft")).thenAcceptAsync(characters -> {
            this._assignedCharacters = new ArrayList<Character>(Arrays.asList(characters));
        }, (Executor)this._player.getServer());
    }

    private void summonCompanions() {
        if (!this._assignedCharacters.isEmpty()) {
            List<String> assignedNames = this._assignedCharacters.stream().map(c -> c.name()).toList();
            ArrayList toDismiss = new ArrayList();
            this._companionMap.forEach((name, uuid) -> {
                if (!assignedNames.contains(name)) {
                    toDismiss.add(name);
                }
            });
            toDismiss.forEach(this::dismissCompanion);
            this._assignedCharacters.stream().filter(character -> character != null).forEach(character -> {
                LOGGER.info("summonCompanions for character={}", character);
                this.ensureCompanionExists((Character)character);
            });
            this._assignedCharacters.clear();
            this.writeToNbt();
        }
    }

    public void ensureCompanionExists(Character character) {
        LOGGER.info("ensureCompanionExists for character={}", (Object)character);
        if (this._player.level() != null && this._player.getServer() != null) {
            LOGGER.info("ensureCompanionExists NOTNULL");
            UUID companionUuid = this._companionMap.get(character.name());
            ServerLevel world = this._player.serverLevel();
            if (this._despawnedCompanionData.containsKey(character.name())) {
                LOGGER.info("ensureCompanionExists DESPAWNED");
                try {
                    CompoundTag savedState = this._despawnedCompanionData.remove(character.name());
                    AutomatoneEntity restoredCompanion = new AutomatoneEntity(this._player.level(), character, (Player)this._player);
                    restoredCompanion.readAdditionalSaveData(savedState);
                    BlockPos spawnPos = this._player.blockPosition().offset(this._player.getRandom().nextInt(3) - 1, 1, this._player.getRandom().nextInt(3) - 1);
                    restoredCompanion.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, this._player.getYRot(), 0.0f);
                    world.addFreshEntity((Entity)restoredCompanion);
                    this._companionMap.put(character.name(), restoredCompanion.getUUID());
                    PrintStream var10000 = System.out;
                    String var10001 = character.name();
                    LOGGER.info("Restored companion from saved state: " + var10001 + " for player " + this._player.getName().getString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.writeToNbt();
            } else {
                Entity existingCompanion = companionUuid != null ? world.getEntity(companionUuid) : null;
                BlockPos spawnPos = this._player.blockPosition().offset(this._player.getRandom().nextInt(3) - 1, 1, this._player.getRandom().nextInt(3) - 1);
                if (existingCompanion instanceof AutomatoneEntity && existingCompanion.isAlive()) {
                    LOGGER.info("ensureCompanionExists TP");
                    existingCompanion.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                    PrintStream var11 = System.out;
                    String var13 = character.name();
                    var11.println("Teleported existing companion: " + var13 + " for player " + this._player.getName().getString());
                } else {
                    LOGGER.info("ensureCompanionExists SPAWN");
                    try {
                        AutomatoneEntity newCompanion = new AutomatoneEntity(this._player.level(), character, (Player)this._player);
                        newCompanion.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, this._player.getYRot(), 0.0f);
                        world.addFreshEntity((Entity)newCompanion);
                        this._companionMap.put(character.name(), newCompanion.getUUID());
                        PrintStream var10 = System.out;
                        String var12 = character.name();
                        var10.println("Summoned new companion: " + var12 + " for player " + this._player.getName().getString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.writeToNbt();
                }
            }
        }
    }

    public void dismissCompanion(String characterName) {
        UUID companionUuid = this._companionMap.remove(characterName);
        if (companionUuid != null && this._player.getServer() != null) {
            for (ServerLevel world : this._player.getServer().getAllLevels()) {
                Entity companion = world.getEntity(companionUuid);
                if (!(companion instanceof AutomatoneEntity)) continue;
                AutomatoneEntity automatone = (AutomatoneEntity)companion;
                CompoundTag savedState = new CompoundTag();
                automatone.addAdditionalSaveData(savedState);
                this._despawnedCompanionData.put(characterName, savedState);
                companion.discard();
                System.out.println("Dismissed companion: " + characterName + " for player " + this._player.getName().getString());
                this.writeToNbt();
                return;
            }
        }
    }

    public void dismissAllCompanions() {
        ArrayList<String> names = new ArrayList<String>(this._companionMap.keySet());
        names.forEach(this::dismissCompanion);
        this._companionMap.clear();
    }

    public List<AutomatoneEntity> getActiveCompanions() {
        ArrayList<AutomatoneEntity> companions = new ArrayList<AutomatoneEntity>();
        if (this._player.getServer() == null) {
            return companions;
        }
        block0: for (UUID uuid : this._companionMap.values()) {
            for (ServerLevel world : this._player.getServer().getAllLevels()) {
                AutomatoneEntity companion;
                Entity entity = world.getEntity(uuid);
                if (!(entity instanceof AutomatoneEntity) || !(companion = (AutomatoneEntity)entity).isAlive()) continue;
                companions.add(companion);
                continue block0;
            }
        }
        return companions;
    }

    public void serverTick() {
        if (this._needsToSummon && !this._assignedCharacters.isEmpty()) {
            this.summonCompanions();
            this._needsToSummon = false;
        }
    }

    public void readFromNbt() {
        CompoundTag tag = ((IEntityPersistentData)this._player).getPersistentData();
        if (tag.isEmpty()) {
            return;
        }
        this._companionMap.clear();
        this._despawnedCompanionData.clear();
        CompoundTag companionsTag = tag.getCompound("companions");
        for (String key : companionsTag.getAllKeys()) {
            this._companionMap.put(key, companionsTag.getUUID(key));
        }
        CompoundTag despawnedTag = tag.getCompound("despawnedCompanions");
        for (String key : despawnedTag.getAllKeys()) {
            this._despawnedCompanionData.put(key, despawnedTag.getCompound(key));
        }
    }

    public void writeToNbt() {
        CompoundTag tag = ((IEntityPersistentData)this._player).getPersistentData();
        CompoundTag companionsTag = new CompoundTag();
        this._companionMap.forEach((arg_0, arg_1) -> ((CompoundTag)companionsTag).putUUID(arg_0, arg_1));
        tag.put("companions", (Tag)companionsTag);
        CompoundTag despawnedTag = new CompoundTag();
        this._despawnedCompanionData.forEach((arg_0, arg_1) -> ((CompoundTag)despawnedTag).put(arg_0, arg_1));
        tag.put("despawnedCompanions", (Tag)despawnedTag);
    }
}

