/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.network;

import com.goodbird.player2npc.Player2NPC;
import com.goodbird.player2npc.companion.AutomatoneEntity;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AutomatonSpawnPacket {
    private final int id;
    private final UUID uuid;
    private final Vec3 pos;
    private final Vec3 velocity;
    private final float pitch;
    private final float yaw;
    private final Character character;
    private final LivingEntityInventory inventory;

    private AutomatonSpawnPacket(AutomatoneEntity entity) {
        this.id = entity.getId();
        this.uuid = entity.getUUID();
        this.pos = entity.position();
        this.velocity = entity.getDeltaMovement();
        this.pitch = entity.getXRot();
        this.yaw = entity.getYRot();
        this.character = entity.getCharacter();
        this.inventory = entity.inventory;
    }

    public AutomatonSpawnPacket(RegistryFriendlyByteBuf buf) {
        this.id = buf.readVarInt();
        this.uuid = buf.readUUID();
        this.pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.velocity = new Vec3((double)buf.readShort(), (double)buf.readShort(), (double)buf.readShort());
        this.pitch = (float)(buf.readByte() * 360) / 256.0f;
        this.yaw = (float)(buf.readByte() * 360) / 256.0f;
        this.character = CharacterUtils.readFromBuf((FriendlyByteBuf)buf);
        this.inventory = new LivingEntityInventory((LivingEntity)null);
        this.inventory.readNbt((HolderLookup.Provider)buf.registryAccess(), buf.readNbt().getList("inv", 10));
    }

    public static Packet<ClientGamePacketListener> create(RegistryAccess access, AutomatoneEntity entity) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), access);
        new AutomatonSpawnPacket(entity).write(access, (FriendlyByteBuf)buf);
        return NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)Player2NPC.SPAWN_PACKET_ID, (RegistryFriendlyByteBuf)buf);
    }

    public void write(RegistryAccess access, FriendlyByteBuf buf) {
        buf.writeVarInt(this.id);
        buf.writeUUID(this.uuid);
        buf.writeDouble(this.pos.x);
        buf.writeDouble(this.pos.y);
        buf.writeDouble(this.pos.z);
        buf.writeShort((int)(Math.min(3.9, this.velocity.x) * 8000.0));
        buf.writeShort((int)(Math.min(3.9, this.velocity.y) * 8000.0));
        buf.writeShort((int)(Math.min(3.9, this.velocity.z) * 8000.0));
        buf.writeByte((int)((byte)(this.pitch * 256.0f / 360.0f)));
        buf.writeByte((int)((byte)(this.yaw * 256.0f / 360.0f)));
        CharacterUtils.writeToBuf((FriendlyByteBuf)buf, (Character)this.character);
        CompoundTag compound = new CompoundTag();
        compound.put("inv", (Tag)this.inventory.writeNbt((HolderLookup.Provider)access, new ListTag()));
        buf.writeNbt((Tag)compound);
    }

    public static void handle(RegistryFriendlyByteBuf var3, NetworkManager.PacketContext var4) {
        AutomatonSpawnPacket packet = new AutomatonSpawnPacket(var3);
        var4.queue(() -> {
            ClientLevel world = (ClientLevel)var4.getPlayer().level();
            AutomatoneEntity entity = new AutomatoneEntity((EntityType<? extends AutomatoneEntity>)((EntityType)Player2NPC.AUTOMATONE.get()), (Level)world);
            entity.setId(packet.id);
            entity.setUUID(packet.uuid);
            entity.syncPacketPositionCodec(packet.pos.x, packet.pos.y, packet.pos.z);
            entity.moveTo(packet.pos.x, packet.pos.y, packet.pos.z);
            entity.setDeltaMovement(packet.velocity);
            entity.setXRot(packet.pitch);
            entity.setYRot(packet.yaw);
            entity.setCharacter(packet.character);
            packet.inventory.player = entity;
            entity.inventory = packet.inventory;
            world.addEntity((Entity)entity);
        });
    }
}

