/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc;

import com.goodbird.player2npc.companion.AutomatoneEntity;
import com.goodbird.player2npc.companion.CompanionManager;
import com.goodbird.player2npc.network.AutomatoneDespawnRequestPacket;
import com.goodbird.player2npc.network.AutomatoneSpawnRequestPacket;
import com.player2.playerengine.PlayerEngineController;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Zombie;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Player2NPC {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "player2npc";
    public static final ResourceLocation SPAWN_PACKET_ID = new ResourceLocation("player2npc", "spawn_automatone");
    public static final ResourceLocation SPAWN_REQUEST_PACKET_ID = new ResourceLocation("player2npc", "request_spawn_automatone");
    public static final ResourceLocation DESPAWN_REQUEST_PACKET_ID = new ResourceLocation("player2npc", "request_despawn_automatone");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"player2npc", (ResourceKey)Registries.f_256939_);
    public static RegistrySupplier<EntityType<AutomatoneEntity>> AUTOMATONE = ENTITY_TYPES.register(Player2NPC.id("aicompanion"), () -> {
        LOGGER.info("REGISTER");
        EntityType AUTOMATONE = EntityType.Builder.m_20704_(AutomatoneEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(EntityType.f_20532_.m_20678_(), EntityType.f_20532_.m_20679_()).m_20702_(64).m_20717_(1).m_20712_(Player2NPC.id("aicompanion").toString());
        LOGGER.info("CREATE");
        return AUTOMATONE;
    });

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static void onInitialize() {
        LOGGER.info("INIT");
        ENTITY_TYPES.register();
        EntityAttributeRegistry.register(AUTOMATONE, Zombie::m_34328_);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)SPAWN_REQUEST_PACKET_ID, AutomatoneSpawnRequestPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)DESPAWN_REQUEST_PACKET_ID, AutomatoneDespawnRequestPacket::handle);
        PlayerEvent.PLAYER_JOIN.register(player -> CompanionManager.get(player).summonAllCompanionsAsync());
        PlayerEvent.PLAYER_QUIT.register(player -> {
            CompanionManager.get(player).dismissAllCompanions();
            CompanionManager.remove(player);
        });
        TickEvent.SERVER_POST.register(PlayerEngineController::staticServerTick);
        TickEvent.PLAYER_POST.register(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CompanionManager.get(serverPlayer).serverTick();
            }
        });
    }
}

