/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.client.gui;

import com.goodbird.player2npc.client.gui.CharacterCardWidget;
import com.goodbird.player2npc.client.gui.CharacterDetailScreen;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class CharacterSelectionScreen
extends Screen {
    private Character[] characters = null;
    private boolean isLoading = true;

    public CharacterSelectionScreen() {
        super(Component.m_130674_((String)"Select a Character"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.isLoading = true;
        CompletableFuture.supplyAsync(() -> CharacterUtils.requestCharacters((Player)Minecraft.m_91087_().f_91074_, (String)"player2-ai-npc-minecraft")).thenAcceptAsync(result -> {
            this.characters = result;
            this.isLoading = false;
            this.f_96541_.execute(this::createCharacterCards);
        }, (Executor)this.f_96541_);
    }

    private void createCharacterCards() {
        if (this.characters != null && this.characters.length != 0) {
            int cardWidth = 100;
            int cardHeight = 130;
            int padding = 30;
            int cardsPerRow = Math.max(1, (this.f_96543_ - padding) / (cardWidth + padding));
            int totalWidth = cardsPerRow * (cardWidth + padding) - padding;
            int startX = this.f_96543_ / 2 - totalWidth / 2;
            int startY = 70;
            int currentX = startX;
            int currentY = startY;
            for (Character character : this.characters) {
                this.m_142416_((GuiEventListener)new CharacterCardWidget(currentX, currentY, cardWidth, cardHeight, character, this::onCharacterClicked));
                if ((currentX += cardWidth + padding) + cardWidth <= startX + totalWidth) continue;
                currentX = startX;
                currentY += cardHeight + padding;
            }
        }
    }

    private void onCharacterClicked(Character character) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new CharacterDetailScreen(this, character));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        graphics.m_280137_(this.f_96547_, "Select a Character", this.f_96543_ / 2, 20, 0xFFFFFF);
        if (this.isLoading) {
            graphics.m_280137_(this.f_96547_, "Loading...", this.f_96543_ / 2, this.f_96544_ / 2, 0xAAAAAA);
        }
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }
}

