/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.client.render;

import com.goodbird.player2npc.client.util.ImageDownloadAlt;
import com.goodbird.player2npc.client.util.ResourceDownloader;
import com.goodbird.player2npc.companion.AutomatoneEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;

public class RenderAutomaton
extends LivingEntityRenderer<AutomatoneEntity, PlayerModel<AutomatoneEntity>> {
    public RenderAutomaton(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new PlayerModel(ctx.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        boolean slim = false;
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(ctx.m_174023_(slim ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(ctx.m_174023_(slim ? ModelLayers.f_171168_ : ModelLayers.f_171165_)), ctx.m_266367_()));
        this.m_115326_((RenderLayer)new PlayerItemInHandLayer((RenderLayerParent)this, ctx.m_234598_()));
        this.m_115326_((RenderLayer)new ArrowLayer(ctx, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, ctx.m_174027_(), ctx.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, ctx.m_174027_()));
        this.m_115326_((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, ctx.m_174027_()));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
    }

    public void render(AutomatoneEntity automatoneEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        try {
            this.setModelPose(automatoneEntity);
            super.m_7392_((LivingEntity)automatoneEntity, f, g, matrixStack, vertexConsumerProvider, i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vec3 getPositionOffset(AutomatoneEntity automatoneEntity, float f) {
        return automatoneEntity.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)automatoneEntity, f);
    }

    private void setModelPose(AutomatoneEntity player) {
        PlayerModel playerEntityModel = (PlayerModel)this.m_7200_();
        if (player.m_5833_()) {
            playerEntityModel.m_8009_(false);
            playerEntityModel.f_102808_.f_104207_ = true;
            playerEntityModel.f_102809_.f_104207_ = true;
        } else {
            playerEntityModel.m_8009_(true);
            playerEntityModel.f_102809_.f_104207_ = true;
            playerEntityModel.f_103378_.f_104207_ = true;
            playerEntityModel.f_103376_.f_104207_ = true;
            playerEntityModel.f_103377_.f_104207_ = true;
            playerEntityModel.f_103374_.f_104207_ = true;
            playerEntityModel.f_103375_.f_104207_ = true;
            playerEntityModel.f_102817_ = player.m_6047_();
            HumanoidModel.ArmPose armPose = RenderAutomaton.getArmPose(player, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose armPose2 = RenderAutomaton.getArmPose(player, InteractionHand.OFF_HAND);
            if (armPose.m_102897_()) {
                HumanoidModel.ArmPose armPose3 = armPose2 = player.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                playerEntityModel.f_102816_ = armPose;
                playerEntityModel.f_102815_ = armPose2;
            } else {
                playerEntityModel.f_102816_ = armPose2;
                playerEntityModel.f_102815_ = armPose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(AutomatoneEntity player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (player.m_7655_() == hand && player.m_21212_() > 0) {
            UseAnim useAction = itemStack.m_41780_();
            if (useAction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useAction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useAction == UseAnim.CROSSBOW && hand == player.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useAction == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useAction == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (useAction == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!player.f_20911_ && itemStack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemStack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(AutomatoneEntity npc) {
        if (npc.textureLocation == null) {
            try {
                boolean fixSkin = true;
                File file = ResourceDownloader.getUrlFile(npc.getCharacter().skinURL(), fixSkin);
                npc.textureLocation = ResourceDownloader.getUrlResourceLocation(npc.getCharacter().skinURL(), fixSkin);
                this.loadSkin(file, npc.textureLocation, npc.getCharacter().skinURL(), fixSkin);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return npc.textureLocation == null ? DefaultPlayerSkin.m_118626_() : npc.textureLocation;
    }

    private void loadSkin(File file, ResourceLocation resource, String par1Str, boolean fix64) {
        TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
        AbstractTexture object = texturemanager.m_174786_(resource, (AbstractTexture)null);
        if (object == null) {
            ResourceDownloader.load(new ImageDownloadAlt(file, par1Str, resource, DefaultPlayerSkin.m_118626_(), fix64, () -> {}));
        }
    }

    protected void scale(AutomatoneEntity automatoneEntity, PoseStack matrixStack, float f) {
        float g = 0.9375f;
        matrixStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    protected void setupTransforms(AutomatoneEntity automatoneEntity, PoseStack matrixStack, float f, float g, float h) {
        float i = automatoneEntity.m_20998_(h);
        if (automatoneEntity.m_21255_()) {
            super.m_7523_((LivingEntity)automatoneEntity, matrixStack, f, g, h);
            float j = (float)automatoneEntity.m_21256_() + h;
            float k = Mth.m_14036_((float)(j * j / 100.0f), (float)0.0f, (float)1.0f);
            if (!automatoneEntity.m_21209_()) {
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(k * (-90.0f - automatoneEntity.m_146909_())));
            }
            Vec3 vec3d = automatoneEntity.m_20252_(h);
            Vec3 vec3d2 = automatoneEntity.lerpVelocity(h);
            double d = vec3d2.m_165925_();
            double e = vec3d.m_165925_();
            if (d > 0.0 && e > 0.0) {
                double l = (vec3d2.f_82479_ * vec3d.f_82479_ + vec3d2.f_82481_ * vec3d.f_82481_) / Math.sqrt(d * e);
                double m = vec3d2.f_82479_ * vec3d.f_82481_ - vec3d2.f_82481_ * vec3d.f_82479_;
                matrixStack.m_252781_(Axis.f_252436_.m_252961_((float)(Math.signum(m) * Math.acos(l))));
            }
        } else if (i > 0.0f) {
            super.m_7523_((LivingEntity)automatoneEntity, matrixStack, f, g, h);
            float j = automatoneEntity.m_20069_() ? -90.0f - automatoneEntity.m_146909_() : -90.0f;
            float k = Mth.m_14179_((float)i, (float)0.0f, (float)j);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(k));
            if (automatoneEntity.m_6067_()) {
                matrixStack.m_252880_(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)automatoneEntity, matrixStack, f, g, h);
        }
    }
}

