/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.companion;

import com.goodbird.player2npc.Player2NPC;
import com.goodbird.player2npc.network.AutomatonSpawnPacket;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.entity.IAutomatone;
import com.player2.playerengine.automaton.api.entity.IHungerManagerProvider;
import com.player2.playerengine.automaton.api.entity.IInteractionManagerProvider;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityHungerManager;
import com.player2.playerengine.automaton.api.entity.LivingEntityInteractionManager;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.manager.ConversationManager;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AutomatoneEntity
extends LivingEntity
implements IAutomatone,
IInventoryProvider,
IInteractionManagerProvider,
IHungerManagerProvider {
    public LivingEntityInteractionManager manager;
    public LivingEntityInventory inventory;
    public LivingEntityHungerManager hungerManager;
    public PlayerEngineController controller;
    public Character character;
    public ResourceLocation textureLocation;
    protected Vec3 lastVelocity;
    public static final String PLAYER2_GAME_ID = "player2-ai-npc-minecraft";

    public AutomatoneEntity(EntityType<? extends AutomatoneEntity> type, Level world) {
        super(type, world);
        this.init();
    }

    public void init() {
        this.m_274367_(0.6f);
        this.m_7910_(0.4f);
        this.manager = new LivingEntityInteractionManager((LivingEntity)this);
        this.inventory = new LivingEntityInventory((LivingEntity)this);
        this.hungerManager = new LivingEntityHungerManager();
        if (!this.m_9236_().f_46443_ && this.character != null) {
            this.controller = new PlayerEngineController((IBaritone)IBaritone.KEY.get((Object)this), this.character, PLAYER2_GAME_ID);
            ConversationManager.sendGreeting((PlayerEngineController)this.controller, (Character)this.character);
        }
    }

    public AutomatoneEntity(Level world, Character character, Player owner) {
        super((EntityType)Player2NPC.AUTOMATONE.get(), world);
        this.setCharacter(character);
        this.init();
        this.controller.setOwner(owner);
    }

    public LivingEntityInventory getLivingInventory() {
        return this.inventory;
    }

    public LivingEntityInteractionManager getInteractionManager() {
        return this.manager;
    }

    public LivingEntityHungerManager getHungerManager() {
        return this.hungerManager;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("head_yaw")) {
            this.f_20885_ = tag.m_128457_("head_yaw");
        }
        ListTag nbtList = tag.m_128437_("Inventory", 10);
        this.inventory.readNbt(nbtList);
        this.inventory.selectedSlot = tag.m_128451_("SelectedItemSlot");
        if (this.character == null && tag.m_128441_("character")) {
            CompoundTag compound = tag.m_128469_("character");
            this.character = CharacterUtils.readFromNBT((CompoundTag)compound);
            if (this.controller == null) {
                this.controller = new PlayerEngineController((IBaritone)IBaritone.KEY.get((Object)this), this.character, PLAYER2_GAME_ID);
            }
            ConversationManager.sendGreeting((PlayerEngineController)this.controller, (Character)this.character);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("head_yaw", this.f_20885_);
        tag.m_128365_("Inventory", (Tag)this.inventory.writeNbt(new ListTag()));
        tag.m_128405_("SelectedItemSlot", this.inventory.selectedSlot);
        if (this.character != null) {
            CompoundTag compound = new CompoundTag();
            CharacterUtils.writeToNBT((CompoundTag)compound, (Character)this.character);
            tag.m_128365_("character", (Tag)compound);
        }
    }

    public void m_8119_() {
        this.lastVelocity = this.m_20184_();
        this.manager.update();
        this.inventory.updateItems();
        ++this.f_20922_;
        if (!this.m_9236_().f_46443_) {
            this.controller.serverTick();
        }
        super.m_8119_();
        this.m_21203_();
    }

    public void m_8107_() {
        if (this.m_20069_() && this.m_6144_() && this.m_6129_()) {
            this.m_21208_();
        }
        super.m_8107_();
        this.f_20885_ = this.m_146908_();
        this.pickupItems();
    }

    public void pickupItems() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.f_20890_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            Vec3i vec3i = new Vec3i(3, 3, 3);
            for (ItemEntity itemEntity : this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82377_((double)vec3i.m_123341_(), (double)vec3i.m_123342_(), (double)vec3i.m_123343_()))) {
                if (itemEntity.m_213877_() || itemEntity.m_32055_().m_41619_() || itemEntity.m_32063_()) continue;
                ItemStack itemStack = itemEntity.m_32055_();
                int i = itemStack.m_41613_();
                if (!this.getLivingInventory().insertStack(itemStack)) continue;
                this.m_7938_((Entity)itemEntity, i);
                if (!itemStack.m_41619_()) continue;
                itemEntity.m_146870_();
                itemStack.m_41764_(i);
            }
        }
    }

    public boolean m_7327_(Entity target) {
        boolean bl;
        int i;
        this.f_20922_ = 0;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float g = (float)this.m_21133_(Attributes.f_22282_);
        if (target instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)target).m_6336_());
            g += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            target.m_20254_(i * 4);
        }
        if (bl = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (g > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(g * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_(this, target);
            this.m_21335_(target);
        }
        return bl;
    }

    public void m_147240_(double strength, double x, double z) {
        if (this.f_19864_) {
            super.m_147240_(strength, x, z);
        }
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.getLivingInventory().armor;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            return this.inventory.getMainHandStack();
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return (ItemStack)this.inventory.offHand.get(0);
        }
        return slot.m_20743_() == EquipmentSlot.Type.ARMOR ? (ItemStack)this.inventory.armor.get(slot.m_20749_()) : ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            this.inventory.m_6836_(this.inventory.selectedSlot, stack);
        } else if (slot == EquipmentSlot.OFFHAND) {
            this.inventory.offHand.set(0, (Object)stack);
        } else if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            this.inventory.armor.set(slot.m_20749_(), (Object)stack);
        }
    }

    public Character getCharacter() {
        return this.character;
    }

    public void setCharacter(Character character) {
        this.character = character;
    }

    public Vec3 lerpVelocity(float delta) {
        return this.lastVelocity.m_165921_(this.m_20184_(), (double)delta);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return AutomatonSpawnPacket.create(this);
    }

    public Component m_5446_() {
        return this.character == null ? super.m_5446_() : Component.m_237113_((String)this.character.shortName());
    }
}

