/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.companion;

import com.goodbird.player2npc.companion.AutomatoneEntity;
import com.goodbird.player2npc.mixins.IEntityPersistentData;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.CharacterUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompanionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerPlayer _player;
    private final Map<String, UUID> _companionMap = new ConcurrentHashMap<String, UUID>();
    private final Map<String, CompoundTag> _despawnedCompanionData = new ConcurrentHashMap<String, CompoundTag>();
    private List<Character> _assignedCharacters = new ArrayList<Character>();
    private boolean _needsToSummon = false;
    private static final Map<String, CompanionManager> cache = new HashMap<String, CompanionManager>();

    public CompanionManager(ServerPlayer player) {
        this._player = player;
    }

    public static CompanionManager get(ServerPlayer player) {
        return cache.computeIfAbsent(player.m_7755_().getString(), name -> {
            CompanionManager manager = new CompanionManager(player);
            manager.readFromNbt();
            return manager;
        });
    }

    public static void remove(ServerPlayer player) {
        cache.remove(player.m_7755_().getString());
    }

    public void summonAllCompanionsAsync() {
        this._needsToSummon = true;
        CompletableFuture.supplyAsync(() -> CharacterUtils.requestCharacters((Player)this._player, (String)"player2-ai-npc-minecraft")).thenAcceptAsync(characters -> {
            this._assignedCharacters = new ArrayList<Character>(Arrays.asList(characters));
        }, (Executor)this._player.m_20194_());
    }

    private void summonCompanions() {
        if (!this._assignedCharacters.isEmpty()) {
            List<String> assignedNames = this._assignedCharacters.stream().map(c -> c.name()).toList();
            ArrayList toDismiss = new ArrayList();
            this._companionMap.forEach((name, uuid) -> {
                if (!assignedNames.contains(name)) {
                    toDismiss.add(name);
                }
            });
            toDismiss.forEach(this::dismissCompanion);
            this._assignedCharacters.stream().filter(character -> character != null).forEach(character -> {
                LOGGER.info("summonCompanions for character={}", character);
                this.ensureCompanionExists((Character)character);
            });
            this._assignedCharacters.clear();
            this.writeToNbt();
        }
    }

    public void ensureCompanionExists(Character character) {
        LOGGER.info("ensureCompanionExists for character={}", (Object)character);
        if (this._player.m_9236_() != null && this._player.m_20194_() != null) {
            LOGGER.info("ensureCompanionExists NOTNULL");
            UUID companionUuid = this._companionMap.get(character.name());
            ServerLevel world = this._player.m_284548_();
            if (this._despawnedCompanionData.containsKey(character.name())) {
                LOGGER.info("ensureCompanionExists DESPAWNED");
                try {
                    CompoundTag savedState = this._despawnedCompanionData.remove(character.name());
                    AutomatoneEntity restoredCompanion = new AutomatoneEntity(this._player.m_9236_(), character, (Player)this._player);
                    restoredCompanion.m_7378_(savedState);
                    BlockPos spawnPos = this._player.m_20183_().m_7918_(this._player.m_217043_().m_188503_(3) - 1, 1, this._player.m_217043_().m_188503_(3) - 1);
                    restoredCompanion.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, this._player.m_146908_(), 0.0f);
                    world.m_7967_((Entity)restoredCompanion);
                    this._companionMap.put(character.name(), restoredCompanion.m_20148_());
                    PrintStream var10000 = System.out;
                    String var10001 = character.name();
                    LOGGER.info("Restored companion from saved state: " + var10001 + " for player " + this._player.m_7755_().getString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.writeToNbt();
            } else {
                Entity existingCompanion = companionUuid != null ? world.m_8791_(companionUuid) : null;
                BlockPos spawnPos = this._player.m_20183_().m_7918_(this._player.m_217043_().m_188503_(3) - 1, 1, this._player.m_217043_().m_188503_(3) - 1);
                if (existingCompanion instanceof AutomatoneEntity && existingCompanion.m_6084_()) {
                    LOGGER.info("ensureCompanionExists TP");
                    existingCompanion.m_20324_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
                    PrintStream var11 = System.out;
                    String var13 = character.name();
                    var11.println("Teleported existing companion: " + var13 + " for player " + this._player.m_7755_().getString());
                } else {
                    LOGGER.info("ensureCompanionExists SPAWN");
                    try {
                        AutomatoneEntity newCompanion = new AutomatoneEntity(this._player.m_9236_(), character, (Player)this._player);
                        newCompanion.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, this._player.m_146908_(), 0.0f);
                        world.m_7967_((Entity)newCompanion);
                        this._companionMap.put(character.name(), newCompanion.m_20148_());
                        PrintStream var10 = System.out;
                        String var12 = character.name();
                        var10.println("Summoned new companion: " + var12 + " for player " + this._player.m_7755_().getString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.writeToNbt();
                }
            }
        }
    }

    public void dismissCompanion(String characterName) {
        UUID companionUuid = this._companionMap.remove(characterName);
        if (companionUuid != null && this._player.m_20194_() != null) {
            for (ServerLevel world : this._player.m_20194_().m_129785_()) {
                Entity companion = world.m_8791_(companionUuid);
                if (!(companion instanceof AutomatoneEntity)) continue;
                AutomatoneEntity automatone = (AutomatoneEntity)companion;
                CompoundTag savedState = new CompoundTag();
                automatone.m_7380_(savedState);
                this._despawnedCompanionData.put(characterName, savedState);
                companion.m_146870_();
                System.out.println("Dismissed companion: " + characterName + " for player " + this._player.m_7755_().getString());
                this.writeToNbt();
                return;
            }
        }
    }

    public void dismissAllCompanions() {
        ArrayList<String> names = new ArrayList<String>(this._companionMap.keySet());
        names.forEach(this::dismissCompanion);
        this._companionMap.clear();
    }

    public List<AutomatoneEntity> getActiveCompanions() {
        ArrayList<AutomatoneEntity> companions = new ArrayList<AutomatoneEntity>();
        if (this._player.m_20194_() == null) {
            return companions;
        }
        block0: for (UUID uuid : this._companionMap.values()) {
            for (ServerLevel world : this._player.m_20194_().m_129785_()) {
                AutomatoneEntity companion;
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof AutomatoneEntity) || !(companion = (AutomatoneEntity)entity).m_6084_()) continue;
                companions.add(companion);
                continue block0;
            }
        }
        return companions;
    }

    public void serverTick() {
        if (this._needsToSummon && !this._assignedCharacters.isEmpty()) {
            this.summonCompanions();
            this._needsToSummon = false;
        }
    }

    public void readFromNbt() {
        CompoundTag tag = ((IEntityPersistentData)this._player).getPersistentData();
        if (tag.m_128456_()) {
            return;
        }
        this._companionMap.clear();
        this._despawnedCompanionData.clear();
        CompoundTag companionsTag = tag.m_128469_("companions");
        for (String key : companionsTag.m_128431_()) {
            this._companionMap.put(key, companionsTag.m_128342_(key));
        }
        CompoundTag despawnedTag = tag.m_128469_("despawnedCompanions");
        for (String key : despawnedTag.m_128431_()) {
            this._despawnedCompanionData.put(key, despawnedTag.m_128469_(key));
        }
    }

    public void writeToNbt() {
        CompoundTag tag = ((IEntityPersistentData)this._player).getPersistentData();
        CompoundTag companionsTag = new CompoundTag();
        this._companionMap.forEach((arg_0, arg_1) -> ((CompoundTag)companionsTag).m_128362_(arg_0, arg_1));
        tag.m_128365_("companions", (Tag)companionsTag);
        CompoundTag despawnedTag = new CompoundTag();
        this._despawnedCompanionData.forEach((arg_0, arg_1) -> ((CompoundTag)despawnedTag).m_128365_(arg_0, arg_1));
        tag.m_128365_("despawnedCompanions", (Tag)despawnedTag);
    }
}

