/*
 * Decompiled with CFR 0.152.
 */
package com.goodbird.player2npc.mixins.impl;

import com.goodbird.player2npc.mixins.IEntityPersistentData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityPersistentData
implements IEntityPersistentData {
    @Unique
    private CompoundTag CNPC_tag;

    @Override
    @Unique
    public CompoundTag getPersistentData() {
        if (this.CNPC_tag == null) {
            this.CNPC_tag = new CompoundTag();
        }
        return this.CNPC_tag;
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="TAIL")})
    public void save(CompoundTag compound, CallbackInfoReturnable<CompoundTag> cir) {
        if (this.CNPC_tag != null && this instanceof LivingEntity) {
            compound.m_128365_("Player2NPC_persistantData", (Tag)this.CNPC_tag);
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void read(CompoundTag compound, CallbackInfo ci) {
        if (compound.m_128441_("Player2NPC_persistantData") && this instanceof LivingEntity) {
            this.CNPC_tag = compound.m_128469_("Player2NPC_persistantData");
        }
    }
}

